package org.glowroot.local.ui;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.MethodNamesRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MethodNamesRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.MethodNamesRequestBase"})
@Immutable
final class MethodNamesRequest
    extends InstrumentationJsonService.MethodNamesRequestBase {
  private final String className;
  private final String partialMethodName;
  private final int limit;

  private MethodNamesRequest(String className, String partialMethodName, int limit) {
    this.className = className;
    this.partialMethodName = partialMethodName;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code partialMethodName} attribute
   */
  @Override
  public String partialMethodName() {
    return partialMethodName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodNamesRequestBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final MethodNamesRequest withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodNamesRequest(newValue, this.partialMethodName, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodNamesRequestBase#partialMethodName() partialMethodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for partialMethodName
   * @return modified copy of the {@code this} object
   */
  public final MethodNamesRequest withPartialMethodName(String value) {
    if (this.partialMethodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MethodNamesRequest(this.className, newValue, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.MethodNamesRequestBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final MethodNamesRequest withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new MethodNamesRequest(this.className, this.partialMethodName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MethodNamesRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MethodNamesRequest && equalTo((MethodNamesRequest) another));
  }
  
  private boolean equalTo(MethodNamesRequest another) {
    return className.equals(another.className)
        && partialMethodName.equals(another.partialMethodName)
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code partialMethodName}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + partialMethodName.hashCode();
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code MethodNamesRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MethodNamesRequest")
        .add("className", className)
        .add("partialMethodName", partialMethodName)
        .add("limit", limit)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.MethodNamesRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MethodNamesRequest instance
   */
  static MethodNamesRequest copyOf(InstrumentationJsonService.MethodNamesRequestBase instance) {
    if (instance instanceof MethodNamesRequest) {
      return (MethodNamesRequest) instance;
    }
    return MethodNamesRequest.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MethodNamesRequest}.
   * @return new MethodNamesRequest builder
   */
  static MethodNamesRequest.Builder builder() {
    return new MethodNamesRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MethodNamesRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_PARTIAL_METHOD_NAME = 0x2L;
    private static final long INITIALIZED_BIT_LIMIT = 0x4L;
    private long initializedBitset;
  
    private @Nullable String className;
    private @Nullable String partialMethodName;
    private int limit;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link InstrumentationJsonService.MethodNamesRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(InstrumentationJsonService.MethodNamesRequestBase instance) {
      Preconditions.checkNotNull(instance);
      className(instance.className());
      partialMethodName(instance.partialMethodName());
      limit(instance.limit());
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodNamesRequestBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodNamesRequestBase#partialMethodName() partialMethodName}.
     * @param partialMethodName value for partialMethodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder partialMethodName(String partialMethodName) {
      this.partialMethodName = Preconditions.checkNotNull(partialMethodName);
      initializedBitset |= INITIALIZED_BIT_PARTIAL_METHOD_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.MethodNamesRequestBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MethodNamesRequest}.
     * @return immutable instance of MethodNamesRequest
     */
    public org.glowroot.local.ui.MethodNamesRequest build() {
      checkRequiredAttributes();
      return new MethodNamesRequest(className, partialMethodName, limit);
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private boolean partialMethodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PARTIAL_METHOD_NAME) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      if (!partialMethodNameIsSet()) {
        attributes.add("partialMethodName");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build MethodNamesRequest, some of required attributes are not set " + attributes;
    }
  }
}
