package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PropertyDescriptor;

/**
 * Immutable implementation of {@link ConfigJsonService.PluginConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.PluginConfigResponseBase"})
@Immutable
final class PluginConfigResponse
    extends ConfigJsonService.PluginConfigResponseBase {
  private final String name;
  private final PluginConfigDto config;
  private final ImmutableList<PropertyDescriptor> propertyDescriptors;

  private PluginConfigResponse(
      String name,
      PluginConfigDto config,
      ImmutableList<PropertyDescriptor> propertyDescriptors) {
    this.name = name;
    this.config = config;
    this.propertyDescriptors = propertyDescriptors;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public PluginConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code propertyDescriptors} attribute
   */
  @JsonProperty("propertyDescriptors")
  @Override
  public ImmutableList<PropertyDescriptor> propertyDescriptors() {
    return propertyDescriptors;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginConfigResponseBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final PluginConfigResponse withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginConfigResponse(newValue, this.config, this.propertyDescriptors);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.PluginConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final PluginConfigResponse withConfig(PluginConfigDto value) {
    if (this.config == value) {
      return this;
    }
    PluginConfigDto newValue = Preconditions.checkNotNull(value);
    return new PluginConfigResponse(this.name, newValue, this.propertyDescriptors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginConfigResponse withPropertyDescriptors(PropertyDescriptor... elements) {
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginConfigResponse(this.name, this.config, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of propertyDescriptors elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginConfigResponse withPropertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
    if (this.propertyDescriptors == elements) {
      return this;
    }
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginConfigResponse(this.name, this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginConfigResponse && equalTo((PluginConfigResponse) another));
  }
  
  private boolean equalTo(PluginConfigResponse another) {
    return name.equals(another.name)
        && config.equals(another.config)
        && propertyDescriptors.equals(another.propertyDescriptors);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code config}, {@code propertyDescriptors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + config.hashCode();
    h = h * 17 + propertyDescriptors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginConfigResponse")
        .add("name", name)
        .add("config", config)
        .add("propertyDescriptors", propertyDescriptors)
        .toString();
  }
  
  @JsonCreator
  public static PluginConfigResponse fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("config") @Nullable PluginConfigDto config,
      @JsonProperty("propertyDescriptors") @Nullable ImmutableList<PropertyDescriptor> propertyDescriptors) {
    PluginConfigResponse.Builder builder = PluginConfigResponse.builder();
    if (name != null) {
      builder.name(name);
    }
    if (config != null) {
      builder.config(config);
    }
    if (propertyDescriptors != null) {
      builder.addAllPropertyDescriptors(propertyDescriptors);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.PluginConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PluginConfigResponse instance
   */
  static PluginConfigResponse copyOf(ConfigJsonService.PluginConfigResponseBase instance) {
    if (instance instanceof PluginConfigResponse) {
      return (PluginConfigResponse) instance;
    }
    return PluginConfigResponse.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.PluginConfigResponse}.
   * @return new PluginConfigResponse builder
   */
  static PluginConfigResponse.Builder builder() {
    return new PluginConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.PluginConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_CONFIG = 0x2L;
    private long initializedBitset;
  
    private @Nullable String name;
    private @Nullable PluginConfigDto config;
    private ImmutableList.Builder<PropertyDescriptor> propertyDescriptorsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ConfigJsonService.PluginConfigResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ConfigJsonService.PluginConfigResponseBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      config(instance.config());
      addAllPropertyDescriptors(instance.propertyDescriptors());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginConfigResponseBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.PluginConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(PluginConfigDto config) {
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Adds one element to {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors} list.
     * @param element propertyDescriptors element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPropertyDescriptors(PropertyDescriptor element) {
      propertyDescriptorsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors} list.
     * @param elements array of propertyDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPropertyDescriptors(PropertyDescriptor... elements) {
      propertyDescriptorsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors} list.
     * @param elements iterable of propertyDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder propertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
      propertyDescriptorsBuilder = ImmutableList.builder();
      return addAllPropertyDescriptors(elements);
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.PluginConfigResponseBase#propertyDescriptors() propertyDescriptors} list.
     * @param elements iterable of propertyDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllPropertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
      propertyDescriptorsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.PluginConfigResponse}.
     * @return immutable instance of PluginConfigResponse
     */
    public org.glowroot.local.ui.PluginConfigResponse build() {
      checkRequiredAttributes();
      return new PluginConfigResponse(name, config, propertyDescriptorsBuilder.build());
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!configIsSet()) {
        attributes.add("config");
      }
      return "Cannot build PluginConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
