package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TransactionJsonService.QueryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Query.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TransactionJsonService.QueryBase"})
@Immutable
final class Query extends TransactionJsonService.QueryBase {
  private final String queryType;
  private final String queryText;
  private final long totalMicros;
  private final long executionCount;
  private final long totalRows;

  private Query(
      String queryType,
      String queryText,
      long totalMicros,
      long executionCount,
      long totalRows) {
    this.queryType = queryType;
    this.queryText = queryText;
    this.totalMicros = totalMicros;
    this.executionCount = executionCount;
    this.totalRows = totalRows;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code queryType} attribute
   */
  @JsonProperty("queryType")
  @Override
  public String queryType() {
    return queryType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code queryText} attribute
   */
  @JsonProperty("queryText")
  @Override
  public String queryText() {
    return queryText;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalMicros} attribute
   */
  @JsonProperty("totalMicros")
  @Override
  public long totalMicros() {
    return totalMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code executionCount} attribute
   */
  @JsonProperty("executionCount")
  @Override
  public long executionCount() {
    return executionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalRows} attribute
   */
  @JsonProperty("totalRows")
  @Override
  public long totalRows() {
    return totalRows;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.QueryBase#queryType() queryType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for queryType
   * @return modified copy of the {@code this} object
   */
  public final Query withQueryType(String value) {
    if (this.queryType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Query(newValue, this.queryText, this.totalMicros, this.executionCount, this.totalRows);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.QueryBase#queryText() queryText}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for queryText
   * @return modified copy of the {@code this} object
   */
  public final Query withQueryText(String value) {
    if (this.queryText == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Query(this.queryType, newValue, this.totalMicros, this.executionCount, this.totalRows);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.QueryBase#totalMicros() totalMicros}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalMicros
   * @return modified copy of the {@code this} object
   */
  public final Query withTotalMicros(long value) {
    if (this.totalMicros == value) {
      return this;
    }
    long newValue = value;
    return new Query(this.queryType, this.queryText, newValue, this.executionCount, this.totalRows);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.QueryBase#executionCount() executionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for executionCount
   * @return modified copy of the {@code this} object
   */
  public final Query withExecutionCount(long value) {
    if (this.executionCount == value) {
      return this;
    }
    long newValue = value;
    return new Query(this.queryType, this.queryText, this.totalMicros, newValue, this.totalRows);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.QueryBase#totalRows() totalRows}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalRows
   * @return modified copy of the {@code this} object
   */
  public final Query withTotalRows(long value) {
    if (this.totalRows == value) {
      return this;
    }
    long newValue = value;
    return new Query(this.queryType, this.queryText, this.totalMicros, this.executionCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Query} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Query && equalTo((Query) another));
  }
  
  private boolean equalTo(Query another) {
    return queryType.equals(another.queryType)
        && queryText.equals(another.queryText)
        && totalMicros == another.totalMicros
        && executionCount == another.executionCount
        && totalRows == another.totalRows;
  }
  
  /**
   * Computes hash code from attributes: {@code queryType}, {@code queryText}, {@code totalMicros}, {@code executionCount}, {@code totalRows}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + queryType.hashCode();
    h = h * 17 + queryText.hashCode();
    h = h * 17 + Longs.hashCode(totalMicros);
    h = h * 17 + Longs.hashCode(executionCount);
    h = h * 17 + Longs.hashCode(totalRows);
    return h;
  }
  
  /**
   * Prints immutable value {@code Query{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Query")
        .add("queryType", queryType)
        .add("queryText", queryText)
        .add("totalMicros", totalMicros)
        .add("executionCount", executionCount)
        .add("totalRows", totalRows)
        .toString();
  }
  
  @JsonCreator
  public static Query fromAllAttributes(
      @JsonProperty("queryType") @Nullable String queryType,
      @JsonProperty("queryText") @Nullable String queryText,
      @JsonProperty("totalMicros") @Nullable Long totalMicros,
      @JsonProperty("executionCount") @Nullable Long executionCount,
      @JsonProperty("totalRows") @Nullable Long totalRows) {
    Query.Builder builder = Query.builder();
    if (queryType != null) {
      builder.queryType(queryType);
    }
    if (queryText != null) {
      builder.queryText(queryText);
    }
    if (totalMicros != null) {
      builder.totalMicros(totalMicros);
    }
    if (executionCount != null) {
      builder.executionCount(executionCount);
    }
    if (totalRows != null) {
      builder.totalRows(totalRows);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link TransactionJsonService.QueryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Query instance
   */
  static Query copyOf(TransactionJsonService.QueryBase instance) {
    if (instance instanceof Query) {
      return (Query) instance;
    }
    return Query.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.Query}.
   * @return new Query builder
   */
  static Query.Builder builder() {
    return new Query.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.Query}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_QUERY_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_QUERY_TEXT = 0x2L;
    private static final long INITIALIZED_BIT_TOTAL_MICROS = 0x4L;
    private static final long INITIALIZED_BIT_EXECUTION_COUNT = 0x8L;
    private static final long INITIALIZED_BIT_TOTAL_ROWS = 0x10L;
    private long initializedBitset;
  
    private @Nullable String queryType;
    private @Nullable String queryText;
    private long totalMicros;
    private long executionCount;
    private long totalRows;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link TransactionJsonService.QueryBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(TransactionJsonService.QueryBase instance) {
      Preconditions.checkNotNull(instance);
      queryType(instance.queryType());
      queryText(instance.queryText());
      totalMicros(instance.totalMicros());
      executionCount(instance.executionCount());
      totalRows(instance.totalRows());
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.QueryBase#queryType() queryType}.
     * @param queryType value for queryType
     * @return {@code this} builder for chained invocation
     */
    public final Builder queryType(String queryType) {
      this.queryType = Preconditions.checkNotNull(queryType);
      initializedBitset |= INITIALIZED_BIT_QUERY_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.QueryBase#queryText() queryText}.
     * @param queryText value for queryText
     * @return {@code this} builder for chained invocation
     */
    public final Builder queryText(String queryText) {
      this.queryText = Preconditions.checkNotNull(queryText);
      initializedBitset |= INITIALIZED_BIT_QUERY_TEXT;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.QueryBase#totalMicros() totalMicros}.
     * @param totalMicros value for totalMicros
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalMicros(long totalMicros) {
      this.totalMicros = totalMicros;
      initializedBitset |= INITIALIZED_BIT_TOTAL_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.QueryBase#executionCount() executionCount}.
     * @param executionCount value for executionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder executionCount(long executionCount) {
      this.executionCount = executionCount;
      initializedBitset |= INITIALIZED_BIT_EXECUTION_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.QueryBase#totalRows() totalRows}.
     * @param totalRows value for totalRows
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalRows(long totalRows) {
      this.totalRows = totalRows;
      initializedBitset |= INITIALIZED_BIT_TOTAL_ROWS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.Query}.
     * @return immutable instance of Query
     */
    public org.glowroot.local.ui.Query build() {
      checkRequiredAttributes();
      return new Query(queryType, queryText, totalMicros, executionCount, totalRows);
    }
  
    private boolean queryTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_QUERY_TYPE) != 0;
    }
  
    private boolean queryTextIsSet() {
      return (initializedBitset & INITIALIZED_BIT_QUERY_TEXT) != 0;
    }
  
    private boolean totalMicrosIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_MICROS) != 0;
    }
  
    private boolean executionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_EXECUTION_COUNT) != 0;
    }
  
    private boolean totalRowsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TOTAL_ROWS) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!queryTypeIsSet()) {
        attributes.add("queryType");
      }
      if (!queryTextIsSet()) {
        attributes.add("queryText");
      }
      if (!totalMicrosIsSet()) {
        attributes.add("totalMicros");
      }
      if (!executionCountIsSet()) {
        attributes.add("executionCount");
      }
      if (!totalRowsIsSet()) {
        attributes.add("totalRows");
      }
      return "Cannot build Query, some of required attributes are not set " + attributes;
    }
  }
}
