package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.SmtpConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code SmtpConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.SmtpConfigDtoBase"})
@Immutable
final class SmtpConfigDto extends ConfigJsonService.SmtpConfigDtoBase {
  private final String fromEmailAddress;
  private final String fromDisplayName;
  private final String host;
  private final @Nullable Integer port;
  private final boolean ssl;
  private final String username;
  private final boolean passwordExists;
  private final ImmutableMap<String, String> additionalProperties;
  private final String newPassword;
  private final @Nullable String testEmailRecipient;
  private final String version;

  private SmtpConfigDto(SmtpConfigDto.Builder builder) {
    this.fromEmailAddress = builder.fromEmailAddress;
    this.fromDisplayName = builder.fromDisplayName;
    this.host = builder.host;
    this.port = builder.port;
    this.ssl = builder.ssl;
    this.username = builder.username;
    this.passwordExists = builder.passwordExists;
    this.additionalProperties = builder.additionalPropertiesBuilder.build();
    this.testEmailRecipient = builder.testEmailRecipient;
    this.version = builder.version;
    this.newPassword = builder.newPassword != null
        ? builder.newPassword
        : Preconditions.checkNotNull(super.newPassword());
  }

  private SmtpConfigDto(
      String fromEmailAddress,
      String fromDisplayName,
      String host,
      @Nullable Integer port,
      boolean ssl,
      String username,
      boolean passwordExists,
      ImmutableMap<String, String> additionalProperties,
      String newPassword,
      @Nullable String testEmailRecipient,
      String version) {
    this.fromEmailAddress = fromEmailAddress;
    this.fromDisplayName = fromDisplayName;
    this.host = host;
    this.port = port;
    this.ssl = ssl;
    this.username = username;
    this.passwordExists = passwordExists;
    this.additionalProperties = additionalProperties;
    this.newPassword = newPassword;
    this.testEmailRecipient = testEmailRecipient;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fromEmailAddress} attribute
   */
  @JsonProperty("fromEmailAddress")
  @Override
  public String fromEmailAddress() {
    return fromEmailAddress;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fromDisplayName} attribute
   */
  @JsonProperty("fromDisplayName")
  @Override
  public String fromDisplayName() {
    return fromDisplayName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public String host() {
    return host;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public Integer port() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ssl} attribute
   */
  @JsonProperty("ssl")
  @Override
  public boolean ssl() {
    return ssl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code username} attribute
   */
  @JsonProperty("username")
  @Override
  public String username() {
    return username;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code passwordExists} attribute
   */
  @JsonProperty("passwordExists")
  @Override
  public boolean passwordExists() {
    return passwordExists;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @Override
  public ImmutableMap<String, String> additionalProperties() {
    return additionalProperties;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code newPassword} attribute
   */
  @JsonProperty("newPassword")
  @Override
  public String newPassword() {
    return newPassword;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code testEmailRecipient} attribute
   */
  @JsonProperty("testEmailRecipient")
  @Override
  public String testEmailRecipient() {
    return testEmailRecipient;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#fromEmailAddress() fromEmailAddress}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fromEmailAddress
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withFromEmailAddress(String value) {
    if (this.fromEmailAddress == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        newValue,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#fromDisplayName() fromDisplayName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fromDisplayName
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withFromDisplayName(String value) {
    if (this.fromDisplayName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        newValue,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#host() host}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for host
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withHost(String value) {
    if (this.host == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        newValue,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#port() port}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withPort(@Nullable Integer value) {
    if (this.port == value) {
      return this;
    }
    @Nullable Integer newValue = value;
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        newValue,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#ssl() ssl}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for ssl
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withSsl(boolean value) {
    if (this.ssl == value) {
      return this;
    }
    boolean newValue = value;
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        newValue,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#username() username}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for username
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withUsername(String value) {
    if (this.username == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        newValue,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#passwordExists() passwordExists}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for passwordExists
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withPasswordExists(boolean value) {
    if (this.passwordExists == value) {
      return this;
    }
    boolean newValue = value;
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        newValue,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by replacing {@link ConfigJsonService.SmtpConfigDtoBase#additionalProperties() additionalProperties} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to additionalProperties map
   * @return modified copy of {@code this} object
   */
  public final SmtpConfigDto withAdditionalProperties(Map<String, ? extends String> entries) {
    if (this.additionalProperties == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        newValue,
        this.newPassword,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#newPassword() newPassword}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for newPassword
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withNewPassword(String value) {
    if (this.newPassword == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        newValue,
        this.testEmailRecipient,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#testEmailRecipient() testEmailRecipient}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for testEmailRecipient, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withTestEmailRecipient(@Nullable String value) {
    if (this.testEmailRecipient == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.SmtpConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfigDto(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.passwordExists,
        this.additionalProperties,
        this.newPassword,
        this.testEmailRecipient,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code SmtpConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof SmtpConfigDto && equalTo((SmtpConfigDto) another));
  }
  
  private boolean equalTo(SmtpConfigDto another) {
    return fromEmailAddress.equals(another.fromEmailAddress)
        && fromDisplayName.equals(another.fromDisplayName)
        && host.equals(another.host)
        && Objects.equal(port, another.port)
        && ssl == another.ssl
        && username.equals(another.username)
        && passwordExists == another.passwordExists
        && additionalProperties.equals(another.additionalProperties)
        && newPassword.equals(another.newPassword)
        && Objects.equal(testEmailRecipient, another.testEmailRecipient)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code fromEmailAddress}, {@code fromDisplayName}, {@code host}, {@code port}, {@code ssl}, {@code username}, {@code passwordExists}, {@code additionalProperties}, {@code newPassword}, {@code testEmailRecipient}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + fromEmailAddress.hashCode();
    h = h * 17 + fromDisplayName.hashCode();
    h = h * 17 + host.hashCode();
    h = h * 17 + Objects.hashCode(port);
    h = h * 17 + Booleans.hashCode(ssl);
    h = h * 17 + username.hashCode();
    h = h * 17 + Booleans.hashCode(passwordExists);
    h = h * 17 + additionalProperties.hashCode();
    h = h * 17 + newPassword.hashCode();
    h = h * 17 + Objects.hashCode(testEmailRecipient);
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code SmtpConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SmtpConfigDto")
        .add("fromEmailAddress", fromEmailAddress)
        .add("fromDisplayName", fromDisplayName)
        .add("host", host)
        .add("port", port)
        .add("ssl", ssl)
        .add("username", username)
        .add("passwordExists", passwordExists)
        .add("additionalProperties", additionalProperties)
        .add("newPassword", newPassword)
        .add("testEmailRecipient", testEmailRecipient)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static SmtpConfigDto fromAllAttributes(
      @JsonProperty("fromEmailAddress") @Nullable String fromEmailAddress,
      @JsonProperty("fromDisplayName") @Nullable String fromDisplayName,
      @JsonProperty("host") @Nullable String host,
      @JsonProperty("port") @Nullable Integer port,
      @JsonProperty("ssl") @Nullable Boolean ssl,
      @JsonProperty("username") @Nullable String username,
      @JsonProperty("passwordExists") @Nullable Boolean passwordExists,
      @JsonProperty("additionalProperties") @Nullable Map<String, String> additionalProperties,
      @JsonProperty("newPassword") @Nullable String newPassword,
      @JsonProperty("testEmailRecipient") @Nullable String testEmailRecipient,
      @JsonProperty("version") @Nullable String version) {
    SmtpConfigDto.Builder builder = SmtpConfigDto.builder();
    if (fromEmailAddress != null) {
      builder.fromEmailAddress(fromEmailAddress);
    }
    if (fromDisplayName != null) {
      builder.fromDisplayName(fromDisplayName);
    }
    if (host != null) {
      builder.host(host);
    }
    if (port != null) {
      builder.port(port);
    }
    if (ssl != null) {
      builder.ssl(ssl);
    }
    if (username != null) {
      builder.username(username);
    }
    if (passwordExists != null) {
      builder.passwordExists(passwordExists);
    }
    if (additionalProperties != null) {
      builder.putAllAdditionalProperties(additionalProperties);
    }
    if (newPassword != null) {
      builder.newPassword(newPassword);
    }
    if (testEmailRecipient != null) {
      builder.testEmailRecipient(testEmailRecipient);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.SmtpConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable SmtpConfigDto instance
   */
  static SmtpConfigDto copyOf(ConfigJsonService.SmtpConfigDtoBase instance) {
    if (instance instanceof SmtpConfigDto) {
      return (SmtpConfigDto) instance;
    }
    return SmtpConfigDto.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.SmtpConfigDto}.
   * @return new SmtpConfigDto builder
   */
  static SmtpConfigDto.Builder builder() {
    return new SmtpConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.SmtpConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7f;
    private static final long INITIALIZED_BIT_FROM_EMAIL_ADDRESS = 0x1L;
    private static final long INITIALIZED_BIT_FROM_DISPLAY_NAME = 0x2L;
    private static final long INITIALIZED_BIT_HOST = 0x4L;
    private static final long INITIALIZED_BIT_SSL = 0x8L;
    private static final long INITIALIZED_BIT_USERNAME = 0x10L;
    private static final long INITIALIZED_BIT_PASSWORD_EXISTS = 0x20L;
    private static final long INITIALIZED_BIT_VERSION = 0x40L;
    private long initializedBitset;
  
    private @Nullable String fromEmailAddress;
    private @Nullable String fromDisplayName;
    private @Nullable String host;
    private @Nullable Integer port;
    private boolean ssl;
    private @Nullable String username;
    private boolean passwordExists;
    private ImmutableMap.Builder<String, String> additionalPropertiesBuilder = ImmutableMap.builder();
    private @Nullable String newPassword;
    private @Nullable String testEmailRecipient;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ConfigJsonService.SmtpConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ConfigJsonService.SmtpConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      fromEmailAddress(instance.fromEmailAddress());
      fromDisplayName(instance.fromDisplayName());
      host(instance.host());
      @Nullable Integer portValue = instance.port();
      if (portValue != null) {
        port(portValue);
      }
      ssl(instance.ssl());
      username(instance.username());
      passwordExists(instance.passwordExists());
      putAllAdditionalProperties(instance.additionalProperties());
      newPassword(instance.newPassword());
      @Nullable String testEmailRecipientValue = instance.testEmailRecipient();
      if (testEmailRecipientValue != null) {
        testEmailRecipient(testEmailRecipientValue);
      }
      version(instance.version());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#fromEmailAddress() fromEmailAddress}.
     * @param fromEmailAddress value for fromEmailAddress
     * @return {@code this} builder for chained invocation
     */
    public final Builder fromEmailAddress(String fromEmailAddress) {
      this.fromEmailAddress = Preconditions.checkNotNull(fromEmailAddress);
      initializedBitset |= INITIALIZED_BIT_FROM_EMAIL_ADDRESS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#fromDisplayName() fromDisplayName}.
     * @param fromDisplayName value for fromDisplayName
     * @return {@code this} builder for chained invocation
     */
    public final Builder fromDisplayName(String fromDisplayName) {
      this.fromDisplayName = Preconditions.checkNotNull(fromDisplayName);
      initializedBitset |= INITIALIZED_BIT_FROM_DISPLAY_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#host() host}.
     * @param host value for host
     * @return {@code this} builder for chained invocation
     */
    public final Builder host(String host) {
      this.host = Preconditions.checkNotNull(host);
      initializedBitset |= INITIALIZED_BIT_HOST;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#port() port}.
     * @param port value for port, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#ssl() ssl}.
     * @param ssl value for ssl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ssl(boolean ssl) {
      this.ssl = ssl;
      initializedBitset |= INITIALIZED_BIT_SSL;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#username() username}.
     * @param username value for username
     * @return {@code this} builder for chained invocation
     */
    public final Builder username(String username) {
      this.username = Preconditions.checkNotNull(username);
      initializedBitset |= INITIALIZED_BIT_USERNAME;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#passwordExists() passwordExists}.
     * @param passwordExists value for passwordExists
     * @return {@code this} builder for chained invocation
     */
    public final Builder passwordExists(boolean passwordExists) {
      this.passwordExists = passwordExists;
      initializedBitset |= INITIALIZED_BIT_PASSWORD_EXISTS;
      return this;
    }
  
    /**
     * Put one entry to {@link ConfigJsonService.SmtpConfigDtoBase#additionalProperties() additionalProperties} map.
     * @param key the key in additionalProperties map
     * @param value the associated value in additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAdditionalProperties(String key, String value) {
      additionalPropertiesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link ConfigJsonService.SmtpConfigDtoBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
      additionalPropertiesBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link ConfigJsonService.SmtpConfigDtoBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries to be added to additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder additionalProperties(Map<String, ? extends String> entries) {
      additionalPropertiesBuilder = ImmutableMap.builder();
      return putAllAdditionalProperties(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link ConfigJsonService.SmtpConfigDtoBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries to be added to additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
      additionalPropertiesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#newPassword() newPassword}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ConfigJsonService.SmtpConfigDtoBase#newPassword() newPassword}.</em>
     * @param newPassword value for newPassword
     * @return {@code this} builder for chained invocation
     */
    public final Builder newPassword(String newPassword) {
      this.newPassword = Preconditions.checkNotNull(newPassword);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#testEmailRecipient() testEmailRecipient}.
     * @param testEmailRecipient value for testEmailRecipient, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder testEmailRecipient(@Nullable String testEmailRecipient) {
      this.testEmailRecipient = testEmailRecipient;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.SmtpConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.SmtpConfigDto}.
     * @return immutable instance of SmtpConfigDto
     */
    public org.glowroot.local.ui.SmtpConfigDto build() {
      checkRequiredAttributes();
      return new SmtpConfigDto(this);
    }
  
    private boolean fromEmailAddressIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM_EMAIL_ADDRESS) != 0;
    }
  
    private boolean fromDisplayNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM_DISPLAY_NAME) != 0;
    }
  
    private boolean hostIsSet() {
      return (initializedBitset & INITIALIZED_BIT_HOST) != 0;
    }
  
    private boolean sslIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SSL) != 0;
    }
  
    private boolean usernameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_USERNAME) != 0;
    }
  
    private boolean passwordExistsIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PASSWORD_EXISTS) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromEmailAddressIsSet()) {
        attributes.add("fromEmailAddress");
      }
      if (!fromDisplayNameIsSet()) {
        attributes.add("fromDisplayName");
      }
      if (!hostIsSet()) {
        attributes.add("host");
      }
      if (!sslIsSet()) {
        attributes.add("ssl");
      }
      if (!usernameIsSet()) {
        attributes.add("username");
      }
      if (!passwordExistsIsSet()) {
        attributes.add("passwordExists");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build SmtpConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
