package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.StorageConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code StorageConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.StorageConfigDtoBase"})
@Immutable
final class StorageConfigDto extends ConfigJsonService.StorageConfigDtoBase {
  private final int aggregateExpirationHours;
  private final int traceExpirationHours;
  private final int gaugeExpirationHours;
  private final int cappedDatabaseSizeMb;
  private final String version;

  private StorageConfigDto(
      int aggregateExpirationHours,
      int traceExpirationHours,
      int gaugeExpirationHours,
      int cappedDatabaseSizeMb,
      String version) {
    this.aggregateExpirationHours = aggregateExpirationHours;
    this.traceExpirationHours = traceExpirationHours;
    this.gaugeExpirationHours = gaugeExpirationHours;
    this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code aggregateExpirationHours} attribute
   */
  @JsonProperty("aggregateExpirationHours")
  @Override
  public int aggregateExpirationHours() {
    return aggregateExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceExpirationHours} attribute
   */
  @JsonProperty("traceExpirationHours")
  @Override
  public int traceExpirationHours() {
    return traceExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeExpirationHours} attribute
   */
  @JsonProperty("gaugeExpirationHours")
  @Override
  public int gaugeExpirationHours() {
    return gaugeExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code cappedDatabaseSizeMb} attribute
   */
  @JsonProperty("cappedDatabaseSizeMb")
  @Override
  public int cappedDatabaseSizeMb() {
    return cappedDatabaseSizeMb;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#aggregateExpirationHours() aggregateExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for aggregateExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withAggregateExpirationHours(int value) {
    if (this.aggregateExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        newValue,
        this.traceExpirationHours,
        this.gaugeExpirationHours,
        this.cappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#traceExpirationHours() traceExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withTraceExpirationHours(int value) {
    if (this.traceExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        this.aggregateExpirationHours,
        newValue,
        this.gaugeExpirationHours,
        this.cappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#gaugeExpirationHours() gaugeExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for gaugeExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withGaugeExpirationHours(int value) {
    if (this.gaugeExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        this.aggregateExpirationHours,
        this.traceExpirationHours,
        newValue,
        this.cappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#cappedDatabaseSizeMb() cappedDatabaseSizeMb}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for cappedDatabaseSizeMb
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withCappedDatabaseSizeMb(int value) {
    if (this.cappedDatabaseSizeMb == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        this.aggregateExpirationHours,
        this.traceExpirationHours,
        this.gaugeExpirationHours,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new StorageConfigDto(
        this.aggregateExpirationHours,
        this.traceExpirationHours,
        this.gaugeExpirationHours,
        this.cappedDatabaseSizeMb,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code StorageConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof StorageConfigDto && equalTo((StorageConfigDto) another));
  }
  
  private boolean equalTo(StorageConfigDto another) {
    return aggregateExpirationHours == another.aggregateExpirationHours
        && traceExpirationHours == another.traceExpirationHours
        && gaugeExpirationHours == another.gaugeExpirationHours
        && cappedDatabaseSizeMb == another.cappedDatabaseSizeMb
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code aggregateExpirationHours}, {@code traceExpirationHours}, {@code gaugeExpirationHours}, {@code cappedDatabaseSizeMb}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + aggregateExpirationHours;
    h = h * 17 + traceExpirationHours;
    h = h * 17 + gaugeExpirationHours;
    h = h * 17 + cappedDatabaseSizeMb;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code StorageConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StorageConfigDto")
        .add("aggregateExpirationHours", aggregateExpirationHours)
        .add("traceExpirationHours", traceExpirationHours)
        .add("gaugeExpirationHours", gaugeExpirationHours)
        .add("cappedDatabaseSizeMb", cappedDatabaseSizeMb)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static StorageConfigDto fromAllAttributes(
      @JsonProperty("aggregateExpirationHours") @Nullable Integer aggregateExpirationHours,
      @JsonProperty("traceExpirationHours") @Nullable Integer traceExpirationHours,
      @JsonProperty("gaugeExpirationHours") @Nullable Integer gaugeExpirationHours,
      @JsonProperty("cappedDatabaseSizeMb") @Nullable Integer cappedDatabaseSizeMb,
      @JsonProperty("version") @Nullable String version) {
    StorageConfigDto.Builder builder = StorageConfigDto.builder();
    if (aggregateExpirationHours != null) {
      builder.aggregateExpirationHours(aggregateExpirationHours);
    }
    if (traceExpirationHours != null) {
      builder.traceExpirationHours(traceExpirationHours);
    }
    if (gaugeExpirationHours != null) {
      builder.gaugeExpirationHours(gaugeExpirationHours);
    }
    if (cappedDatabaseSizeMb != null) {
      builder.cappedDatabaseSizeMb(cappedDatabaseSizeMb);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.StorageConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable StorageConfigDto instance
   */
  static StorageConfigDto copyOf(ConfigJsonService.StorageConfigDtoBase instance) {
    if (instance instanceof StorageConfigDto) {
      return (StorageConfigDto) instance;
    }
    return StorageConfigDto.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.StorageConfigDto}.
   * @return new StorageConfigDto builder
   */
  static StorageConfigDto.Builder builder() {
    return new StorageConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.StorageConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_AGGREGATE_EXPIRATION_HOURS = 0x1L;
    private static final long INITIALIZED_BIT_TRACE_EXPIRATION_HOURS = 0x2L;
    private static final long INITIALIZED_BIT_GAUGE_EXPIRATION_HOURS = 0x4L;
    private static final long INITIALIZED_BIT_CAPPED_DATABASE_SIZE_MB = 0x8L;
    private static final long INITIALIZED_BIT_VERSION = 0x10L;
    private long initializedBitset;
  
    private int aggregateExpirationHours;
    private int traceExpirationHours;
    private int gaugeExpirationHours;
    private int cappedDatabaseSizeMb;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ConfigJsonService.StorageConfigDtoBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ConfigJsonService.StorageConfigDtoBase instance) {
      Preconditions.checkNotNull(instance);
      aggregateExpirationHours(instance.aggregateExpirationHours());
      traceExpirationHours(instance.traceExpirationHours());
      gaugeExpirationHours(instance.gaugeExpirationHours());
      cappedDatabaseSizeMb(instance.cappedDatabaseSizeMb());
      version(instance.version());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#aggregateExpirationHours() aggregateExpirationHours}.
     * @param aggregateExpirationHours value for aggregateExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder aggregateExpirationHours(int aggregateExpirationHours) {
      this.aggregateExpirationHours = aggregateExpirationHours;
      initializedBitset |= INITIALIZED_BIT_AGGREGATE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#traceExpirationHours() traceExpirationHours}.
     * @param traceExpirationHours value for traceExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceExpirationHours(int traceExpirationHours) {
      this.traceExpirationHours = traceExpirationHours;
      initializedBitset |= INITIALIZED_BIT_TRACE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#gaugeExpirationHours() gaugeExpirationHours}.
     * @param gaugeExpirationHours value for gaugeExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeExpirationHours(int gaugeExpirationHours) {
      this.gaugeExpirationHours = gaugeExpirationHours;
      initializedBitset |= INITIALIZED_BIT_GAUGE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#cappedDatabaseSizeMb() cappedDatabaseSizeMb}.
     * @param cappedDatabaseSizeMb value for cappedDatabaseSizeMb
     * @return {@code this} builder for chained invocation
     */
    public final Builder cappedDatabaseSizeMb(int cappedDatabaseSizeMb) {
      this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
      initializedBitset |= INITIALIZED_BIT_CAPPED_DATABASE_SIZE_MB;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.StorageConfigDto}.
     * @return immutable instance of StorageConfigDto
     */
    public org.glowroot.local.ui.StorageConfigDto build() {
      checkRequiredAttributes();
      return new StorageConfigDto(aggregateExpirationHours, traceExpirationHours, gaugeExpirationHours, cappedDatabaseSizeMb, version);
    }
  
    private boolean aggregateExpirationHoursIsSet() {
      return (initializedBitset & INITIALIZED_BIT_AGGREGATE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean traceExpirationHoursIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean gaugeExpirationHoursIsSet() {
      return (initializedBitset & INITIALIZED_BIT_GAUGE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean cappedDatabaseSizeMbIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPPED_DATABASE_SIZE_MB) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!aggregateExpirationHoursIsSet()) {
        attributes.add("aggregateExpirationHours");
      }
      if (!traceExpirationHoursIsSet()) {
        attributes.add("traceExpirationHours");
      }
      if (!gaugeExpirationHoursIsSet()) {
        attributes.add("gaugeExpirationHours");
      }
      if (!cappedDatabaseSizeMbIsSet()) {
        attributes.add("cappedDatabaseSizeMb");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build StorageConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
