package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.AggregateTimer;

/**
 * Immutable implementation of {@link AggregateMerging.TimerMergedAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TimerMergedAggregate.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateMerging.TimerMergedAggregateBase"})
@Immutable
public final class TimerMergedAggregate
    extends AggregateMerging.TimerMergedAggregateBase {
  private final AggregateTimer syntheticRootTimer;
  private final long transactionCount;

  private TimerMergedAggregate(AggregateTimer syntheticRootTimer, long transactionCount) {
    this.syntheticRootTimer = syntheticRootTimer;
    this.transactionCount = transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code syntheticRootTimer} attribute
   */
  @JsonProperty("timers")
  @Override
  public AggregateTimer syntheticRootTimer() {
    return syntheticRootTimer;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.TimerMergedAggregateBase#syntheticRootTimer() syntheticRootTimer}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for syntheticRootTimer
   * @return modified copy of the {@code this} object
   */
  public final TimerMergedAggregate withSyntheticRootTimer(AggregateTimer value) {
    if (this.syntheticRootTimer == value) {
      return this;
    }
    AggregateTimer newValue = Preconditions.checkNotNull(value);
    return new TimerMergedAggregate(newValue, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.TimerMergedAggregateBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final TimerMergedAggregate withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new TimerMergedAggregate(this.syntheticRootTimer, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TimerMergedAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TimerMergedAggregate && equalTo((TimerMergedAggregate) another));
  }
  
  private boolean equalTo(TimerMergedAggregate another) {
    return syntheticRootTimer.equals(another.syntheticRootTimer)
        && transactionCount == another.transactionCount;
  }
  
  /**
   * Computes hash code from attributes: {@code syntheticRootTimer}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + syntheticRootTimer.hashCode();
    h = h * 17 + Longs.hashCode(transactionCount);
    return h;
  }
  
  /**
   * Prints immutable value {@code TimerMergedAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TimerMergedAggregate")
        .add("syntheticRootTimer", syntheticRootTimer)
        .add("transactionCount", transactionCount)
        .toString();
  }
  
  @JsonCreator
  public static TimerMergedAggregate fromAllAttributes(
      @JsonProperty("timers") @Nullable AggregateTimer syntheticRootTimer,
      @JsonProperty("transactionCount") @Nullable Long transactionCount) {
    TimerMergedAggregate.Builder builder = TimerMergedAggregate.builder();
    if (syntheticRootTimer != null) {
      builder.syntheticRootTimer(syntheticRootTimer);
    }
    if (transactionCount != null) {
      builder.transactionCount(transactionCount);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AggregateMerging.TimerMergedAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TimerMergedAggregate instance
   */
  public static TimerMergedAggregate copyOf(AggregateMerging.TimerMergedAggregateBase instance) {
    if (instance instanceof TimerMergedAggregate) {
      return (TimerMergedAggregate) instance;
    }
    return TimerMergedAggregate.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.TimerMergedAggregate}.
   * @return new TimerMergedAggregate builder
   */
  public static TimerMergedAggregate.Builder builder() {
    return new TimerMergedAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.TimerMergedAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_SYNTHETIC_ROOT_TIMER = 0x1L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x2L;
    private long initializedBitset;
  
    private @Nullable AggregateTimer syntheticRootTimer;
    private long transactionCount;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link AggregateMerging.TimerMergedAggregateBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(AggregateMerging.TimerMergedAggregateBase instance) {
      Preconditions.checkNotNull(instance);
      syntheticRootTimer(instance.syntheticRootTimer());
      transactionCount(instance.transactionCount());
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.TimerMergedAggregateBase#syntheticRootTimer() syntheticRootTimer}.
     * @param syntheticRootTimer value for syntheticRootTimer
     * @return {@code this} builder for chained invocation
     */
    public final Builder syntheticRootTimer(AggregateTimer syntheticRootTimer) {
      this.syntheticRootTimer = Preconditions.checkNotNull(syntheticRootTimer);
      initializedBitset |= INITIALIZED_BIT_SYNTHETIC_ROOT_TIMER;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.TimerMergedAggregateBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.TimerMergedAggregate}.
     * @return immutable instance of TimerMergedAggregate
     */
    public TimerMergedAggregate build() {
      checkRequiredAttributes();
      return new TimerMergedAggregate(syntheticRootTimer, transactionCount);
    }
  
    private boolean syntheticRootTimerIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SYNTHETIC_ROOT_TIMER) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!syntheticRootTimerIsSet()) {
        attributes.add("syntheticRootTimer");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build TimerMergedAggregate, some of required attributes are not set " + attributes;
    }
  }
}
