package org.glowroot.local.ui;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.Trace;
import org.glowroot.common.ChunkSource;

/**
 * Immutable implementation of {@link TraceCommonService.TraceExportBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TraceExport.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TraceCommonService.TraceExportBase"})
@Immutable
final class TraceExport extends TraceCommonService.TraceExportBase {
  private final Trace trace;
  private final String traceJson;
  private final @Nullable ChunkSource entries;
  private final @Nullable ChunkSource profile;

  private TraceExport(
      Trace trace,
      String traceJson,
      @Nullable ChunkSource entries,
      @Nullable ChunkSource profile) {
    this.trace = trace;
    this.traceJson = traceJson;
    this.entries = entries;
    this.profile = profile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code trace} attribute
   */
  @Override
  public Trace trace() {
    return trace;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceJson} attribute
   */
  @Override
  public String traceJson() {
    return traceJson;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code entries} attribute
   */
  @Override
  public ChunkSource entries() {
    return entries;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profile} attribute
   */
  @Override
  public ChunkSource profile() {
    return profile;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceCommonService.TraceExportBase#trace() trace}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for trace
   * @return modified copy of the {@code this} object
   */
  public final TraceExport withTrace(Trace value) {
    if (this.trace == value) {
      return this;
    }
    Trace newValue = Preconditions.checkNotNull(value);
    return new TraceExport(newValue, this.traceJson, this.entries, this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceCommonService.TraceExportBase#traceJson() traceJson}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceJson
   * @return modified copy of the {@code this} object
   */
  public final TraceExport withTraceJson(String value) {
    if (this.traceJson == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TraceExport(this.trace, newValue, this.entries, this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceCommonService.TraceExportBase#entries() entries}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for entries, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TraceExport withEntries(@Nullable ChunkSource value) {
    if (this.entries == value) {
      return this;
    }
    @Nullable ChunkSource newValue = value;
    return new TraceExport(this.trace, this.traceJson, newValue, this.profile);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceCommonService.TraceExportBase#profile() profile}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profile, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final TraceExport withProfile(@Nullable ChunkSource value) {
    if (this.profile == value) {
      return this;
    }
    @Nullable ChunkSource newValue = value;
    return new TraceExport(this.trace, this.traceJson, this.entries, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TraceExport} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TraceExport && equalTo((TraceExport) another));
  }
  
  private boolean equalTo(TraceExport another) {
    return trace.equals(another.trace)
        && traceJson.equals(another.traceJson)
        && Objects.equal(entries, another.entries)
        && Objects.equal(profile, another.profile);
  }
  
  /**
   * Computes hash code from attributes: {@code trace}, {@code traceJson}, {@code entries}, {@code profile}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + trace.hashCode();
    h = h * 17 + traceJson.hashCode();
    h = h * 17 + Objects.hashCode(entries);
    h = h * 17 + Objects.hashCode(profile);
    return h;
  }
  
  /**
   * Prints immutable value {@code TraceExport{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TraceExport")
        .add("trace", trace)
        .add("traceJson", traceJson)
        .add("entries", entries)
        .add("profile", profile)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link TraceCommonService.TraceExportBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TraceExport instance
   */
  static TraceExport copyOf(TraceCommonService.TraceExportBase instance) {
    if (instance instanceof TraceExport) {
      return (TraceExport) instance;
    }
    return TraceExport.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.TraceExport}.
   * @return new TraceExport builder
   */
  static TraceExport.Builder builder() {
    return new TraceExport.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.TraceExport}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_TRACE = 0x1L;
    private static final long INITIALIZED_BIT_TRACE_JSON = 0x2L;
    private long initializedBitset;
  
    private @Nullable Trace trace;
    private @Nullable String traceJson;
    private @Nullable ChunkSource entries;
    private @Nullable ChunkSource profile;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link TraceCommonService.TraceExportBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(TraceCommonService.TraceExportBase instance) {
      Preconditions.checkNotNull(instance);
      trace(instance.trace());
      traceJson(instance.traceJson());
      @Nullable ChunkSource entriesValue = instance.entries();
      if (entriesValue != null) {
        entries(entriesValue);
      }
      @Nullable ChunkSource profileValue = instance.profile();
      if (profileValue != null) {
        profile(profileValue);
      }
      return this;
    }
  
    /**
     * Initializes value for {@link TraceCommonService.TraceExportBase#trace() trace}.
     * @param trace value for trace
     * @return {@code this} builder for chained invocation
     */
    public final Builder trace(Trace trace) {
      this.trace = Preconditions.checkNotNull(trace);
      initializedBitset |= INITIALIZED_BIT_TRACE;
      return this;
    }
  
    /**
     * Initializes value for {@link TraceCommonService.TraceExportBase#traceJson() traceJson}.
     * @param traceJson value for traceJson
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceJson(String traceJson) {
      this.traceJson = Preconditions.checkNotNull(traceJson);
      initializedBitset |= INITIALIZED_BIT_TRACE_JSON;
      return this;
    }
  
    /**
     * Initializes value for {@link TraceCommonService.TraceExportBase#entries() entries}.
     * @param entries value for entries, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder entries(@Nullable ChunkSource entries) {
      this.entries = entries;
      return this;
    }
  
    /**
     * Initializes value for {@link TraceCommonService.TraceExportBase#profile() profile}.
     * @param profile value for profile, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder profile(@Nullable ChunkSource profile) {
      this.profile = profile;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.TraceExport}.
     * @return immutable instance of TraceExport
     */
    public org.glowroot.local.ui.TraceExport build() {
      checkRequiredAttributes();
      return new TraceExport(trace, traceJson, entries, profile);
    }
  
    private boolean traceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE) != 0;
    }
  
    private boolean traceJsonIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE_JSON) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!traceIsSet()) {
        attributes.add("trace");
      }
      if (!traceJsonIsSet()) {
        attributes.add("traceJson");
      }
      return "Cannot build TraceExport, some of required attributes are not set " + attributes;
    }
  }
}
