package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.UserInterfaceConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code UserInterfaceConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.UserInterfaceConfigResponseBase"})
@Immutable
final class UserInterfaceConfigResponse
    extends ConfigJsonService.UserInterfaceConfigResponseBase {
  private final UserInterfaceConfigDto config;
  private final int activePort;
  private final boolean portChangeFailed;

  private UserInterfaceConfigResponse(UserInterfaceConfigDto config, int activePort, boolean portChangeFailed) {
    this.config = config;
    this.activePort = activePort;
    this.portChangeFailed = portChangeFailed;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public UserInterfaceConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code activePort} attribute
   */
  @JsonProperty("activePort")
  @Override
  public int activePort() {
    return activePort;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code portChangeFailed} attribute
   */
  @JsonProperty("portChangeFailed")
  @Override
  public boolean portChangeFailed() {
    return portChangeFailed;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigResponse withConfig(UserInterfaceConfigDto value) {
    if (this.config == value) {
      return this;
    }
    UserInterfaceConfigDto newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigResponse(newValue, this.activePort, this.portChangeFailed);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#activePort() activePort}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for activePort
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigResponse withActivePort(int value) {
    if (this.activePort == value) {
      return this;
    }
    int newValue = value;
    return new UserInterfaceConfigResponse(this.config, newValue, this.portChangeFailed);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#portChangeFailed() portChangeFailed}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for portChangeFailed
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigResponse withPortChangeFailed(boolean value) {
    if (this.portChangeFailed == value) {
      return this;
    }
    boolean newValue = value;
    return new UserInterfaceConfigResponse(this.config, this.activePort, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code UserInterfaceConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof UserInterfaceConfigResponse && equalTo((UserInterfaceConfigResponse) another));
  }
  
  private boolean equalTo(UserInterfaceConfigResponse another) {
    return config.equals(another.config)
        && activePort == another.activePort
        && portChangeFailed == another.portChangeFailed;
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code activePort}, {@code portChangeFailed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + activePort;
    h = h * 17 + Booleans.hashCode(portChangeFailed);
    return h;
  }
  
  /**
   * Prints immutable value {@code UserInterfaceConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserInterfaceConfigResponse")
        .add("config", config)
        .add("activePort", activePort)
        .add("portChangeFailed", portChangeFailed)
        .toString();
  }
  
  @JsonCreator
  public static UserInterfaceConfigResponse fromAllAttributes(
      @JsonProperty("config") @Nullable UserInterfaceConfigDto config,
      @JsonProperty("activePort") @Nullable Integer activePort,
      @JsonProperty("portChangeFailed") @Nullable Boolean portChangeFailed) {
    UserInterfaceConfigResponse.Builder builder = UserInterfaceConfigResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (activePort != null) {
      builder.activePort(activePort);
    }
    if (portChangeFailed != null) {
      builder.portChangeFailed(portChangeFailed);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.UserInterfaceConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable UserInterfaceConfigResponse instance
   */
  static UserInterfaceConfigResponse copyOf(ConfigJsonService.UserInterfaceConfigResponseBase instance) {
    if (instance instanceof UserInterfaceConfigResponse) {
      return (UserInterfaceConfigResponse) instance;
    }
    return UserInterfaceConfigResponse.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.UserInterfaceConfigResponse}.
   * @return new UserInterfaceConfigResponse builder
   */
  static UserInterfaceConfigResponse.Builder builder() {
    return new UserInterfaceConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.UserInterfaceConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private static final long INITIALIZED_BIT_ACTIVE_PORT = 0x2L;
    private static final long INITIALIZED_BIT_PORT_CHANGE_FAILED = 0x4L;
    private long initializedBitset;
  
    private @Nullable UserInterfaceConfigDto config;
    private int activePort;
    private boolean portChangeFailed;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ConfigJsonService.UserInterfaceConfigResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ConfigJsonService.UserInterfaceConfigResponseBase instance) {
      Preconditions.checkNotNull(instance);
      config(instance.config());
      activePort(instance.activePort());
      portChangeFailed(instance.portChangeFailed());
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(UserInterfaceConfigDto config) {
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#activePort() activePort}.
     * @param activePort value for activePort
     * @return {@code this} builder for chained invocation
     */
    public final Builder activePort(int activePort) {
      this.activePort = activePort;
      initializedBitset |= INITIALIZED_BIT_ACTIVE_PORT;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigResponseBase#portChangeFailed() portChangeFailed}.
     * @param portChangeFailed value for portChangeFailed
     * @return {@code this} builder for chained invocation
     */
    public final Builder portChangeFailed(boolean portChangeFailed) {
      this.portChangeFailed = portChangeFailed;
      initializedBitset |= INITIALIZED_BIT_PORT_CHANGE_FAILED;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.UserInterfaceConfigResponse}.
     * @return immutable instance of UserInterfaceConfigResponse
     */
    public org.glowroot.local.ui.UserInterfaceConfigResponse build() {
      checkRequiredAttributes();
      return new UserInterfaceConfigResponse(config, activePort, portChangeFailed);
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private boolean activePortIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ACTIVE_PORT) != 0;
    }
  
    private boolean portChangeFailedIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PORT_CHANGE_FAILED) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      if (!activePortIsSet()) {
        attributes.add("activePort");
      }
      if (!portChangeFailedIsSet()) {
        attributes.add("portChangeFailed");
      }
      return "Cannot build UserInterfaceConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
