package org.glowroot.transaction.model;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GcInfoComponent.GcSnapshotBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GcSnapshot.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GcInfoComponent.GcSnapshotBase"})
@Immutable
final class GcSnapshot extends GcInfoComponent.GcSnapshotBase {
  private final long collectionCount;
  private final long collectionTime;

  private GcSnapshot(long collectionCount, long collectionTime) {
    this.collectionCount = collectionCount;
    this.collectionTime = collectionTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code collectionCount} attribute
   */
  @Override
  public long collectionCount() {
    return collectionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code collectionTime} attribute
   */
  @Override
  public long collectionTime() {
    return collectionTime;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GcInfoComponent.GcSnapshotBase#collectionCount() collectionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for collectionCount
   * @return modified copy of the {@code this} object
   */
  public final GcSnapshot withCollectionCount(long value) {
    if (this.collectionCount == value) {
      return this;
    }
    long newValue = value;
    return new GcSnapshot(newValue, this.collectionTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GcInfoComponent.GcSnapshotBase#collectionTime() collectionTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for collectionTime
   * @return modified copy of the {@code this} object
   */
  public final GcSnapshot withCollectionTime(long value) {
    if (this.collectionTime == value) {
      return this;
    }
    long newValue = value;
    return new GcSnapshot(this.collectionCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GcSnapshot} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GcSnapshot && equalTo((GcSnapshot) another));
  }
  
  private boolean equalTo(GcSnapshot another) {
    return collectionCount == another.collectionCount
        && collectionTime == another.collectionTime;
  }
  
  /**
   * Computes hash code from attributes: {@code collectionCount}, {@code collectionTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(collectionCount);
    h = h * 17 + Longs.hashCode(collectionTime);
    return h;
  }
  
  /**
   * Prints immutable value {@code GcSnapshot{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GcSnapshot")
        .add("collectionCount", collectionCount)
        .add("collectionTime", collectionTime)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link GcInfoComponent.GcSnapshotBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GcSnapshot instance
   */
  static GcSnapshot copyOf(GcInfoComponent.GcSnapshotBase instance) {
    if (instance instanceof GcSnapshot) {
      return (GcSnapshot) instance;
    }
    return GcSnapshot.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.GcSnapshot}.
   * @return new GcSnapshot builder
   */
  static GcSnapshot.Builder builder() {
    return new GcSnapshot.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.GcSnapshot}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_COLLECTION_COUNT = 0x1L;
    private static final long INITIALIZED_BIT_COLLECTION_TIME = 0x2L;
    private long initializedBitset;
  
    private long collectionCount;
    private long collectionTime;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link GcInfoComponent.GcSnapshotBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(GcInfoComponent.GcSnapshotBase instance) {
      Preconditions.checkNotNull(instance);
      collectionCount(instance.collectionCount());
      collectionTime(instance.collectionTime());
      return this;
    }
  
    /**
     * Initializes value for {@link GcInfoComponent.GcSnapshotBase#collectionCount() collectionCount}.
     * @param collectionCount value for collectionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionCount(long collectionCount) {
      this.collectionCount = collectionCount;
      initializedBitset |= INITIALIZED_BIT_COLLECTION_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link GcInfoComponent.GcSnapshotBase#collectionTime() collectionTime}.
     * @param collectionTime value for collectionTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionTime(long collectionTime) {
      this.collectionTime = collectionTime;
      initializedBitset |= INITIALIZED_BIT_COLLECTION_TIME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.GcSnapshot}.
     * @return immutable instance of GcSnapshot
     */
    public org.glowroot.transaction.model.GcSnapshot build() {
      checkRequiredAttributes();
      return new GcSnapshot(collectionCount, collectionTime);
    }
  
    private boolean collectionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_COLLECTION_COUNT) != 0;
    }
  
    private boolean collectionTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_COLLECTION_TIME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!collectionCountIsSet()) {
        attributes.add("collectionCount");
      }
      if (!collectionTimeIsSet()) {
        attributes.add("collectionTime");
      }
      return "Cannot build GcSnapshot, some of required attributes are not set " + attributes;
    }
  }
}
