package org.glowroot.transaction.model;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ProfileNode.MatchedNodePairBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MatchedNodePair.builder()}.
 * Use static factory method to create immutable instances:
 * {@code MatchedNodePair.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ProfileNode.MatchedNodePairBase"})
@Immutable
final class MatchedNodePair extends ProfileNode.MatchedNodePairBase {
  private final ProfileNode leftNode;
  private final ProfileNode rightNode;

  private MatchedNodePair(
      ProfileNode leftNode,
      ProfileNode rightNode) {
    this.leftNode = leftNode;
    this.rightNode = rightNode;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code leftNode} attribute
   */
  @Override
  public ProfileNode leftNode() {
    return leftNode;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rightNode} attribute
   */
  @Override
  public ProfileNode rightNode() {
    return rightNode;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ProfileNode.MatchedNodePairBase#leftNode() leftNode}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for leftNode
   * @return modified copy of the {@code this} object
   */
  public final MatchedNodePair withLeftNode(ProfileNode value) {
    if (this.leftNode == value) {
      return this;
    }
    ProfileNode newValue = Preconditions.checkNotNull(value);
    return new MatchedNodePair(newValue, this.rightNode);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ProfileNode.MatchedNodePairBase#rightNode() rightNode}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for rightNode
   * @return modified copy of the {@code this} object
   */
  public final MatchedNodePair withRightNode(ProfileNode value) {
    if (this.rightNode == value) {
      return this;
    }
    ProfileNode newValue = Preconditions.checkNotNull(value);
    return new MatchedNodePair(this.leftNode, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MatchedNodePair} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MatchedNodePair && equalTo((MatchedNodePair) another));
  }
  
  private boolean equalTo(MatchedNodePair another) {
    return leftNode.equals(another.leftNode)
        && rightNode.equals(another.rightNode);
  }
  
  /**
   * Computes hash code from attributes: {@code leftNode}, {@code rightNode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + leftNode.hashCode();
    h = h * 17 + rightNode.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MatchedNodePair{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MatchedNodePair")
        .add("leftNode", leftNode)
        .add("rightNode", rightNode)
        .toString();
  }

  /**
   * Construct new immutable {@code MatchedNodePair} instance.
   * @param leftNode value for {@code leftNode}
   * @param rightNode value for {@code rightNode}
   * @return immutable MatchedNodePair instance
   */
  public static org.glowroot.transaction.model.MatchedNodePair of(ProfileNode leftNode, ProfileNode rightNode) {
    return new MatchedNodePair(leftNode, rightNode);
  }
  
  /**
   * Creates immutable copy of {@link ProfileNode.MatchedNodePairBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MatchedNodePair instance
   */
  static MatchedNodePair copyOf(ProfileNode.MatchedNodePairBase instance) {
    if (instance instanceof MatchedNodePair) {
      return (MatchedNodePair) instance;
    }
    return MatchedNodePair.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.MatchedNodePair}.
   * @return new MatchedNodePair builder
   */
  static MatchedNodePair.Builder builder() {
    return new MatchedNodePair.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.MatchedNodePair}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_LEFT_NODE = 0x1L;
    private static final long INITIALIZED_BIT_RIGHT_NODE = 0x2L;
    private long initializedBitset;
  
    private @Nullable ProfileNode leftNode;
    private @Nullable ProfileNode rightNode;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ProfileNode.MatchedNodePairBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ProfileNode.MatchedNodePairBase instance) {
      Preconditions.checkNotNull(instance);
      leftNode(instance.leftNode());
      rightNode(instance.rightNode());
      return this;
    }
  
    /**
     * Initializes value for {@link ProfileNode.MatchedNodePairBase#leftNode() leftNode}.
     * @param leftNode value for leftNode
     * @return {@code this} builder for chained invocation
     */
    public final Builder leftNode(ProfileNode leftNode) {
      this.leftNode = Preconditions.checkNotNull(leftNode);
      initializedBitset |= INITIALIZED_BIT_LEFT_NODE;
      return this;
    }
  
    /**
     * Initializes value for {@link ProfileNode.MatchedNodePairBase#rightNode() rightNode}.
     * @param rightNode value for rightNode
     * @return {@code this} builder for chained invocation
     */
    public final Builder rightNode(ProfileNode rightNode) {
      this.rightNode = Preconditions.checkNotNull(rightNode);
      initializedBitset |= INITIALIZED_BIT_RIGHT_NODE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.MatchedNodePair}.
     * @return immutable instance of MatchedNodePair
     */
    public org.glowroot.transaction.model.MatchedNodePair build() {
      checkRequiredAttributes();
      return new MatchedNodePair(leftNode, rightNode);
    }
  
    private boolean leftNodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LEFT_NODE) != 0;
    }
  
    private boolean rightNodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_RIGHT_NODE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!leftNodeIsSet()) {
        attributes.add("leftNode");
      }
      if (!rightNodeIsSet()) {
        attributes.add("rightNode");
      }
      return "Cannot build MatchedNodePair, some of required attributes are not set " + attributes;
    }
  }
}
