package org.glowroot.transaction.model;

import org.glowroot.shaded.google.common.annotations.VisibleForTesting;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TimerNameImplBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TimerNameImpl.builder()}.
 * Use static factory method to create immutable instances:
 * {@code TimerNameImpl.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TimerNameImplBase"})
@Immutable
public final class TimerNameImpl extends TimerNameImplBase {
  private final String name;
  private final boolean extended;
  private final @Nullable TimerNameImpl extendedTimer;
  private final int specialHashCode;

  private TimerNameImpl(String name) {
    this.name = Preconditions.checkNotNull(name);
    this.extended = super.extended();
    this.extendedTimer = super.extendedTimer();
    this.specialHashCode = super.specialHashCode();
  }

  private TimerNameImpl(TimerNameImpl.Builder builder) {
    this.name = builder.name;
    this.extended = builder.extendedIsSet()
        ? builder.extended
        : super.extended();
    this.extendedTimer = super.extendedTimer();
    this.specialHashCode = super.specialHashCode();
  }

  private TimerNameImpl(String name, boolean extended) {
    this.name = name;
    this.extended = extended;
    this.extendedTimer = super.extendedTimer();
    this.specialHashCode = super.specialHashCode();
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @VisibleForTesting
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code extended} attribute
   */
  @Override
  public boolean extended() {
    return extended;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code extendedTimer} attribute
   */
  @Override
  public TimerNameImpl extendedTimer() {
    return extendedTimer;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code specialHashCode} attribute
   */
  @Override
  public int specialHashCode() {
    return specialHashCode;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TimerNameImplBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final TimerNameImpl withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TimerNameImpl(newValue, this.extended);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TimerNameImplBase#extended() extended}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for extended
   * @return modified copy of the {@code this} object
   */
  public final TimerNameImpl withExtended(boolean value) {
    if (this.extended == value) {
      return this;
    }
    boolean newValue = value;
    return new TimerNameImpl(this.name, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TimerNameImpl} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TimerNameImpl && equalTo((TimerNameImpl) another));
  }
  
  private boolean equalTo(TimerNameImpl another) {
    return name.equals(another.name)
        && extended == another.extended
        && Objects.equal(extendedTimer, another.extendedTimer)
        && specialHashCode == another.specialHashCode;
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code extended}, {@code extendedTimer}, {@code specialHashCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Booleans.hashCode(extended);
    h = h * 17 + Objects.hashCode(extendedTimer);
    h = h * 17 + specialHashCode;
    return h;
  }
  
  /**
   * Prints immutable value {@code TimerNameImpl{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TimerNameImpl")
        .add("name", name)
        .add("extended", extended)
        .add("extendedTimer", extendedTimer)
        .add("specialHashCode", specialHashCode)
        .toString();
  }

  /**
   * Construct new immutable {@code TimerNameImpl} instance.
   * @param name value for {@code name}
   * @return immutable TimerNameImpl instance
   */
  public static org.glowroot.transaction.model.TimerNameImpl of(String name) {
    return new TimerNameImpl(name);
  }
  
  /**
   * Creates immutable copy of {@link TimerNameImplBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TimerNameImpl instance
   */
  public static TimerNameImpl copyOf(TimerNameImplBase instance) {
    if (instance instanceof TimerNameImpl) {
      return (TimerNameImpl) instance;
    }
    return TimerNameImpl.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.TimerNameImpl}.
   * @return new TimerNameImpl builder
   */
  public static TimerNameImpl.Builder builder() {
    return new TimerNameImpl.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.TimerNameImpl}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long NONDEFAULT_BIT_EXTENDED = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String name;
    private boolean extended;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link TimerNameImplBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(TimerNameImplBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      extended(instance.extended());
      return this;
    }
  
    /**
     * Initializes value for {@link TimerNameImplBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link TimerNameImplBase#extended() extended}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TimerNameImplBase#extended() extended}.</em>
     * @param extended value for extended
     * @return {@code this} builder for chained invocation
     */
    public final Builder extended(boolean extended) {
      this.extended = extended;
      nondefaultBitset |= NONDEFAULT_BIT_EXTENDED;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.TimerNameImpl}.
     * @return immutable instance of TimerNameImpl
     */
    public TimerNameImpl build() {
      checkRequiredAttributes();
      return new TimerNameImpl(this);
    }
  
    private boolean extendedIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_EXTENDED) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      return "Cannot build TimerNameImpl, some of required attributes are not set " + attributes;
    }
  }
}
