package org.glowroot.weaving;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Label;

/**
 * Immutable implementation of {@link WeavingMethodVisitor.CatchHandlerBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code CatchHandler.builder()}.
 * Use static factory method to create immutable instances:
 * {@code CatchHandler.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "WeavingMethodVisitor.CatchHandlerBase"})
@Immutable
final class CatchHandler extends WeavingMethodVisitor.CatchHandlerBase {
  private final Label catchStartLabel;
  private final ImmutableList<Advice> advisors;

  private CatchHandler(Label catchStartLabel, Iterable<? extends Advice> advisors) {
    this.catchStartLabel = Preconditions.checkNotNull(catchStartLabel);
    this.advisors = ImmutableList.copyOf(advisors);
  }

  private CatchHandler(
      CatchHandler original,
      Label catchStartLabel,
      ImmutableList<Advice> advisors) {
    this.catchStartLabel = catchStartLabel;
    this.advisors = advisors;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code catchStartLabel} attribute
   */
  @Override
  public Label catchStartLabel() {
    return catchStartLabel;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code advisors} attribute
   */
  @Override
  public ImmutableList<Advice> advisors() {
    return advisors;
  }
  
  /**
   * Copy current immutable object by setting value for {@link WeavingMethodVisitor.CatchHandlerBase#catchStartLabel() catchStartLabel}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for catchStartLabel
   * @return modified copy of the {@code this} object
   */
  public final CatchHandler withCatchStartLabel(Label value) {
    if (this.catchStartLabel == value) {
      return this;
    }
    Label newValue = Preconditions.checkNotNull(value);
    return new CatchHandler(this, newValue, this.advisors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final CatchHandler withAdvisors(Advice... elements) {
    ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
    return new CatchHandler(this, this.catchStartLabel, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of advisors elements to set
   * @return modified copy of {@code this} object
   */
  public final CatchHandler withAdvisors(Iterable<? extends Advice> elements) {
    if (this.advisors == elements) {
      return this;
    }
    ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
    return new CatchHandler(this, this.catchStartLabel, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code CatchHandler} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof CatchHandler && equalTo((CatchHandler) another));
  }
  
  private boolean equalTo(CatchHandler another) {
    return catchStartLabel.equals(another.catchStartLabel)
        && advisors.equals(another.advisors);
  }
  
  /**
   * Computes hash code from attributes: {@code catchStartLabel}, {@code advisors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + catchStartLabel.hashCode();
    h = h * 17 + advisors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code CatchHandler{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatchHandler")
        .add("catchStartLabel", catchStartLabel)
        .add("advisors", advisors)
        .toString();
  }

  /**
   * Construct new immutable {@code CatchHandler} instance.
   * @param catchStartLabel value for {@code catchStartLabel}
   * @param advisors value for {@code advisors}
   * @return immutable CatchHandler instance
   */
  public static org.glowroot.weaving.CatchHandler of(Label catchStartLabel, List<Advice> advisors) {
    return of(catchStartLabel, (Iterable<? extends Advice>) advisors);
  }

  /**
   * Construct new immutable {@code CatchHandler} instance.
   * @param catchStartLabel value for {@code catchStartLabel}
   * @param advisors value for {@code advisors}
   * @return immutable CatchHandler instance
   */
  public static org.glowroot.weaving.CatchHandler of(Label catchStartLabel, Iterable<? extends Advice> advisors) {
    return new CatchHandler(catchStartLabel, advisors);
  }
  
  /**
   * Creates immutable copy of {@link WeavingMethodVisitor.CatchHandlerBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable CatchHandler instance
   */
  static CatchHandler copyOf(WeavingMethodVisitor.CatchHandlerBase instance) {
    if (instance instanceof CatchHandler) {
      return (CatchHandler) instance;
    }
    return CatchHandler.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.CatchHandler}.
   * @return new CatchHandler builder
   */
  static CatchHandler.Builder builder() {
    return new CatchHandler.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.CatchHandler}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CATCH_START_LABEL = 0x1L;
    private long initializedBitset;
  
    private @Nullable Label catchStartLabel;
    private ImmutableList.Builder<Advice> advisorsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link WeavingMethodVisitor.CatchHandlerBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(WeavingMethodVisitor.CatchHandlerBase instance) {
      Preconditions.checkNotNull(instance);
      catchStartLabel(instance.catchStartLabel());
      addAllAdvisors(instance.advisors());
      return this;
    }
  
    /**
     * Initializes value for {@link WeavingMethodVisitor.CatchHandlerBase#catchStartLabel() catchStartLabel}.
     * @param catchStartLabel value for catchStartLabel
     * @return {@code this} builder for chained invocation
     */
    public final Builder catchStartLabel(Label catchStartLabel) {
      this.catchStartLabel = Preconditions.checkNotNull(catchStartLabel);
      initializedBitset |= INITIALIZED_BIT_CATCH_START_LABEL;
      return this;
    }
  
    /**
     * Adds one element to {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors} list.
     * @param element advisors element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAdvisors(Advice element) {
      advisorsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors} list.
     * @param elements array of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAdvisors(Advice... elements) {
      advisorsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors} list.
     * @param elements iterable of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder advisors(Iterable<? extends Advice> elements) {
      advisorsBuilder = ImmutableList.builder();
      return addAllAdvisors(elements);
    }
  
    /**
     * Adds elements to {@link WeavingMethodVisitor.CatchHandlerBase#advisors() advisors} list.
     * @param elements iterable of advisors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
      advisorsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.CatchHandler}.
     * @return immutable instance of CatchHandler
     */
    public org.glowroot.weaving.CatchHandler build() {
      checkRequiredAttributes();
      return new CatchHandler(null, catchStartLabel, advisorsBuilder.build());
    }
  
    private boolean catchStartLabelIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CATCH_START_LABEL) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!catchStartLabelIsSet()) {
        attributes.add("catchStartLabel");
      }
      return "Cannot build CatchHandler, some of required attributes are not set " + attributes;
    }
  }
}
