/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.advicegen;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.config.CaptureKind;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.objectweb.asm.AnnotationVisitor;
import org.glowroot.shaded.objectweb.asm.ClassWriter;
import org.glowroot.shaded.objectweb.asm.Label;
import org.glowroot.shaded.objectweb.asm.MethodVisitor;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.weaving.Advice;
import org.glowroot.weaving.AdviceBuilder;
import org.glowroot.weaving.AdviceFlowOuterHolder;
import org.glowroot.weaving.LazyDefinedClass;

public class AdviceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AdviceGenerator.class);
    private static final String HANDLE_CLASS_NAME = "org/glowroot/transaction/PluginServicesRegistry";
    private static final String HANDLE_METHOD_NAME = "get";
    private static final AtomicInteger counter = new AtomicInteger();
    private final InstrumentationConfig config;
    @Nullable
    private final String pluginId;
    private final String adviceInternalName;
    @Nullable
    private final String methodMetaInternalName;

    public static ImmutableMap<Advice, LazyDefinedClass> createAdvisors(List<InstrumentationConfig> configs, @Nullable String pluginId) {
        HashMap<Advice, LazyDefinedClass> advisors = Maps.newHashMap();
        for (InstrumentationConfig config : configs) {
            if (!config.validationErrors().isEmpty()) continue;
            try {
                LazyDefinedClass lazyAdviceClass = new AdviceGenerator(config, pluginId).generate();
                boolean reweavable = pluginId == null;
                Advice advice = new AdviceBuilder(lazyAdviceClass, reweavable).build();
                advisors.put(advice, lazyAdviceClass);
            }
            catch (Exception e) {
                logger.error("error creating advice for advice config: {}", (Object)config, (Object)e);
            }
        }
        return ImmutableMap.copyOf(advisors);
    }

    private AdviceGenerator(InstrumentationConfig config, @Nullable String pluginId) {
        this.config = config;
        this.pluginId = pluginId;
        int uniqueNum = counter.incrementAndGet();
        this.adviceInternalName = "org/glowroot/advicegen/GeneratedAdvice" + uniqueNum;
        this.methodMetaInternalName = config.isTraceEntryOrGreater() || !config.transactionNameTemplate().isEmpty() || !config.transactionUserTemplate().isEmpty() || !((ImmutableMap)config.transactionCustomAttributeTemplates()).isEmpty() ? "org/glowroot/advicegen/GeneratedMethodMeta" + uniqueNum : null;
    }

    private LazyDefinedClass generate() throws Exception {
        LazyDefinedClass methodMetaClass = null;
        if (this.methodMetaInternalName != null) {
            methodMetaClass = this.generateMethodMetaClass(this.config);
        }
        ClassWriter cw = new ClassWriter(3);
        String[] interfaces = null;
        if (!this.config.enabledProperty().isEmpty() || !this.config.traceEntryEnabledProperty().isEmpty()) {
            interfaces = new String[]{"org/glowroot/api/PluginServices$ConfigListener"};
        }
        cw.visit(49, 33, this.adviceInternalName, null, "java/lang/Object", interfaces);
        this.addClassAnnotation(cw);
        this.addStaticFields(cw);
        this.addStaticInitializer(cw);
        this.addIsEnabledMethod(cw);
        if (this.config.isTraceEntryOrGreater()) {
            Preconditions.checkNotNull(this.methodMetaInternalName);
            this.addOnBeforeMethod(cw);
            this.addOnThrowMethod(cw);
            this.addOnReturnMethod(cw);
        } else if (this.config.captureKind() == CaptureKind.TIMER) {
            this.addOnBeforeMethodTimerOnly(cw);
            this.addOnAfterMethodTimerOnly(cw);
        } else {
            this.addOnBeforeMethodOther(cw);
        }
        cw.visitEnd();
        LazyDefinedClass.Builder builder = LazyDefinedClass.builder().type(Type.getObjectType(this.adviceInternalName)).bytes(cw.toByteArray());
        if (methodMetaClass != null) {
            builder.addDependencies(methodMetaClass);
        }
        return builder.build();
    }

    private void addClassAnnotation(ClassWriter cw) {
        AnnotationVisitor annotationVisitor = cw.visitAnnotation("Lorg/glowroot/api/weaving/Pointcut;", true);
        annotationVisitor.visit("className", this.config.className());
        annotationVisitor.visit("methodName", this.config.methodName());
        AnnotationVisitor arrayAnnotationVisitor = annotationVisitor.visitArray("methodParameterTypes");
        for (String methodParameterType : this.config.methodParameterTypes()) {
            arrayAnnotationVisitor.visit(null, methodParameterType);
        }
        arrayAnnotationVisitor.visitEnd();
        String timerName = this.config.timerName();
        if (this.config.isTimerOrGreater()) {
            if (timerName.isEmpty()) {
                annotationVisitor.visit("timerName", "<no timer name provided>");
            } else {
                annotationVisitor.visit("timerName", timerName);
            }
        }
        if (this.config.isTraceEntryOrGreater() && !this.config.traceEntryCaptureSelfNested()) {
            annotationVisitor.visit("ignoreSelfNested", true);
        }
        annotationVisitor.visitEnd();
    }

    private void addStaticFields(ClassWriter cw) {
        cw.visitField(25, "glowroot$advice$flow$outer$holder", Type.getDescriptor(AdviceFlowOuterHolder.class), null, null).visitEnd();
        cw.visitField(26, "pluginServices", "Lorg/glowroot/api/PluginServices;", null, null).visitEnd();
        if (this.config.isTimerOrGreater()) {
            cw.visitField(26, "timerName", "Lorg/glowroot/api/TimerName;", null, null).visitEnd();
        }
        if (!this.config.enabledProperty().isEmpty()) {
            cw.visitField(26, "enabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;", null, null).visitEnd();
        }
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            cw.visitField(26, "entryEnabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;", null, null).visitEnd();
        }
    }

    private void addStaticInitializer(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, Type.getInternalName(AdviceFlowOuterHolder.class), "create", "()" + Type.getDescriptor(AdviceFlowOuterHolder.class), false);
        mv.visitFieldInsn(179, this.adviceInternalName, "glowroot$advice$flow$outer$holder", Type.getDescriptor(AdviceFlowOuterHolder.class));
        if (this.pluginId == null) {
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn(this.pluginId);
        }
        mv.visitMethodInsn(184, HANDLE_CLASS_NAME, HANDLE_METHOD_NAME, "(Ljava/lang/String;)Lorg/glowroot/api/PluginServices;", false);
        mv.visitFieldInsn(179, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
        if (this.config.isTimerOrGreater()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(Type.getObjectType(this.adviceInternalName));
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "getTimerName", "(Ljava/lang/Class;)Lorg/glowroot/api/TimerName;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "timerName", "Lorg/glowroot/api/TimerName;");
        }
        if (!this.config.enabledProperty().isEmpty()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(this.config.enabledProperty());
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "getEnabledProperty", "(Ljava/lang/String;)Lorg/glowroot/api/PluginServices$BooleanProperty;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "enabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;");
        }
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(this.config.traceEntryEnabledProperty());
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "getEnabledProperty", "(Ljava/lang/String;)Lorg/glowroot/api/PluginServices$BooleanProperty;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addIsEnabledMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "isEnabled", "()Z", null, null);
        mv.visitAnnotation("Lorg/glowroot/api/weaving/IsEnabled;", true).visitEnd();
        mv.visitCode();
        if (this.config.enabledProperty().isEmpty()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "isEnabled", "()Z", false);
            mv.visitInsn(172);
        } else {
            mv.visitFieldInsn(178, this.adviceInternalName, "enabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/api/PluginServices$BooleanProperty", "value", "()Z", true);
            mv.visitInsn(172);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void addOnBeforeMethod(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/api/TraceEntry;");
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/api/PluginServices$BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/api/PluginServices$BooleanProperty", "value", "()Z", true);
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/api/TimerName;");
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "startTimer", "(Lorg/glowroot/api/TimerName;)Lorg/glowroot/api/Timer;", false);
            mv.visitInsn(176);
            mv.visitLabel(label);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
        if (this.config.isTransaction()) {
            String transactionType = this.config.transactionType();
            if (transactionType.isEmpty()) {
                mv.visitLdcInsn("<no transaction type provided>");
            } else {
                mv.visitLdcInsn(transactionType);
            }
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionNameTemplate", "()Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "create", "(Lorg/glowroot/advicegen/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/advicegen/GenericMessageSupplier;", false);
            mv.visitMethodInsn(182, "org/glowroot/advicegen/GenericMessageSupplier", "getMessageText", "()Ljava/lang/String;", false);
        }
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, this.methodMetaInternalName, "getMessageTemplate", "()Lorg/glowroot/advicegen/MessageTemplate;", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "create", "(Lorg/glowroot/advicegen/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/advicegen/GenericMessageSupplier;", false);
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/api/TimerName;");
        if (this.config.isTransaction()) {
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "startTransaction", "(Ljava/lang/String;Ljava/lang/String;Lorg/glowroot/api/MessageSupplier;Lorg/glowroot/api/TimerName;)Lorg/glowroot/api/TraceEntry;", false);
        } else {
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "startTraceEntry", "(Lorg/glowroot/api/MessageSupplier;Lorg/glowroot/api/TimerName;)Lorg/glowroot/api/TraceEntry;", false);
        }
        this.addCodeForOptionalTraceAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/api/Timer;");
        mv.visitCode();
        mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/api/TimerName;");
        mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "startTimer", "(Lorg/glowroot/api/TimerName;)Lorg/glowroot/api/Timer;", false);
        this.addCodeForOptionalTraceAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodOther(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "V");
        mv.visitCode();
        this.addCodeForOptionalTraceAttributes(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private MethodVisitor visitOnBeforeMethod(ClassWriter cw, String returnInternalName) {
        String desc = this.methodMetaInternalName != null ? "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;L" + this.methodMetaInternalName + ";)" + returnInternalName : "()" + returnInternalName;
        MethodVisitor mv = cw.visitMethod(9, "onBefore", desc, null, null);
        mv.visitAnnotation("Lorg/glowroot/api/weaving/OnBefore;", true).visitEnd();
        if (this.methodMetaInternalName != null) {
            mv.visitParameterAnnotation(0, "Lorg/glowroot/api/weaving/BindReceiver;", true).visitEnd();
            mv.visitParameterAnnotation(1, "Lorg/glowroot/api/weaving/BindMethodName;", true).visitEnd();
            mv.visitParameterAnnotation(2, "Lorg/glowroot/api/weaving/BindParameterArray;", true).visitEnd();
            mv.visitParameterAnnotation(3, "Lorg/glowroot/api/weaving/BindMethodMeta;", true).visitEnd();
        }
        return mv;
    }

    private void addCodeForOptionalTraceAttributes(MethodVisitor mv) {
        if (!this.config.transactionType().isEmpty() && !this.config.isTransaction()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(this.config.transactionType());
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "setTransactionType", "(Ljava/lang/String;)V", false);
        }
        if (!this.config.transactionNameTemplate().isEmpty() && !this.config.isTransaction()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitVarInsn(25, 3);
            Preconditions.checkNotNull(this.methodMetaInternalName);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionNameTemplate", "()Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "create", "(Lorg/glowroot/advicegen/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/advicegen/GenericMessageSupplier;", false);
            mv.visitMethodInsn(182, "org/glowroot/advicegen/GenericMessageSupplier", "getMessageText", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "setTransactionName", "(Ljava/lang/String;)V", false);
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitVarInsn(25, 3);
            Preconditions.checkNotNull(this.methodMetaInternalName);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionUserTemplate", "()Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "create", "(Lorg/glowroot/advicegen/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/advicegen/GenericMessageSupplier;", false);
            mv.visitMethodInsn(182, "org/glowroot/advicegen/GenericMessageSupplier", "getMessageText", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "setTransactionUser", "(Ljava/lang/String;)V", false);
        }
        int i = 0;
        for (String attrName : ((ImmutableMap)this.config.transactionCustomAttributeTemplates()).keySet()) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(attrName);
            mv.visitVarInsn(25, 3);
            Preconditions.checkNotNull(this.methodMetaInternalName);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionCustomAttributeTemplate" + i++, "()Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "create", "(Lorg/glowroot/advicegen/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/advicegen/GenericMessageSupplier;", false);
            mv.visitMethodInsn(182, "org/glowroot/advicegen/GenericMessageSupplier", "getMessageText", "()Ljava/lang/String;", false);
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "addTransactionCustomAttribute", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        }
        Long traceStoreThresholdMillis = this.config.traceStoreThresholdMillis();
        if (traceStoreThresholdMillis != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "pluginServices", "Lorg/glowroot/api/PluginServices;");
            mv.visitLdcInsn(traceStoreThresholdMillis);
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitMethodInsn(182, "org/glowroot/api/PluginServices", "setTraceStoreThreshold", "(JLjava/util/concurrent/TimeUnit;)V", false);
        }
    }

    private void addOnAfterMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onAfter", "(Lorg/glowroot/api/Timer;)V", null, null);
        mv.visitAnnotation("Lorg/glowroot/api/weaving/OnAfter;", true).visitEnd();
        mv.visitParameterAnnotation(0, "Lorg/glowroot/api/weaving/BindTraveler;", true).visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/api/Timer", "stop", "()V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnReturnMethod(ClassWriter cw) {
        boolean entryOrTimer = !this.config.traceEntryEnabledProperty().isEmpty();
        String travelerType = entryOrTimer ? "Ljava/lang/Object;" : "Lorg/glowroot/api/TraceEntry;";
        MethodVisitor mv = cw.visitMethod(9, "onReturn", "(Lorg/glowroot/api/OptionalReturn;" + travelerType + ")V", null, null);
        mv.visitParameterAnnotation(0, "Lorg/glowroot/api/weaving/BindOptionalReturn;", true).visitEnd();
        mv.visitParameterAnnotation(1, "Lorg/glowroot/api/weaving/BindTraveler;", true).visitEnd();
        int travelerParamIndex = 1;
        mv.visitAnnotation("Lorg/glowroot/api/weaving/OnReturn;", true).visitEnd();
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(193, "org/glowroot/api/TraceEntry");
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(192, "org/glowroot/api/Timer");
            mv.visitMethodInsn(185, "org/glowroot/api/Timer", "stop", "()V", true);
            mv.visitInsn(177);
            mv.visitLabel(label);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/api/OptionalReturn", "isVoid", "()Z", true);
        Label notVoidLabel = new Label();
        Label endIfLabel = new Label();
        mv.visitJumpInsn(153, notVoidLabel);
        mv.visitLdcInsn("void");
        mv.visitJumpInsn(167, endIfLabel);
        mv.visitLabel(notVoidLabel);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/api/OptionalReturn", "getValue", "()Ljava/lang/Object;", true);
        mv.visitLabel(endIfLabel);
        mv.visitMethodInsn(184, "org/glowroot/advicegen/GenericMessageSupplier", "updateWithReturnValue", "(Lorg/glowroot/api/TraceEntry;Ljava/lang/Object;)V", false);
        mv.visitVarInsn(25, travelerParamIndex);
        Long stackTraceThresholdMillis = this.config.traceEntryStackThresholdMillis();
        if (stackTraceThresholdMillis == null) {
            mv.visitMethodInsn(185, "org/glowroot/api/TraceEntry", "end", "()V", true);
        } else {
            mv.visitLdcInsn(stackTraceThresholdMillis);
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitMethodInsn(185, "org/glowroot/api/TraceEntry", "endWithStackTrace", "(JLjava/util/concurrent/TimeUnit;)V", true);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnThrowMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onThrow", "(Ljava/lang/Throwable;Lorg/glowroot/api/TraceEntry;)V", null, null);
        mv.visitAnnotation("Lorg/glowroot/api/weaving/OnThrow;", true).visitEnd();
        mv.visitParameterAnnotation(0, "Lorg/glowroot/api/weaving/BindThrowable;", true).visitEnd();
        mv.visitParameterAnnotation(1, "Lorg/glowroot/api/weaving/BindTraveler;", true).visitEnd();
        mv.visitCode();
        if (!this.config.traceEntryEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(199, l0);
            mv.visitInsn(177);
            mv.visitLabel(l0);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/glowroot/api/ErrorMessage", "from", "(Ljava/lang/Throwable;)Lorg/glowroot/api/ErrorMessage;", false);
        mv.visitMethodInsn(185, "org/glowroot/api/TraceEntry", "endWithError", "(Lorg/glowroot/api/ErrorMessage;)V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private LazyDefinedClass generateMethodMetaClass(InstrumentationConfig config) throws Exception {
        int i;
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, this.methodMetaInternalName, null, "java/lang/Object", null);
        cw.visitField(18, "messageTemplate", "Lorg/glowroot/advicegen/MessageTemplate;", null, null).visitEnd();
        if (!config.transactionNameTemplate().isEmpty()) {
            cw.visitField(18, "transactionNameTemplate", "Lorg/glowroot/advicegen/MessageTemplate;", null, null).visitEnd();
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            cw.visitField(18, "transactionUserTemplate", "Lorg/glowroot/advicegen/MessageTemplate;", null, null).visitEnd();
        }
        for (i = 0; i < config.transactionCustomAttributeTemplates().size(); ++i) {
            cw.visitField(18, "transactionCustomAttributeTemplate" + i, "Lorg/glowroot/advicegen/MessageTemplate;", null, null).visitEnd();
        }
        this.generateMethodMetaConstructor(cw);
        this.generateMethodMetaGetter(cw, "messageTemplate", "getMessageTemplate");
        if (!config.transactionNameTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionNameTemplate", "getTransactionNameTemplate");
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionUserTemplate", "getTransactionUserTemplate");
        }
        for (i = 0; i < config.transactionCustomAttributeTemplates().size(); ++i) {
            this.generateMethodMetaGetter(cw, "transactionCustomAttributeTemplate" + i, "getTransactionCustomAttributeTemplate" + i);
        }
        cw.visitEnd();
        return LazyDefinedClass.builder().type(Type.getObjectType(this.methodMetaInternalName)).bytes(cw.toByteArray()).build();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)V", "(Ljava/lang/Class<*>;Ljava/lang/Class<*>;[Ljava/lang/Class<*>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        if (this.config.isTraceEntryOrGreater()) {
            String traceEntryTemplate = this.config.traceEntryTemplate();
            if (traceEntryTemplate.isEmpty() && this.config.isTransaction()) {
                traceEntryTemplate = this.config.transactionNameTemplate();
            }
            if (traceEntryTemplate.isEmpty()) {
                mv.visitLdcInsn("<no message template provided>");
            } else {
                mv.visitLdcInsn(traceEntryTemplate);
            }
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/MessageTemplate", "create", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)Lorg/glowroot/advicegen/MessageTemplate;", false);
        } else {
            mv.visitInsn(1);
        }
        mv.visitFieldInsn(181, this.methodMetaInternalName, "messageTemplate", "Lorg/glowroot/advicegen/MessageTemplate;");
        if (!this.config.transactionNameTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionNameTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/MessageTemplate", "create", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionNameTemplate", "Lorg/glowroot/advicegen/MessageTemplate;");
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionUserTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/MessageTemplate", "create", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionUserTemplate", "Lorg/glowroot/advicegen/MessageTemplate;");
        }
        int i = 0;
        for (String attrTemplate : ((ImmutableMap)this.config.transactionCustomAttributeTemplates()).values()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(attrTemplate);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/advicegen/MessageTemplate", "create", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Class;)Lorg/glowroot/advicegen/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionCustomAttributeTemplate" + i++, "Lorg/glowroot/advicegen/MessageTemplate;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaGetter(ClassWriter cw, String fieldName, String methodName) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()Lorg/glowroot/advicegen/MessageTemplate;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.methodMetaInternalName, fieldName, "Lorg/glowroot/advicegen/MessageTemplate;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

