/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.api.internal;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.internal.ThrowableInfo;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableThrowableInfo
extends ThrowableInfo {
    private final String display;
    private final ImmutableList<StackTraceElement> stackTrace;
    private final int framesInCommonWithCaused;
    @Nullable
    private final ThrowableInfo cause;

    private ImmutableThrowableInfo(String display, ImmutableList<StackTraceElement> stackTrace, int framesInCommonWithCaused, @Nullable ThrowableInfo cause) {
        this.display = display;
        this.stackTrace = stackTrace;
        this.framesInCommonWithCaused = framesInCommonWithCaused;
        this.cause = cause;
    }

    @Override
    public String display() {
        return this.display;
    }

    public ImmutableList<StackTraceElement> stackTrace() {
        return this.stackTrace;
    }

    @Override
    public int framesInCommonWithCaused() {
        return this.framesInCommonWithCaused;
    }

    @Override
    public ThrowableInfo cause() {
        return this.cause;
    }

    public final ImmutableThrowableInfo withDisplay(String value) {
        if (this.display == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ImmutableThrowableInfo(newValue, this.stackTrace, this.framesInCommonWithCaused, this.cause);
    }

    public final ImmutableThrowableInfo withStackTrace(StackTraceElement ... elements) {
        ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
    }

    public final ImmutableThrowableInfo withStackTrace(Iterable<? extends StackTraceElement> elements) {
        if (this.stackTrace == elements) {
            return this;
        }
        ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
    }

    public final ImmutableThrowableInfo withFramesInCommonWithCaused(int value) {
        if (this.framesInCommonWithCaused == value) {
            return this;
        }
        int newValue = value;
        return new ImmutableThrowableInfo(this.display, this.stackTrace, newValue, this.cause);
    }

    public final ImmutableThrowableInfo withCause(@Nullable ThrowableInfo value) {
        if (this.cause == value) {
            return this;
        }
        ThrowableInfo newValue = value;
        return new ImmutableThrowableInfo(this.display, this.stackTrace, this.framesInCommonWithCaused, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableThrowableInfo && this.equalTo((ImmutableThrowableInfo)another);
    }

    private boolean equalTo(ImmutableThrowableInfo another) {
        return this.display.equals(another.display) && this.stackTrace.equals(another.stackTrace) && this.framesInCommonWithCaused == another.framesInCommonWithCaused && Objects.equal(this.cause, another.cause);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.display.hashCode();
        h = h * 17 + this.stackTrace.hashCode();
        h = h * 17 + this.framesInCommonWithCaused;
        h = h * 17 + Objects.hashCode(this.cause);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThrowableInfo").add("display", this.display).add("stackTrace", this.stackTrace).add("framesInCommonWithCaused", this.framesInCommonWithCaused).add("cause", this.cause).toString();
    }

    public static ImmutableThrowableInfo copyOf(ThrowableInfo instance) {
        if (instance instanceof ImmutableThrowableInfo) {
            return (ImmutableThrowableInfo)instance;
        }
        return ImmutableThrowableInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_DISPLAY = 1L;
        private static final long INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED = 2L;
        private long initializedBitset;
        @Nullable
        private String display;
        private ImmutableList.Builder<StackTraceElement> stackTraceBuilder = ImmutableList.builder();
        private int framesInCommonWithCaused;
        @Nullable
        private ThrowableInfo cause;

        private Builder() {
        }

        public final Builder from(ThrowableInfo instance) {
            Preconditions.checkNotNull(instance);
            this.display(instance.display());
            this.addAllStackTrace(instance.stackTrace());
            this.framesInCommonWithCaused(instance.framesInCommonWithCaused());
            ThrowableInfo causeValue = instance.cause();
            if (causeValue != null) {
                this.cause(causeValue);
            }
            return this;
        }

        public final Builder display(String display) {
            this.display = Preconditions.checkNotNull(display);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addStackTrace(StackTraceElement element) {
            this.stackTraceBuilder.add((Object)element);
            return this;
        }

        public final Builder addStackTrace(StackTraceElement ... elements) {
            this.stackTraceBuilder.add(elements);
            return this;
        }

        public final Builder stackTrace(Iterable<? extends StackTraceElement> elements) {
            this.stackTraceBuilder = ImmutableList.builder();
            return this.addAllStackTrace(elements);
        }

        public final Builder addAllStackTrace(Iterable<? extends StackTraceElement> elements) {
            this.stackTraceBuilder.addAll(elements);
            return this;
        }

        public final Builder framesInCommonWithCaused(int framesInCommonWithCaused) {
            this.framesInCommonWithCaused = framesInCommonWithCaused;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder cause(@Nullable ThrowableInfo cause) {
            this.cause = cause;
            return this;
        }

        public ImmutableThrowableInfo build() {
            this.checkRequiredAttributes();
            return new ImmutableThrowableInfo(this.display, (ImmutableList)this.stackTraceBuilder.build(), this.framesInCommonWithCaused, this.cause);
        }

        private boolean displayIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean framesInCommonWithCausedIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.displayIsSet()) {
                attributes.add("display");
            }
            if (!this.framesInCommonWithCausedIsSet()) {
                attributes.add("framesInCommonWithCaused");
            }
            return "Cannot build ThrowableInfo, some of required attributes are not set " + attributes;
        }
    }
}

