/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.model.Transaction;

@ParametersAreNonnullByDefault
@Immutable
final class PendingTransaction
extends AggregateCollector.PendingTransactionBase {
    private final long captureTime;
    private final Transaction transaction;

    private PendingTransaction(long captureTime, Transaction transaction) {
        this.captureTime = captureTime;
        this.transaction = transaction;
    }

    @Override
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    public Transaction transaction() {
        return this.transaction;
    }

    public final PendingTransaction withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new PendingTransaction(newValue, this.transaction);
    }

    public final PendingTransaction withTransaction(Transaction value) {
        if (this.transaction == value) {
            return this;
        }
        Transaction newValue = Preconditions.checkNotNull(value);
        return new PendingTransaction(this.captureTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PendingTransaction && this.equalTo((PendingTransaction)another);
    }

    private boolean equalTo(PendingTransaction another) {
        return this.captureTime == another.captureTime && this.transaction.equals(another.transaction);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + this.transaction.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PendingTransaction").add("captureTime", this.captureTime).add("transaction", this.transaction).toString();
    }

    public static PendingTransaction of(long captureTime, Transaction transaction) {
        return new PendingTransaction(captureTime, transaction);
    }

    static PendingTransaction copyOf(AggregateCollector.PendingTransactionBase instance) {
        if (instance instanceof PendingTransaction) {
            return (PendingTransaction)instance;
        }
        return PendingTransaction.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 1L;
        private static final long INITIALIZED_BIT_TRANSACTION = 2L;
        private long initializedBitset;
        private long captureTime;
        @Nullable
        private Transaction transaction;

        private Builder() {
        }

        public final Builder all(AggregateCollector.PendingTransactionBase instance) {
            Preconditions.checkNotNull(instance);
            this.captureTime(instance.captureTime());
            this.transaction(instance.transaction());
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transaction(Transaction transaction) {
            this.transaction = Preconditions.checkNotNull(transaction);
            this.initializedBitset |= 2L;
            return this;
        }

        public PendingTransaction build() {
            this.checkRequiredAttributes();
            return new PendingTransaction(this.captureTime, this.transaction);
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean transactionIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.transactionIsSet()) {
                attributes.add("transaction");
            }
            return "Cannot build PendingTransaction, some of required attributes are not set " + attributes;
        }
    }
}

