/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.ProfileAggregateBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class ProfileAggregate
extends ProfileAggregateBase {
    private final long captureTime;
    private final CharSource profile;

    private ProfileAggregate(long captureTime, CharSource profile) {
        this.captureTime = captureTime;
        this.profile = profile;
    }

    @Override
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonRawValue
    public CharSource profile() {
        return this.profile;
    }

    public final ProfileAggregate withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new ProfileAggregate(newValue, this.profile);
    }

    public final ProfileAggregate withProfile(CharSource value) {
        if (this.profile == value) {
            return this;
        }
        CharSource newValue = Preconditions.checkNotNull(value);
        return new ProfileAggregate(this.captureTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ProfileAggregate && this.equalTo((ProfileAggregate)another);
    }

    private boolean equalTo(ProfileAggregate another) {
        return this.captureTime == another.captureTime && this.profile.equals(another.profile);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + this.profile.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ProfileAggregate").add("captureTime", this.captureTime).add("profile", this.profile).toString();
    }

    public static ProfileAggregate of(long captureTime, CharSource profile) {
        return new ProfileAggregate(captureTime, profile);
    }

    public static ProfileAggregate copyOf(ProfileAggregateBase instance) {
        if (instance instanceof ProfileAggregate) {
            return (ProfileAggregate)instance;
        }
        return ProfileAggregate.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 1L;
        private static final long INITIALIZED_BIT_PROFILE = 2L;
        private long initializedBitset;
        private long captureTime;
        @Nullable
        private CharSource profile;

        private Builder() {
        }

        public final Builder all(ProfileAggregateBase instance) {
            Preconditions.checkNotNull(instance);
            this.captureTime(instance.captureTime());
            this.profile(instance.profile());
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder profile(CharSource profile) {
            this.profile = Preconditions.checkNotNull(profile);
            this.initializedBitset |= 2L;
            return this;
        }

        public ProfileAggregate build() {
            this.checkRequiredAttributes();
            return new ProfileAggregate(this.captureTime, this.profile);
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean profileIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.profileIsSet()) {
                attributes.add("profile");
            }
            return "Cannot build ProfileAggregate, some of required attributes are not set " + attributes;
        }
    }
}

