/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.QueryAggregateBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class QueryAggregate
extends QueryAggregateBase {
    private final long captureTime;
    private final CharSource queries;

    private QueryAggregate(long captureTime, CharSource queries) {
        this.captureTime = captureTime;
        this.queries = queries;
    }

    @Override
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonRawValue
    public CharSource queries() {
        return this.queries;
    }

    public final QueryAggregate withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new QueryAggregate(newValue, this.queries);
    }

    public final QueryAggregate withQueries(CharSource value) {
        if (this.queries == value) {
            return this;
        }
        CharSource newValue = Preconditions.checkNotNull(value);
        return new QueryAggregate(this.captureTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof QueryAggregate && this.equalTo((QueryAggregate)another);
    }

    private boolean equalTo(QueryAggregate another) {
        return this.captureTime == another.captureTime && this.queries.equals(another.queries);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + this.queries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryAggregate").add("captureTime", this.captureTime).add("queries", this.queries).toString();
    }

    public static QueryAggregate of(long captureTime, CharSource queries) {
        return new QueryAggregate(captureTime, queries);
    }

    public static QueryAggregate copyOf(QueryAggregateBase instance) {
        if (instance instanceof QueryAggregate) {
            return (QueryAggregate)instance;
        }
        return QueryAggregate.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 1L;
        private static final long INITIALIZED_BIT_QUERIES = 2L;
        private long initializedBitset;
        private long captureTime;
        @Nullable
        private CharSource queries;

        private Builder() {
        }

        public final Builder all(QueryAggregateBase instance) {
            Preconditions.checkNotNull(instance);
            this.captureTime(instance.captureTime());
            this.queries(instance.queries());
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder queries(CharSource queries) {
            this.queries = Preconditions.checkNotNull(queries);
            this.initializedBitset |= 2L;
            return this;
        }

        public QueryAggregate build() {
            this.checkRequiredAttributes();
            return new QueryAggregate(this.captureTime, this.queries);
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean queriesIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.queriesIsSet()) {
                attributes.add("queries");
            }
            return "Cannot build QueryAggregate, some of required attributes are not set " + attributes;
        }
    }
}

