/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.Existence;
import org.glowroot.collector.TraceBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableSetMultimap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Multimap;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class Trace
extends TraceBase {
    private final String id;
    private final boolean active;
    private final boolean partial;
    private final boolean error;
    private final long startTime;
    private final long captureTime;
    private final long duration;
    private final String transactionType;
    private final String transactionName;
    private final String headline;
    @Nullable
    private final String user;
    @Nullable
    private final String customAttributes;
    @Nullable
    private final String customDetail;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String errorThrowable;
    @Nullable
    private final String timers;
    @Nullable
    private final Long threadCpuTime;
    @Nullable
    private final Long threadBlockedTime;
    @Nullable
    private final Long threadWaitedTime;
    @Nullable
    private final Long threadAllocatedBytes;
    @Nullable
    private final String gcInfos;
    private final long entryCount;
    private final long profileSampleCount;
    private final Existence entriesExistence;
    private final Existence profileExistence;
    private final ImmutableSetMultimap<String, String> customAttributesForIndexing;

    private Trace(String id, boolean active, boolean partial, boolean error, long startTime, long captureTime, long duration, String transactionType, String transactionName, String headline, @Nullable String user, @Nullable String customAttributes, @Nullable String customDetail, @Nullable String errorMessage, @Nullable String errorThrowable, @Nullable String timers, @Nullable Long threadCpuTime, @Nullable Long threadBlockedTime, @Nullable Long threadWaitedTime, @Nullable Long threadAllocatedBytes, @Nullable String gcInfos, long entryCount, long profileSampleCount, Existence entriesExistence, Existence profileExistence, ImmutableSetMultimap<String, String> customAttributesForIndexing) {
        this.id = id;
        this.active = active;
        this.partial = partial;
        this.error = error;
        this.startTime = startTime;
        this.captureTime = captureTime;
        this.duration = duration;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.headline = headline;
        this.user = user;
        this.customAttributes = customAttributes;
        this.customDetail = customDetail;
        this.errorMessage = errorMessage;
        this.errorThrowable = errorThrowable;
        this.timers = timers;
        this.threadCpuTime = threadCpuTime;
        this.threadBlockedTime = threadBlockedTime;
        this.threadWaitedTime = threadWaitedTime;
        this.threadAllocatedBytes = threadAllocatedBytes;
        this.gcInfos = gcInfos;
        this.entryCount = entryCount;
        this.profileSampleCount = profileSampleCount;
        this.entriesExistence = entriesExistence;
        this.profileExistence = profileExistence;
        this.customAttributesForIndexing = customAttributesForIndexing;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="active")
    public boolean active() {
        return this.active;
    }

    @Override
    @JsonProperty(value="partial")
    public boolean partial() {
        return this.partial;
    }

    @Override
    @JsonProperty(value="error")
    public boolean error() {
        return this.error;
    }

    @Override
    @JsonProperty(value="startTime")
    public long startTime() {
        return this.startTime;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="duration")
    public long duration() {
        return this.duration;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="headline")
    public String headline() {
        return this.headline;
    }

    @Override
    @JsonProperty(value="user")
    public String user() {
        return this.user;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="customAttributes")
    public String customAttributes() {
        return this.customAttributes;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="customDetail")
    public String customDetail() {
        return this.customDetail;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="errorThrowable")
    public String errorThrowable() {
        return this.errorThrowable;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="timers")
    public String timers() {
        return this.timers;
    }

    @Override
    @JsonProperty(value="threadCpuTime")
    public Long threadCpuTime() {
        return this.threadCpuTime;
    }

    @Override
    @JsonProperty(value="threadBlockedTime")
    public Long threadBlockedTime() {
        return this.threadBlockedTime;
    }

    @Override
    @JsonProperty(value="threadWaitedTime")
    public Long threadWaitedTime() {
        return this.threadWaitedTime;
    }

    @Override
    @JsonProperty(value="threadAllocatedBytes")
    public Long threadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="gcInfos")
    public String gcInfos() {
        return this.gcInfos;
    }

    @Override
    @JsonProperty(value="entryCount")
    public long entryCount() {
        return this.entryCount;
    }

    @Override
    @JsonProperty(value="profileSampleCount")
    public long profileSampleCount() {
        return this.profileSampleCount;
    }

    @Override
    @JsonProperty(value="entriesExistence")
    public Existence entriesExistence() {
        return this.entriesExistence;
    }

    @Override
    @JsonProperty(value="profileExistence")
    public Existence profileExistence() {
        return this.profileExistence;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="customAttributesForIndexing")
    public ImmutableSetMultimap<String, String> customAttributesForIndexing() {
        return this.customAttributesForIndexing;
    }

    public final Trace withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Trace(newValue, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withActive(boolean value) {
        if (this.active == value) {
            return this;
        }
        boolean newValue = value;
        return new Trace(this.id, newValue, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withPartial(boolean value) {
        if (this.partial == value) {
            return this;
        }
        boolean newValue = value;
        return new Trace(this.id, this.active, newValue, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withError(boolean value) {
        if (this.error == value) {
            return this;
        }
        boolean newValue = value;
        return new Trace(this.id, this.active, this.partial, newValue, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withStartTime(long value) {
        if (this.startTime == value) {
            return this;
        }
        long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, newValue, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, newValue, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withDuration(long value) {
        if (this.duration == value) {
            return this;
        }
        long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, newValue, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, newValue, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withTransactionName(String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, newValue, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withHeadline(String value) {
        if (this.headline == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, newValue, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withUser(@Nullable String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, newValue, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withCustomAttributes(@Nullable String value) {
        if (this.customAttributes == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, newValue, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withCustomDetail(@Nullable String value) {
        if (this.customDetail == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, newValue, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withErrorMessage(@Nullable String value) {
        if (this.errorMessage == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, newValue, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withErrorThrowable(@Nullable String value) {
        if (this.errorThrowable == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, newValue, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withTimers(@Nullable String value) {
        if (this.timers == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, newValue, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withThreadCpuTime(@Nullable Long value) {
        if (this.threadCpuTime == value) {
            return this;
        }
        Long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, newValue, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withThreadBlockedTime(@Nullable Long value) {
        if (this.threadBlockedTime == value) {
            return this;
        }
        Long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, newValue, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withThreadWaitedTime(@Nullable Long value) {
        if (this.threadWaitedTime == value) {
            return this;
        }
        Long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, newValue, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withThreadAllocatedBytes(@Nullable Long value) {
        if (this.threadAllocatedBytes == value) {
            return this;
        }
        Long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, newValue, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withGcInfos(@Nullable String value) {
        if (this.gcInfos == value) {
            return this;
        }
        String newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, newValue, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withEntryCount(long value) {
        if (this.entryCount == value) {
            return this;
        }
        long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, newValue, this.profileSampleCount, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withProfileSampleCount(long value) {
        if (this.profileSampleCount == value) {
            return this;
        }
        long newValue = value;
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, newValue, this.entriesExistence, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withEntriesExistence(Existence value) {
        if (this.entriesExistence == value) {
            return this;
        }
        Existence newValue = Preconditions.checkNotNull(value);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, newValue, this.profileExistence, this.customAttributesForIndexing);
    }

    public final Trace withProfileExistence(Existence value) {
        if (this.profileExistence == value) {
            return this;
        }
        Existence newValue = Preconditions.checkNotNull(value);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, newValue, this.customAttributesForIndexing);
    }

    public final Trace withCustomAttributesForIndexing(Multimap<String, ? extends String> entries) {
        if (this.customAttributesForIndexing == entries) {
            return this;
        }
        ImmutableSetMultimap<String, String> newValue = ImmutableSetMultimap.copyOf(entries);
        return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Trace && this.equalTo((Trace)another);
    }

    private boolean equalTo(Trace another) {
        return this.id.equals(another.id) && this.active == another.active && this.partial == another.partial && this.error == another.error && this.startTime == another.startTime && this.captureTime == another.captureTime && this.duration == another.duration && this.transactionType.equals(another.transactionType) && this.transactionName.equals(another.transactionName) && this.headline.equals(another.headline) && Objects.equal(this.user, another.user) && Objects.equal(this.customAttributes, another.customAttributes) && Objects.equal(this.customDetail, another.customDetail) && Objects.equal(this.errorMessage, another.errorMessage) && Objects.equal(this.errorThrowable, another.errorThrowable) && Objects.equal(this.timers, another.timers) && Objects.equal(this.threadCpuTime, another.threadCpuTime) && Objects.equal(this.threadBlockedTime, another.threadBlockedTime) && Objects.equal(this.threadWaitedTime, another.threadWaitedTime) && Objects.equal(this.threadAllocatedBytes, another.threadAllocatedBytes) && Objects.equal(this.gcInfos, another.gcInfos) && this.entryCount == another.entryCount && this.profileSampleCount == another.profileSampleCount && this.entriesExistence.equals((Object)another.entriesExistence) && this.profileExistence.equals((Object)another.profileExistence) && this.customAttributesForIndexing.equals(another.customAttributesForIndexing);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Booleans.hashCode(this.active);
        h = h * 17 + Booleans.hashCode(this.partial);
        h = h * 17 + Booleans.hashCode(this.error);
        h = h * 17 + Longs.hashCode(this.startTime);
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Longs.hashCode(this.duration);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + this.transactionName.hashCode();
        h = h * 17 + this.headline.hashCode();
        h = h * 17 + Objects.hashCode(this.user);
        h = h * 17 + Objects.hashCode(this.customAttributes);
        h = h * 17 + Objects.hashCode(this.customDetail);
        h = h * 17 + Objects.hashCode(this.errorMessage);
        h = h * 17 + Objects.hashCode(this.errorThrowable);
        h = h * 17 + Objects.hashCode(this.timers);
        h = h * 17 + Objects.hashCode(this.threadCpuTime);
        h = h * 17 + Objects.hashCode(this.threadBlockedTime);
        h = h * 17 + Objects.hashCode(this.threadWaitedTime);
        h = h * 17 + Objects.hashCode(this.threadAllocatedBytes);
        h = h * 17 + Objects.hashCode(this.gcInfos);
        h = h * 17 + Longs.hashCode(this.entryCount);
        h = h * 17 + Longs.hashCode(this.profileSampleCount);
        h = h * 17 + this.entriesExistence.hashCode();
        h = h * 17 + this.profileExistence.hashCode();
        h = h * 17 + this.customAttributesForIndexing.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Trace").add("id", this.id).add("active", this.active).add("partial", this.partial).add("error", this.error).add("startTime", this.startTime).add("captureTime", this.captureTime).add("duration", this.duration).add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("headline", this.headline).add("user", this.user).add("customAttributes", this.customAttributes).add("customDetail", this.customDetail).add("errorMessage", this.errorMessage).add("errorThrowable", this.errorThrowable).add("timers", this.timers).add("threadCpuTime", this.threadCpuTime).add("threadBlockedTime", this.threadBlockedTime).add("threadWaitedTime", this.threadWaitedTime).add("threadAllocatedBytes", this.threadAllocatedBytes).add("gcInfos", this.gcInfos).add("entryCount", this.entryCount).add("profileSampleCount", this.profileSampleCount).add("entriesExistence", (Object)this.entriesExistence).add("profileExistence", (Object)this.profileExistence).add("customAttributesForIndexing", this.customAttributesForIndexing).toString();
    }

    @JsonCreator
    public static Trace fromAllAttributes(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="active") @Nullable Boolean active, @JsonProperty(value="partial") @Nullable Boolean partial, @JsonProperty(value="error") @Nullable Boolean error, @JsonProperty(value="startTime") @Nullable Long startTime, @JsonProperty(value="captureTime") @Nullable Long captureTime, @JsonProperty(value="duration") @Nullable Long duration, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="headline") @Nullable String headline, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="customAttributes") @Nullable String customAttributes, @JsonProperty(value="customDetail") @Nullable String customDetail, @JsonProperty(value="errorMessage") @Nullable String errorMessage, @JsonProperty(value="errorThrowable") @Nullable String errorThrowable, @JsonProperty(value="timers") @Nullable String timers, @JsonProperty(value="threadCpuTime") @Nullable Long threadCpuTime, @JsonProperty(value="threadBlockedTime") @Nullable Long threadBlockedTime, @JsonProperty(value="threadWaitedTime") @Nullable Long threadWaitedTime, @JsonProperty(value="threadAllocatedBytes") @Nullable Long threadAllocatedBytes, @JsonProperty(value="gcInfos") @Nullable String gcInfos, @JsonProperty(value="entryCount") @Nullable Long entryCount, @JsonProperty(value="profileSampleCount") @Nullable Long profileSampleCount, @JsonProperty(value="entriesExistence") @Nullable Existence entriesExistence, @JsonProperty(value="profileExistence") @Nullable Existence profileExistence, @JsonProperty(value="customAttributesForIndexing") @Nullable ImmutableSetMultimap<String, String> customAttributesForIndexing) {
        Builder builder = Trace.builder();
        if (id != null) {
            builder.id(id);
        }
        if (active != null) {
            builder.active(active);
        }
        if (partial != null) {
            builder.partial(partial);
        }
        if (error != null) {
            builder.error(error);
        }
        if (startTime != null) {
            builder.startTime(startTime);
        }
        if (captureTime != null) {
            builder.captureTime(captureTime);
        }
        if (duration != null) {
            builder.duration(duration);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (headline != null) {
            builder.headline(headline);
        }
        if (user != null) {
            builder.user(user);
        }
        if (customAttributes != null) {
            builder.customAttributes(customAttributes);
        }
        if (customDetail != null) {
            builder.customDetail(customDetail);
        }
        if (errorMessage != null) {
            builder.errorMessage(errorMessage);
        }
        if (errorThrowable != null) {
            builder.errorThrowable(errorThrowable);
        }
        if (timers != null) {
            builder.timers(timers);
        }
        if (threadCpuTime != null) {
            builder.threadCpuTime(threadCpuTime);
        }
        if (threadBlockedTime != null) {
            builder.threadBlockedTime(threadBlockedTime);
        }
        if (threadWaitedTime != null) {
            builder.threadWaitedTime(threadWaitedTime);
        }
        if (threadAllocatedBytes != null) {
            builder.threadAllocatedBytes(threadAllocatedBytes);
        }
        if (gcInfos != null) {
            builder.gcInfos(gcInfos);
        }
        if (entryCount != null) {
            builder.entryCount(entryCount);
        }
        if (profileSampleCount != null) {
            builder.profileSampleCount(profileSampleCount);
        }
        if (entriesExistence != null) {
            builder.entriesExistence(entriesExistence);
        }
        if (profileExistence != null) {
            builder.profileExistence(profileExistence);
        }
        if (customAttributesForIndexing != null) {
            builder.putAllCustomAttributesForIndexing(customAttributesForIndexing);
        }
        return builder.build();
    }

    public static Trace copyOf(TraceBase instance) {
        if (instance instanceof Trace) {
            return (Trace)instance;
        }
        return Trace.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 16383L;
        private static final long INITIALIZED_BIT_ID = 1L;
        private static final long INITIALIZED_BIT_ACTIVE = 2L;
        private static final long INITIALIZED_BIT_PARTIAL = 4L;
        private static final long INITIALIZED_BIT_ERROR = 8L;
        private static final long INITIALIZED_BIT_START_TIME = 16L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 32L;
        private static final long INITIALIZED_BIT_DURATION = 64L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 128L;
        private static final long INITIALIZED_BIT_TRANSACTION_NAME = 256L;
        private static final long INITIALIZED_BIT_HEADLINE = 512L;
        private static final long INITIALIZED_BIT_ENTRY_COUNT = 1024L;
        private static final long INITIALIZED_BIT_PROFILE_SAMPLE_COUNT = 2048L;
        private static final long INITIALIZED_BIT_ENTRIES_EXISTENCE = 4096L;
        private static final long INITIALIZED_BIT_PROFILE_EXISTENCE = 8192L;
        private long initializedBitset;
        @Nullable
        private String id;
        private boolean active;
        private boolean partial;
        private boolean error;
        private long startTime;
        private long captureTime;
        private long duration;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        @Nullable
        private String headline;
        @Nullable
        private String user;
        @Nullable
        private String customAttributes;
        @Nullable
        private String customDetail;
        @Nullable
        private String errorMessage;
        @Nullable
        private String errorThrowable;
        @Nullable
        private String timers;
        @Nullable
        private Long threadCpuTime;
        @Nullable
        private Long threadBlockedTime;
        @Nullable
        private Long threadWaitedTime;
        @Nullable
        private Long threadAllocatedBytes;
        @Nullable
        private String gcInfos;
        private long entryCount;
        private long profileSampleCount;
        @Nullable
        private Existence entriesExistence;
        @Nullable
        private Existence profileExistence;
        private ImmutableSetMultimap.Builder<String, String> customAttributesForIndexingBuilder = ImmutableSetMultimap.builder();

        private Builder() {
        }

        public final Builder all(TraceBase instance) {
            String gcInfosValue;
            Long threadAllocatedBytesValue;
            Long threadWaitedTimeValue;
            Long threadBlockedTimeValue;
            Long threadCpuTimeValue;
            String timersValue;
            String errorThrowableValue;
            String errorMessageValue;
            String customDetailValue;
            String customAttributesValue;
            Preconditions.checkNotNull(instance);
            this.id(instance.id());
            this.active(instance.active());
            this.partial(instance.partial());
            this.error(instance.error());
            this.startTime(instance.startTime());
            this.captureTime(instance.captureTime());
            this.duration(instance.duration());
            this.transactionType(instance.transactionType());
            this.transactionName(instance.transactionName());
            this.headline(instance.headline());
            String userValue = instance.user();
            if (userValue != null) {
                this.user(userValue);
            }
            if ((customAttributesValue = instance.customAttributes()) != null) {
                this.customAttributes(customAttributesValue);
            }
            if ((customDetailValue = instance.customDetail()) != null) {
                this.customDetail(customDetailValue);
            }
            if ((errorMessageValue = instance.errorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((errorThrowableValue = instance.errorThrowable()) != null) {
                this.errorThrowable(errorThrowableValue);
            }
            if ((timersValue = instance.timers()) != null) {
                this.timers(timersValue);
            }
            if ((threadCpuTimeValue = instance.threadCpuTime()) != null) {
                this.threadCpuTime(threadCpuTimeValue);
            }
            if ((threadBlockedTimeValue = instance.threadBlockedTime()) != null) {
                this.threadBlockedTime(threadBlockedTimeValue);
            }
            if ((threadWaitedTimeValue = instance.threadWaitedTime()) != null) {
                this.threadWaitedTime(threadWaitedTimeValue);
            }
            if ((threadAllocatedBytesValue = instance.threadAllocatedBytes()) != null) {
                this.threadAllocatedBytes(threadAllocatedBytesValue);
            }
            if ((gcInfosValue = instance.gcInfos()) != null) {
                this.gcInfos(gcInfosValue);
            }
            this.entryCount(instance.entryCount());
            this.profileSampleCount(instance.profileSampleCount());
            this.entriesExistence(instance.entriesExistence());
            this.profileExistence(instance.profileExistence());
            this.putAllCustomAttributesForIndexing(instance.customAttributesForIndexing());
            return this;
        }

        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder active(boolean active) {
            this.active = active;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder partial(boolean partial) {
            this.partial = partial;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder error(boolean error) {
            this.error = error;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder startTime(long startTime) {
            this.startTime = startTime;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder duration(long duration) {
            this.duration = duration;
            this.initializedBitset |= 0x40L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 0x80L;
            return this;
        }

        public final Builder transactionName(String transactionName) {
            this.transactionName = Preconditions.checkNotNull(transactionName);
            this.initializedBitset |= 0x100L;
            return this;
        }

        public final Builder headline(String headline) {
            this.headline = Preconditions.checkNotNull(headline);
            this.initializedBitset |= 0x200L;
            return this;
        }

        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder customAttributes(@Nullable String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final Builder customDetail(@Nullable String customDetail) {
            this.customDetail = customDetail;
            return this;
        }

        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder errorThrowable(@Nullable String errorThrowable) {
            this.errorThrowable = errorThrowable;
            return this;
        }

        public final Builder timers(@Nullable String timers) {
            this.timers = timers;
            return this;
        }

        public final Builder threadCpuTime(@Nullable Long threadCpuTime) {
            this.threadCpuTime = threadCpuTime;
            return this;
        }

        public final Builder threadBlockedTime(@Nullable Long threadBlockedTime) {
            this.threadBlockedTime = threadBlockedTime;
            return this;
        }

        public final Builder threadWaitedTime(@Nullable Long threadWaitedTime) {
            this.threadWaitedTime = threadWaitedTime;
            return this;
        }

        public final Builder threadAllocatedBytes(@Nullable Long threadAllocatedBytes) {
            this.threadAllocatedBytes = threadAllocatedBytes;
            return this;
        }

        public final Builder gcInfos(@Nullable String gcInfos) {
            this.gcInfos = gcInfos;
            return this;
        }

        public final Builder entryCount(long entryCount) {
            this.entryCount = entryCount;
            this.initializedBitset |= 0x400L;
            return this;
        }

        public final Builder profileSampleCount(long profileSampleCount) {
            this.profileSampleCount = profileSampleCount;
            this.initializedBitset |= 0x800L;
            return this;
        }

        public final Builder entriesExistence(Existence entriesExistence) {
            this.entriesExistence = Preconditions.checkNotNull(entriesExistence);
            this.initializedBitset |= 0x1000L;
            return this;
        }

        public final Builder profileExistence(Existence profileExistence) {
            this.profileExistence = Preconditions.checkNotNull(profileExistence);
            this.initializedBitset |= 0x2000L;
            return this;
        }

        public final Builder putCustomAttributesForIndexing(String key, String ... values) {
            this.customAttributesForIndexingBuilder.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        public final Builder putAllCustomAttributesForIndexing(String key, Iterable<String> values) {
            this.customAttributesForIndexingBuilder.putAll((Object)key, values);
            return this;
        }

        public final Builder putCustomAttributesForIndexing(String key, String value) {
            this.customAttributesForIndexingBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putCustomAttributesForIndexing(Map.Entry<String, ? extends String> entry) {
            this.customAttributesForIndexingBuilder.put(entry);
            return this;
        }

        public final Builder customAttributesForIndexing(Multimap<String, ? extends String> entries) {
            this.customAttributesForIndexingBuilder = ImmutableSetMultimap.builder();
            return this.putAllCustomAttributesForIndexing(entries);
        }

        public final Builder putAllCustomAttributesForIndexing(Multimap<String, ? extends String> entries) {
            this.customAttributesForIndexingBuilder.putAll(entries);
            return this;
        }

        public Trace build() {
            this.checkRequiredAttributes();
            return new Trace(this.id, this.active, this.partial, this.error, this.startTime, this.captureTime, this.duration, this.transactionType, this.transactionName, this.headline, this.user, this.customAttributes, this.customDetail, this.errorMessage, this.errorThrowable, this.timers, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes, this.gcInfos, this.entryCount, this.profileSampleCount, this.entriesExistence, this.profileExistence, (ImmutableSetMultimap)this.customAttributesForIndexingBuilder.build());
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean activeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean partialIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean errorIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean startTimeIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean durationIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 0x80L) != 0L;
        }

        private boolean transactionNameIsSet() {
            return (this.initializedBitset & 0x100L) != 0L;
        }

        private boolean headlineIsSet() {
            return (this.initializedBitset & 0x200L) != 0L;
        }

        private boolean entryCountIsSet() {
            return (this.initializedBitset & 0x400L) != 0L;
        }

        private boolean profileSampleCountIsSet() {
            return (this.initializedBitset & 0x800L) != 0L;
        }

        private boolean entriesExistenceIsSet() {
            return (this.initializedBitset & 0x1000L) != 0L;
        }

        private boolean profileExistenceIsSet() {
            return (this.initializedBitset & 0x2000L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 16383L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.activeIsSet()) {
                attributes.add("active");
            }
            if (!this.partialIsSet()) {
                attributes.add("partial");
            }
            if (!this.errorIsSet()) {
                attributes.add("error");
            }
            if (!this.startTimeIsSet()) {
                attributes.add("startTime");
            }
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.durationIsSet()) {
                attributes.add("duration");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.transactionNameIsSet()) {
                attributes.add("transactionName");
            }
            if (!this.headlineIsSet()) {
                attributes.add("headline");
            }
            if (!this.entryCountIsSet()) {
                attributes.add("entryCount");
            }
            if (!this.profileSampleCountIsSet()) {
                attributes.add("profileSampleCount");
            }
            if (!this.entriesExistenceIsSet()) {
                attributes.add("entriesExistence");
            }
            if (!this.profileExistenceIsSet()) {
                attributes.add("profileExistence");
            }
            return "Cannot build Trace, some of required attributes are not set " + attributes;
        }
    }
}

