/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.TransactionSummaryBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class TransactionSummary
extends TransactionSummaryBase {
    @Nullable
    private final String transactionName;
    private final long totalMicros;
    private final long transactionCount;

    private TransactionSummary(@Nullable String transactionName, long totalMicros, long transactionCount) {
        this.transactionName = transactionName;
        this.totalMicros = totalMicros;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="totalMicros")
    public long totalMicros() {
        return this.totalMicros;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final TransactionSummary withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TransactionSummary(newValue, this.totalMicros, this.transactionCount);
    }

    public final TransactionSummary withTotalMicros(long value) {
        if (this.totalMicros == value) {
            return this;
        }
        long newValue = value;
        return new TransactionSummary(this.transactionName, newValue, this.transactionCount);
    }

    public final TransactionSummary withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new TransactionSummary(this.transactionName, this.totalMicros, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionSummary && this.equalTo((TransactionSummary)another);
    }

    private boolean equalTo(TransactionSummary another) {
        return Objects.equal(this.transactionName, another.transactionName) && this.totalMicros == another.totalMicros && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Longs.hashCode(this.totalMicros);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionSummary").add("transactionName", this.transactionName).add("totalMicros", this.totalMicros).add("transactionCount", this.transactionCount).toString();
    }

    @JsonCreator
    public static TransactionSummary fromAllAttributes(@JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="transactionCount") @Nullable Long transactionCount) {
        Builder builder = TransactionSummary.builder();
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (totalMicros != null) {
            builder.totalMicros(totalMicros);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        return builder.build();
    }

    public static TransactionSummary copyOf(TransactionSummaryBase instance) {
        if (instance instanceof TransactionSummary) {
            return (TransactionSummary)instance;
        }
        return TransactionSummary.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_TOTAL_MICROS = 1L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 2L;
        private long initializedBitset;
        @Nullable
        private String transactionName;
        private long totalMicros;
        private long transactionCount;

        private Builder() {
        }

        public final Builder all(TransactionSummaryBase instance) {
            Preconditions.checkNotNull(instance);
            String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.totalMicros(instance.totalMicros());
            this.transactionCount(instance.transactionCount());
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder totalMicros(long totalMicros) {
            this.totalMicros = totalMicros;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.transactionCount = transactionCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public TransactionSummary build() {
            this.checkRequiredAttributes();
            return new TransactionSummary(this.transactionName, this.totalMicros, this.transactionCount);
        }

        private boolean totalMicrosIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.totalMicrosIsSet()) {
                attributes.add("totalMicros");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build TransactionSummary, some of required attributes are not set " + attributes;
        }
    }
}

