/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.common.SpyingLogbackFilter;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
public final class MessageCount
extends SpyingLogbackFilter.MessageCountBase {
    private final int expectedCount;
    private final int unexpectedCount;

    private MessageCount(int expectedCount, int unexpectedCount) {
        this.expectedCount = expectedCount;
        this.unexpectedCount = unexpectedCount;
    }

    @Override
    public int expectedCount() {
        return this.expectedCount;
    }

    @Override
    public int unexpectedCount() {
        return this.unexpectedCount;
    }

    public final MessageCount withExpectedCount(int value) {
        if (this.expectedCount == value) {
            return this;
        }
        int newValue = value;
        return new MessageCount(newValue, this.unexpectedCount);
    }

    public final MessageCount withUnexpectedCount(int value) {
        if (this.unexpectedCount == value) {
            return this;
        }
        int newValue = value;
        return new MessageCount(this.expectedCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MessageCount && this.equalTo((MessageCount)another);
    }

    private boolean equalTo(MessageCount another) {
        return this.expectedCount == another.expectedCount && this.unexpectedCount == another.unexpectedCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.expectedCount;
        h = h * 17 + this.unexpectedCount;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MessageCount").add("expectedCount", this.expectedCount).add("unexpectedCount", this.unexpectedCount).toString();
    }

    public static MessageCount of(int expectedCount, int unexpectedCount) {
        return new MessageCount(expectedCount, unexpectedCount);
    }

    public static MessageCount copyOf(SpyingLogbackFilter.MessageCountBase instance) {
        if (instance instanceof MessageCount) {
            return (MessageCount)instance;
        }
        return MessageCount.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_EXPECTED_COUNT = 1L;
        private static final long INITIALIZED_BIT_UNEXPECTED_COUNT = 2L;
        private long initializedBitset;
        private int expectedCount;
        private int unexpectedCount;

        private Builder() {
        }

        public final Builder all(SpyingLogbackFilter.MessageCountBase instance) {
            Preconditions.checkNotNull(instance);
            this.expectedCount(instance.expectedCount());
            this.unexpectedCount(instance.unexpectedCount());
            return this;
        }

        public final Builder expectedCount(int expectedCount) {
            this.expectedCount = expectedCount;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder unexpectedCount(int unexpectedCount) {
            this.unexpectedCount = unexpectedCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public MessageCount build() {
            this.checkRequiredAttributes();
            return new MessageCount(this.expectedCount, this.unexpectedCount);
        }

        private boolean expectedCountIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean unexpectedCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.expectedCountIsSet()) {
                attributes.add("expectedCount");
            }
            if (!this.unexpectedCountIsSet()) {
                attributes.add("unexpectedCount");
            }
            return "Cannot build MessageCount, some of required attributes are not set " + attributes;
        }
    }
}

