/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class Reflections {
    private static final Logger logger = LoggerFactory.getLogger(Reflections.class);

    private Reflections() {
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    public static Method getAnyMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            return Reflections.getMethod(clazz, name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            return Reflections.getAnyDeclaredMethod(clazz, name, parameterTypes);
        }
    }

    private static Method getAnyDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Reflections.getAnyDeclaredMethod(superClass, name, parameterTypes);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws Exception {
        Constructor<T> constructor = clazz.getConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    public static Field getAnyField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            return Reflections.getAnyDeclaredField(clazz, fieldName);
        }
    }

    private static Field getAnyDeclaredField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Reflections.getAnyDeclaredField(superClass, fieldName);
        }
    }

    @Nullable
    public static Object invoke(Method method, Object obj, Object ... args) throws Exception {
        return method.invoke(obj, args);
    }

    @Nullable
    public static Object invokeStatic(Method method, Object ... args) throws Exception {
        return method.invoke(null, args);
    }

    public static <T> T invoke(Constructor<T> constructor, Object ... args) throws Exception {
        return constructor.newInstance(args);
    }

    @Nullable
    public static Object getFieldValue(Field field, Object obj) throws Exception {
        return field.get(obj);
    }
}

