/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.glowroot.common.ExpectedMessage;
import org.glowroot.common.MessageCount;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.qos.logback.classic.Level;
import org.glowroot.shaded.qos.logback.classic.Logger;
import org.glowroot.shaded.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.shaded.qos.logback.core.Appender;
import org.glowroot.shaded.qos.logback.core.ConsoleAppender;
import org.glowroot.shaded.qos.logback.core.filter.Filter;
import org.glowroot.shaded.qos.logback.core.spi.FilterReply;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@OnlyUsedByTests
public class SpyingLogbackFilter
extends Filter<ILoggingEvent> {
    private final List<ExpectedMessage> expectedMessages = Lists.newCopyOnWriteArrayList();
    private final AtomicInteger unexpectedMessageCount = new AtomicInteger();

    @Override
    public String getName() {
        return "SPYING";
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (!this.isExpected(event)) {
            if (event.getLevel().isGreaterOrEqual(Level.WARN)) {
                this.unexpectedMessageCount.getAndIncrement();
            }
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExpected(ILoggingEvent event) {
        List<ExpectedMessage> list = this.expectedMessages;
        synchronized (list) {
            if (this.expectedMessages.isEmpty()) {
                return false;
            }
            ExpectedMessage expectedMessage = this.expectedMessages.get(0);
            if (event.getMessage() == null) {
                return false;
            }
            if (expectedMessage.loggerName().equals(event.getLoggerName()) && event.getFormattedMessage().contains(expectedMessage.partialMessage())) {
                this.expectedMessages.remove(0);
                return true;
            }
            return false;
        }
    }

    public static void init() {
        Appender<ILoggingEvent> consoleAppender = SpyingLogbackFilter.getConsoleAppender();
        SpyingLogbackFilter spyingLogbackFilter = SpyingLogbackFilter.getSpyingLogbackFilter(consoleAppender);
        if (spyingLogbackFilter == null) {
            consoleAppender.addFilter(new SpyingLogbackFilter());
        }
    }

    public static boolean active() {
        return SpyingLogbackFilter.getSpyingLogbackFilter() != null;
    }

    public static void addExpectedMessage(String loggerName, String partialMessage) {
        SpyingLogbackFilter spyingLogbackFilter = SpyingLogbackFilter.getSpyingLogbackFilter();
        Preconditions.checkNotNull(spyingLogbackFilter, "SpyingLogbackFilter.init() was never called");
        spyingLogbackFilter.expectedMessages.add(ExpectedMessage.of(loggerName, partialMessage));
    }

    public static MessageCount clearMessages() {
        SpyingLogbackFilter spyingLogbackFilter = SpyingLogbackFilter.getSpyingLogbackFilter();
        Preconditions.checkNotNull(spyingLogbackFilter, "SpyingLogbackFilter.init() was never called");
        MessageCount counts = MessageCount.of(spyingLogbackFilter.expectedMessages.size(), spyingLogbackFilter.unexpectedMessageCount.get());
        spyingLogbackFilter.expectedMessages.clear();
        spyingLogbackFilter.unexpectedMessageCount.set(0);
        return counts;
    }

    @Nullable
    private static SpyingLogbackFilter getSpyingLogbackFilter() {
        Appender<ILoggingEvent> consoleAppender = SpyingLogbackFilter.getConsoleAppender();
        return SpyingLogbackFilter.getSpyingLogbackFilter(consoleAppender);
    }

    private static Appender<ILoggingEvent> getConsoleAppender() {
        Logger root = (Logger)LoggerFactory.getLogger("ROOT");
        Iterator<Appender<ILoggingEvent>> i = root.iteratorForAppenders();
        while (i.hasNext()) {
            Appender<ILoggingEvent> appender = i.next();
            if (!(appender instanceof ConsoleAppender)) continue;
            return appender;
        }
        throw new IllegalStateException("No console appender found");
    }

    @Nullable
    private static SpyingLogbackFilter getSpyingLogbackFilter(Appender<ILoggingEvent> appender) {
        for (Filter filter : appender.getCopyOfAttachedFiltersList()) {
            if (!(filter instanceof SpyingLogbackFilter)) continue;
            return (SpyingLogbackFilter)filter;
        }
        return null;
    }

    @Value.Immutable
    static abstract class ExpectedMessageBase {
        ExpectedMessageBase() {
        }

        abstract String loggerName();

        abstract String partialMessage();
    }

    @Value.Immutable
    public static abstract class MessageCountBase
    implements Serializable {
        abstract int expectedCount();

        abstract int unexpectedCount();
    }
}

