/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import org.glowroot.config.Versions;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.immutables.value.Value;

@JsonSerialize
@Value.Immutable
public abstract class AlertConfigBase {
    public static final Ordering<AlertConfigBase> orderingByName = new Ordering<AlertConfigBase>(){

        @Override
        public int compare(@Nullable AlertConfigBase left, @Nullable AlertConfigBase right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return left.transactionType().compareToIgnoreCase(right.transactionType());
        }
    };

    public abstract String transactionType();

    public abstract double percentile();

    public abstract int timePeriodMinutes();

    public abstract int thresholdMillis();

    public abstract int minTransactionCount();

    public abstract ImmutableList<String> emailAddresses();

    @JsonIgnore
    public String version() {
        return Versions.getVersion(this);
    }
}

