/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.GeneralConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class GeneralConfig
extends GeneralConfigBase {
    private final boolean enabled;
    private final int traceStoreThresholdMillis;
    private final int profilingIntervalMillis;
    private final String defaultDisplayedTransactionType;
    private final ImmutableList<Double> defaultDisplayedPercentiles;
    private final String version;

    private GeneralConfig(Builder builder) {
        this.enabled = builder.enabledIsSet() ? builder.enabled : super.enabled();
        this.traceStoreThresholdMillis = builder.traceStoreThresholdMillisIsSet() ? builder.traceStoreThresholdMillis : super.traceStoreThresholdMillis();
        this.profilingIntervalMillis = builder.profilingIntervalMillisIsSet() ? builder.profilingIntervalMillis : super.profilingIntervalMillis();
        this.defaultDisplayedTransactionType = builder.defaultDisplayedTransactionType != null ? builder.defaultDisplayedTransactionType : Preconditions.checkNotNull(super.defaultDisplayedTransactionType());
        this.defaultDisplayedPercentiles = builder.defaultDisplayedPercentiles != null ? builder.defaultDisplayedPercentiles : Preconditions.checkNotNull(super.defaultDisplayedPercentiles());
        this.version = Preconditions.checkNotNull(super.version());
    }

    private GeneralConfig(boolean enabled, int traceStoreThresholdMillis, int profilingIntervalMillis, String defaultDisplayedTransactionType, ImmutableList<Double> defaultDisplayedPercentiles) {
        this.enabled = enabled;
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
        this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="traceStoreThresholdMillis")
    public int traceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="defaultDisplayedTransactionType")
    public String defaultDisplayedTransactionType() {
        return this.defaultDisplayedTransactionType;
    }

    @Override
    @JsonProperty(value="defaultDisplayedPercentiles")
    public ImmutableList<Double> defaultDisplayedPercentiles() {
        return this.defaultDisplayedPercentiles;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final GeneralConfig withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new GeneralConfig(newValue, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles);
    }

    public final GeneralConfig withTraceStoreThresholdMillis(int value) {
        if (this.traceStoreThresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfig(this.enabled, newValue, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles);
    }

    public final GeneralConfig withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfig(this.enabled, this.traceStoreThresholdMillis, newValue, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles);
    }

    public final GeneralConfig withDefaultDisplayedTransactionType(String value) {
        if (this.defaultDisplayedTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GeneralConfig(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, newValue, this.defaultDisplayedPercentiles);
    }

    public final GeneralConfig withDefaultDisplayedPercentiles(ImmutableList<Double> value) {
        if (this.defaultDisplayedPercentiles == value) {
            return this;
        }
        ImmutableList<Double> newValue = Preconditions.checkNotNull(value);
        return new GeneralConfig(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GeneralConfig && this.equalTo((GeneralConfig)another);
    }

    private boolean equalTo(GeneralConfig another) {
        return this.enabled == another.enabled && this.traceStoreThresholdMillis == another.traceStoreThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType) && this.defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.traceStoreThresholdMillis;
        h = h * 17 + this.profilingIntervalMillis;
        h = h * 17 + this.defaultDisplayedTransactionType.hashCode();
        h = h * 17 + this.defaultDisplayedPercentiles.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeneralConfig").add("enabled", this.enabled).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultDisplayedTransactionType", this.defaultDisplayedTransactionType).add("defaultDisplayedPercentiles", this.defaultDisplayedPercentiles).add("version", this.version).toString();
    }

    @JsonCreator
    public static GeneralConfig fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType, @JsonProperty(value="defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles) {
        Builder builder = GeneralConfig.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (traceStoreThresholdMillis != null) {
            builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
        }
        if (profilingIntervalMillis != null) {
            builder.profilingIntervalMillis(profilingIntervalMillis);
        }
        if (defaultDisplayedTransactionType != null) {
            builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
        }
        if (defaultDisplayedPercentiles != null) {
            builder.defaultDisplayedPercentiles(defaultDisplayedPercentiles);
        }
        return builder.build();
    }

    public static GeneralConfig copyOf(GeneralConfigBase instance) {
        if (instance instanceof GeneralConfig) {
            return (GeneralConfig)instance;
        }
        return GeneralConfig.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_ENABLED = 1L;
        private static final long NONDEFAULT_BIT_TRACE_STORE_THRESHOLD_MILLIS = 2L;
        private static final long NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS = 4L;
        private long nondefaultBitset;
        private boolean enabled;
        private int traceStoreThresholdMillis;
        private int profilingIntervalMillis;
        @Nullable
        private String defaultDisplayedTransactionType;
        @Nullable
        private ImmutableList<Double> defaultDisplayedPercentiles;

        private Builder() {
        }

        public final Builder all(GeneralConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.enabled(instance.enabled());
            this.traceStoreThresholdMillis(instance.traceStoreThresholdMillis());
            this.profilingIntervalMillis(instance.profilingIntervalMillis());
            this.defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType());
            this.defaultDisplayedPercentiles(instance.defaultDisplayedPercentiles());
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder traceStoreThresholdMillis(int traceStoreThresholdMillis) {
            this.traceStoreThresholdMillis = traceStoreThresholdMillis;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
            this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
            return this;
        }

        public final Builder defaultDisplayedPercentiles(ImmutableList<Double> defaultDisplayedPercentiles) {
            this.defaultDisplayedPercentiles = Preconditions.checkNotNull(defaultDisplayedPercentiles);
            return this;
        }

        public GeneralConfig build() {
            return new GeneralConfig(this);
        }

        private boolean enabledIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean traceStoreThresholdMillisIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }
    }
}

