/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.api.weaving.MethodModifier;
import org.glowroot.config.CaptureKind;
import org.glowroot.config.InstrumentationConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
public final class InstrumentationConfig
extends InstrumentationConfigBase {
    private final String className;
    private final String methodName;
    private final ImmutableList<String> methodParameterTypes;
    private final String methodReturnType;
    private final ImmutableList<MethodModifier> methodModifiers;
    private final CaptureKind captureKind;
    private final String timerName;
    private final String traceEntryTemplate;
    @Nullable
    private final Long traceEntryStackThresholdMillis;
    private final boolean traceEntryCaptureSelfNested;
    private final String transactionType;
    private final String transactionNameTemplate;
    private final String transactionUserTemplate;
    private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
    @Nullable
    private final Long traceStoreThresholdMillis;
    private final String enabledProperty;
    private final String traceEntryEnabledProperty;
    private final String version;
    private final boolean isTimerOrGreater;
    private final boolean isTraceEntryOrGreater;
    private final boolean isTransaction;
    private final ImmutableList<String> validationErrors;

    private InstrumentationConfig(Builder builder) {
        this.className = builder.className;
        this.methodName = builder.methodName;
        this.methodParameterTypes = builder.methodParameterTypesBuilder.build();
        this.methodModifiers = builder.methodModifiersBuilder.build();
        this.captureKind = builder.captureKind;
        this.traceEntryStackThresholdMillis = builder.traceEntryStackThresholdMillis;
        this.transactionCustomAttributeTemplates = builder.transactionCustomAttributeTemplatesBuilder.build();
        this.traceStoreThresholdMillis = builder.traceStoreThresholdMillis;
        this.methodReturnType = builder.methodReturnType != null ? builder.methodReturnType : Preconditions.checkNotNull(super.methodReturnType());
        this.timerName = builder.timerName != null ? builder.timerName : Preconditions.checkNotNull(super.timerName());
        this.traceEntryTemplate = builder.traceEntryTemplate != null ? builder.traceEntryTemplate : Preconditions.checkNotNull(super.traceEntryTemplate());
        this.traceEntryCaptureSelfNested = builder.traceEntryCaptureSelfNestedIsSet() ? builder.traceEntryCaptureSelfNested : super.traceEntryCaptureSelfNested();
        this.transactionType = builder.transactionType != null ? builder.transactionType : Preconditions.checkNotNull(super.transactionType());
        this.transactionNameTemplate = builder.transactionNameTemplate != null ? builder.transactionNameTemplate : Preconditions.checkNotNull(super.transactionNameTemplate());
        this.transactionUserTemplate = builder.transactionUserTemplate != null ? builder.transactionUserTemplate : Preconditions.checkNotNull(super.transactionUserTemplate());
        this.enabledProperty = builder.enabledProperty != null ? builder.enabledProperty : Preconditions.checkNotNull(super.enabledProperty());
        this.traceEntryEnabledProperty = builder.traceEntryEnabledProperty != null ? builder.traceEntryEnabledProperty : Preconditions.checkNotNull(super.traceEntryEnabledProperty());
        this.version = Preconditions.checkNotNull(super.version());
        this.isTimerOrGreater = super.isTimerOrGreater();
        this.isTraceEntryOrGreater = super.isTraceEntryOrGreater();
        this.isTransaction = super.isTransaction();
        this.validationErrors = Preconditions.checkNotNull(super.validationErrors());
    }

    private InstrumentationConfig(String className, String methodName, ImmutableList<String> methodParameterTypes, String methodReturnType, ImmutableList<MethodModifier> methodModifiers, CaptureKind captureKind, String timerName, String traceEntryTemplate, @Nullable Long traceEntryStackThresholdMillis, boolean traceEntryCaptureSelfNested, String transactionType, String transactionNameTemplate, String transactionUserTemplate, ImmutableMap<String, String> transactionCustomAttributeTemplates, @Nullable Long traceStoreThresholdMillis, String enabledProperty, String traceEntryEnabledProperty) {
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
        this.methodReturnType = methodReturnType;
        this.methodModifiers = methodModifiers;
        this.captureKind = captureKind;
        this.timerName = timerName;
        this.traceEntryTemplate = traceEntryTemplate;
        this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
        this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
        this.transactionType = transactionType;
        this.transactionNameTemplate = transactionNameTemplate;
        this.transactionUserTemplate = transactionUserTemplate;
        this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
        this.enabledProperty = enabledProperty;
        this.traceEntryEnabledProperty = traceEntryEnabledProperty;
        this.version = Preconditions.checkNotNull(super.version());
        this.isTimerOrGreater = super.isTimerOrGreater();
        this.isTraceEntryOrGreater = super.isTraceEntryOrGreater();
        this.isTransaction = super.isTransaction();
        this.validationErrors = Preconditions.checkNotNull(super.validationErrors());
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    @Override
    @JsonProperty(value="methodParameterTypes")
    public ImmutableList<String> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Override
    @JsonProperty(value="methodReturnType")
    public String methodReturnType() {
        return this.methodReturnType;
    }

    @Override
    @JsonProperty(value="methodModifiers")
    public ImmutableList<MethodModifier> methodModifiers() {
        return this.methodModifiers;
    }

    @Override
    @JsonProperty(value="captureKind")
    public CaptureKind captureKind() {
        return this.captureKind;
    }

    @Override
    @JsonProperty(value="timerName")
    public String timerName() {
        return this.timerName;
    }

    @Override
    @JsonProperty(value="traceEntryTemplate")
    public String traceEntryTemplate() {
        return this.traceEntryTemplate;
    }

    @Override
    @JsonProperty(value="traceEntryStackThresholdMillis")
    public Long traceEntryStackThresholdMillis() {
        return this.traceEntryStackThresholdMillis;
    }

    @Override
    @JsonProperty(value="traceEntryCaptureSelfNested")
    public boolean traceEntryCaptureSelfNested() {
        return this.traceEntryCaptureSelfNested;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionNameTemplate")
    public String transactionNameTemplate() {
        return this.transactionNameTemplate;
    }

    @Override
    @JsonProperty(value="transactionUserTemplate")
    public String transactionUserTemplate() {
        return this.transactionUserTemplate;
    }

    @JsonProperty(value="transactionCustomAttributeTemplates")
    public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
        return this.transactionCustomAttributeTemplates;
    }

    @Override
    @JsonProperty(value="traceStoreThresholdMillis")
    public Long traceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    @Override
    @JsonProperty(value="enabledProperty")
    public String enabledProperty() {
        return this.enabledProperty;
    }

    @Override
    @JsonProperty(value="traceEntryEnabledProperty")
    public String traceEntryEnabledProperty() {
        return this.traceEntryEnabledProperty;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="isTimerOrGreater")
    public boolean isTimerOrGreater() {
        return this.isTimerOrGreater;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="isTraceEntryOrGreater")
    public boolean isTraceEntryOrGreater() {
        return this.isTraceEntryOrGreater;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="isTransaction")
    public boolean isTransaction() {
        return this.isTransaction;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="validationErrors")
    public ImmutableList<String> validationErrors() {
        return this.validationErrors;
    }

    public final InstrumentationConfig withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(newValue, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodName(String value) {
        if (this.methodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, newValue, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfig(this.className, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodParameterTypes(Iterable<String> elements) {
        if (this.methodParameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfig(this.className, this.methodName, newValue, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodReturnType(String value) {
        if (this.methodReturnType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, newValue, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodModifiers(MethodModifier ... elements) {
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withMethodModifiers(Iterable<? extends MethodModifier> elements) {
        if (this.methodModifiers == elements) {
            return this;
        }
        ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, newValue, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withCaptureKind(CaptureKind value) {
        if (this.captureKind == value) {
            return this;
        }
        CaptureKind newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, newValue, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTimerName(String value) {
        if (this.timerName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, newValue, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTraceEntryTemplate(String value) {
        if (this.traceEntryTemplate == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, newValue, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTraceEntryStackThresholdMillis(@Nullable Long value) {
        if (this.traceEntryStackThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, newValue, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTraceEntryCaptureSelfNested(boolean value) {
        if (this.traceEntryCaptureSelfNested == value) {
            return this;
        }
        boolean newValue = value;
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTransactionNameTemplate(String value) {
        if (this.transactionNameTemplate == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, newValue, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTransactionUserTemplate(String value) {
        if (this.transactionUserTemplate == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, newValue, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
        if (this.transactionCustomAttributeTemplates == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, newValue, this.traceStoreThresholdMillis, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTraceStoreThresholdMillis(@Nullable Long value) {
        if (this.traceStoreThresholdMillis == value) {
            return this;
        }
        Long newValue = value;
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, newValue, this.enabledProperty, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withEnabledProperty(String value) {
        if (this.enabledProperty == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, newValue, this.traceEntryEnabledProperty);
    }

    public final InstrumentationConfig withTraceEntryEnabledProperty(String value) {
        if (this.traceEntryEnabledProperty == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new InstrumentationConfig(this.className, this.methodName, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.captureKind, this.timerName, this.traceEntryTemplate, this.traceEntryStackThresholdMillis, this.traceEntryCaptureSelfNested, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionCustomAttributeTemplates, this.traceStoreThresholdMillis, this.enabledProperty, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof InstrumentationConfig && this.equalTo((InstrumentationConfig)another);
    }

    private boolean equalTo(InstrumentationConfig another) {
        return this.className.equals(another.className) && this.methodName.equals(another.methodName) && this.methodParameterTypes.equals(another.methodParameterTypes) && this.methodReturnType.equals(another.methodReturnType) && this.methodModifiers.equals(another.methodModifiers) && this.captureKind.equals((Object)another.captureKind) && this.timerName.equals(another.timerName) && this.traceEntryTemplate.equals(another.traceEntryTemplate) && Objects.equal(this.traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis) && this.traceEntryCaptureSelfNested == another.traceEntryCaptureSelfNested && this.transactionType.equals(another.transactionType) && this.transactionNameTemplate.equals(another.transactionNameTemplate) && this.transactionUserTemplate.equals(another.transactionUserTemplate) && this.transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates) && Objects.equal(this.traceStoreThresholdMillis, another.traceStoreThresholdMillis) && this.enabledProperty.equals(another.enabledProperty) && this.traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty) && this.version.equals(another.version) && this.isTimerOrGreater == another.isTimerOrGreater && this.isTraceEntryOrGreater == another.isTraceEntryOrGreater && this.isTransaction == another.isTransaction && this.validationErrors.equals(another.validationErrors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + this.methodName.hashCode();
        h = h * 17 + this.methodParameterTypes.hashCode();
        h = h * 17 + this.methodReturnType.hashCode();
        h = h * 17 + this.methodModifiers.hashCode();
        h = h * 17 + this.captureKind.hashCode();
        h = h * 17 + this.timerName.hashCode();
        h = h * 17 + this.traceEntryTemplate.hashCode();
        h = h * 17 + Objects.hashCode(this.traceEntryStackThresholdMillis);
        h = h * 17 + Booleans.hashCode(this.traceEntryCaptureSelfNested);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + this.transactionNameTemplate.hashCode();
        h = h * 17 + this.transactionUserTemplate.hashCode();
        h = h * 17 + this.transactionCustomAttributeTemplates.hashCode();
        h = h * 17 + Objects.hashCode(this.traceStoreThresholdMillis);
        h = h * 17 + this.enabledProperty.hashCode();
        h = h * 17 + this.traceEntryEnabledProperty.hashCode();
        h = h * 17 + this.version.hashCode();
        h = h * 17 + Booleans.hashCode(this.isTimerOrGreater);
        h = h * 17 + Booleans.hashCode(this.isTraceEntryOrGreater);
        h = h * 17 + Booleans.hashCode(this.isTransaction);
        h = h * 17 + this.validationErrors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationConfig").add("className", this.className).add("methodName", this.methodName).add("methodParameterTypes", this.methodParameterTypes).add("methodReturnType", this.methodReturnType).add("methodModifiers", this.methodModifiers).add("captureKind", (Object)this.captureKind).add("timerName", this.timerName).add("traceEntryTemplate", this.traceEntryTemplate).add("traceEntryStackThresholdMillis", this.traceEntryStackThresholdMillis).add("traceEntryCaptureSelfNested", this.traceEntryCaptureSelfNested).add("transactionType", this.transactionType).add("transactionNameTemplate", this.transactionNameTemplate).add("transactionUserTemplate", this.transactionUserTemplate).add("transactionCustomAttributeTemplates", this.transactionCustomAttributeTemplates).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("enabledProperty", this.enabledProperty).add("traceEntryEnabledProperty", this.traceEntryEnabledProperty).add("version", this.version).add("isTimerOrGreater", this.isTimerOrGreater).add("isTraceEntryOrGreater", this.isTraceEntryOrGreater).add("isTransaction", this.isTransaction).add("validationErrors", this.validationErrors).toString();
    }

    @JsonCreator
    public static InstrumentationConfig fromAllAttributes(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="methodName") @Nullable String methodName, @JsonProperty(value="methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes, @JsonProperty(value="methodReturnType") @Nullable String methodReturnType, @JsonProperty(value="methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers, @JsonProperty(value="captureKind") @Nullable CaptureKind captureKind, @JsonProperty(value="timerName") @Nullable String timerName, @JsonProperty(value="traceEntryTemplate") @Nullable String traceEntryTemplate, @JsonProperty(value="traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis, @JsonProperty(value="traceEntryCaptureSelfNested") @Nullable Boolean traceEntryCaptureSelfNested, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionNameTemplate") @Nullable String transactionNameTemplate, @JsonProperty(value="transactionUserTemplate") @Nullable String transactionUserTemplate, @JsonProperty(value="transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Long traceStoreThresholdMillis, @JsonProperty(value="enabledProperty") @Nullable String enabledProperty, @JsonProperty(value="traceEntryEnabledProperty") @Nullable String traceEntryEnabledProperty) {
        Builder builder = InstrumentationConfig.builder();
        if (className != null) {
            builder.className(className);
        }
        if (methodName != null) {
            builder.methodName(methodName);
        }
        if (methodParameterTypes != null) {
            builder.addAllMethodParameterTypes(methodParameterTypes);
        }
        if (methodReturnType != null) {
            builder.methodReturnType(methodReturnType);
        }
        if (methodModifiers != null) {
            builder.addAllMethodModifiers(methodModifiers);
        }
        if (captureKind != null) {
            builder.captureKind(captureKind);
        }
        if (timerName != null) {
            builder.timerName(timerName);
        }
        if (traceEntryTemplate != null) {
            builder.traceEntryTemplate(traceEntryTemplate);
        }
        if (traceEntryStackThresholdMillis != null) {
            builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
        }
        if (traceEntryCaptureSelfNested != null) {
            builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionNameTemplate != null) {
            builder.transactionNameTemplate(transactionNameTemplate);
        }
        if (transactionUserTemplate != null) {
            builder.transactionUserTemplate(transactionUserTemplate);
        }
        if (transactionCustomAttributeTemplates != null) {
            builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
        }
        if (traceStoreThresholdMillis != null) {
            builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
        }
        if (enabledProperty != null) {
            builder.enabledProperty(enabledProperty);
        }
        if (traceEntryEnabledProperty != null) {
            builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
        }
        return builder.build();
    }

    public static InstrumentationConfig copyOf(InstrumentationConfigBase instance) {
        if (instance instanceof InstrumentationConfig) {
            return (InstrumentationConfig)instance;
        }
        return InstrumentationConfig.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_METHOD_NAME = 2L;
        private static final long INITIALIZED_BIT_CAPTURE_KIND = 4L;
        private static final long NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String className;
        @Nullable
        private String methodName;
        private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
        @Nullable
        private String methodReturnType;
        private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
        @Nullable
        private CaptureKind captureKind;
        @Nullable
        private String timerName;
        @Nullable
        private String traceEntryTemplate;
        @Nullable
        private Long traceEntryStackThresholdMillis;
        private boolean traceEntryCaptureSelfNested;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionNameTemplate;
        @Nullable
        private String transactionUserTemplate;
        private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
        @Nullable
        private Long traceStoreThresholdMillis;
        @Nullable
        private String enabledProperty;
        @Nullable
        private String traceEntryEnabledProperty;

        private Builder() {
        }

        public final Builder all(InstrumentationConfigBase instance) {
            Preconditions.checkNotNull(instance);
            this.className(instance.className());
            this.methodName(instance.methodName());
            this.addAllMethodParameterTypes(instance.methodParameterTypes());
            this.methodReturnType(instance.methodReturnType());
            this.addAllMethodModifiers(instance.methodModifiers());
            this.captureKind(instance.captureKind());
            this.timerName(instance.timerName());
            this.traceEntryTemplate(instance.traceEntryTemplate());
            Long traceEntryStackThresholdMillisValue = instance.traceEntryStackThresholdMillis();
            if (traceEntryStackThresholdMillisValue != null) {
                this.traceEntryStackThresholdMillis(traceEntryStackThresholdMillisValue);
            }
            this.traceEntryCaptureSelfNested(instance.traceEntryCaptureSelfNested());
            this.transactionType(instance.transactionType());
            this.transactionNameTemplate(instance.transactionNameTemplate());
            this.transactionUserTemplate(instance.transactionUserTemplate());
            this.putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates());
            Long traceStoreThresholdMillisValue = instance.traceStoreThresholdMillis();
            if (traceStoreThresholdMillisValue != null) {
                this.traceStoreThresholdMillis(traceStoreThresholdMillisValue);
            }
            this.enabledProperty(instance.enabledProperty());
            this.traceEntryEnabledProperty(instance.traceEntryEnabledProperty());
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Preconditions.checkNotNull(methodName);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addMethodParameterTypes(String element) {
            this.methodParameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodParameterTypes(String ... elements) {
            this.methodParameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder methodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypesBuilder = ImmutableList.builder();
            return this.addAllMethodParameterTypes(elements);
        }

        public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder methodReturnType(String methodReturnType) {
            this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier element) {
            this.methodModifiersBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodModifiers(MethodModifier ... elements) {
            this.methodModifiersBuilder.add((Object[])elements);
            return this;
        }

        public final Builder methodModifiers(Iterable<? extends MethodModifier> elements) {
            this.methodModifiersBuilder = ImmutableList.builder();
            return this.addAllMethodModifiers(elements);
        }

        public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
            this.methodModifiersBuilder.addAll(elements);
            return this;
        }

        public final Builder captureKind(CaptureKind captureKind) {
            this.captureKind = Preconditions.checkNotNull(captureKind);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder timerName(String timerName) {
            this.timerName = Preconditions.checkNotNull(timerName);
            return this;
        }

        public final Builder traceEntryTemplate(String traceEntryTemplate) {
            this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
            return this;
        }

        public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
            this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
            return this;
        }

        public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
            this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            return this;
        }

        public final Builder transactionNameTemplate(String transactionNameTemplate) {
            this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
            return this;
        }

        public final Builder transactionUserTemplate(String transactionUserTemplate) {
            this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
            this.transactionCustomAttributeTemplatesBuilder.put(key, value);
            return this;
        }

        public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
            this.transactionCustomAttributeTemplatesBuilder.put(entry);
            return this;
        }

        public final Builder transactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
            return this.putAllTransactionCustomAttributeTemplates(entries);
        }

        public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionCustomAttributeTemplatesBuilder.putAll(entries);
            return this;
        }

        public final Builder traceStoreThresholdMillis(@Nullable Long traceStoreThresholdMillis) {
            this.traceStoreThresholdMillis = traceStoreThresholdMillis;
            return this;
        }

        public final Builder enabledProperty(String enabledProperty) {
            this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
            return this;
        }

        public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
            this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
            return this;
        }

        public InstrumentationConfig build() {
            this.checkRequiredAttributes();
            return new InstrumentationConfig(this);
        }

        private boolean traceEntryCaptureSelfNestedIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean methodNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean captureKindIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            if (!this.methodNameIsSet()) {
                attributes.add("methodName");
            }
            if (!this.captureKindIsSet()) {
                attributes.add("captureKind");
            }
            return "Cannot build InstrumentationConfig, some of required attributes are not set " + attributes;
        }
    }
}

