/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PluginCacheBase;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@Immutable
final class PluginCache
extends PluginCacheBase {
    private final ImmutableList<File> pluginJars;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;

    private PluginCache(ImmutableList<File> pluginJars, ImmutableList<PluginDescriptor> pluginDescriptors) {
        this.pluginJars = pluginJars;
        this.pluginDescriptors = pluginDescriptors;
    }

    @Override
    public ImmutableList<File> pluginJars() {
        return this.pluginJars;
    }

    @Override
    public ImmutableList<PluginDescriptor> pluginDescriptors() {
        return this.pluginDescriptors;
    }

    public final PluginCache withPluginJars(File ... elements) {
        ImmutableList<File> newValue = ImmutableList.copyOf(elements);
        return new PluginCache(newValue, this.pluginDescriptors);
    }

    public final PluginCache withPluginJars(Iterable<? extends File> elements) {
        if (this.pluginJars == elements) {
            return this;
        }
        ImmutableList<File> newValue = ImmutableList.copyOf(elements);
        return new PluginCache(newValue, this.pluginDescriptors);
    }

    public final PluginCache withPluginDescriptors(PluginDescriptor ... elements) {
        ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginCache(this.pluginJars, newValue);
    }

    public final PluginCache withPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
        if (this.pluginDescriptors == elements) {
            return this;
        }
        ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginCache(this.pluginJars, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginCache && this.equalTo((PluginCache)another);
    }

    private boolean equalTo(PluginCache another) {
        return this.pluginJars.equals(another.pluginJars) && this.pluginDescriptors.equals(another.pluginDescriptors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pluginJars.hashCode();
        h = h * 17 + this.pluginDescriptors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginCache").add("pluginJars", this.pluginJars).add("pluginDescriptors", this.pluginDescriptors).toString();
    }

    static PluginCache copyOf(PluginCacheBase instance) {
        if (instance instanceof PluginCache) {
            return (PluginCache)instance;
        }
        return PluginCache.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private ImmutableList.Builder<File> pluginJarsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<PluginDescriptor> pluginDescriptorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(PluginCacheBase instance) {
            Preconditions.checkNotNull(instance);
            this.addAllPluginJars(instance.pluginJars());
            this.addAllPluginDescriptors(instance.pluginDescriptors());
            return this;
        }

        public final Builder addPluginJars(File element) {
            this.pluginJarsBuilder.add((Object)element);
            return this;
        }

        public final Builder addPluginJars(File ... elements) {
            this.pluginJarsBuilder.add(elements);
            return this;
        }

        public final Builder pluginJars(Iterable<? extends File> elements) {
            this.pluginJarsBuilder = ImmutableList.builder();
            return this.addAllPluginJars(elements);
        }

        public final Builder addAllPluginJars(Iterable<? extends File> elements) {
            this.pluginJarsBuilder.addAll(elements);
            return this;
        }

        public final Builder addPluginDescriptors(PluginDescriptor element) {
            this.pluginDescriptorsBuilder.add((Object)element);
            return this;
        }

        public final Builder addPluginDescriptors(PluginDescriptor ... elements) {
            this.pluginDescriptorsBuilder.add(elements);
            return this;
        }

        public final Builder pluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
            this.pluginDescriptorsBuilder = ImmutableList.builder();
            return this.addAllPluginDescriptors(elements);
        }

        public final Builder addAllPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
            this.pluginDescriptorsBuilder.addAll(elements);
            return this;
        }

        public PluginCache build() {
            return new PluginCache((ImmutableList)this.pluginJarsBuilder.build(), (ImmutableList)this.pluginDescriptorsBuilder.build());
        }
    }
}

