/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.config.PropertyType;
import org.glowroot.config.PropertyValue;
import org.glowroot.config.Versions;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonSerialize
@Value.Immutable
public abstract class PluginConfigBase {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfig.class);

    public abstract String id();

    public boolean enabled() {
        return true;
    }

    public abstract Map<String, PropertyValue> properties();

    @JsonIgnore
    ImmutableMap<String, Boolean> booleanProperties() {
        HashMap<String, Boolean> booleanProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (!(value instanceof Boolean)) continue;
            booleanProperties.put(entry.getKey(), (Boolean)value);
        }
        return ImmutableMap.copyOf(booleanProperties);
    }

    @JsonIgnore
    ImmutableMap<String, String> stringProperties() {
        HashMap<String, String> stringProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (!(value instanceof String)) continue;
            stringProperties.put(entry.getKey(), (String)value);
        }
        return ImmutableMap.copyOf(stringProperties);
    }

    @JsonIgnore
    ImmutableMap<String, Optional<Double>> doubleProperties() {
        HashMap doubleProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (value == null) {
                doubleProperties.put(entry.getKey(), Optional.absent());
                continue;
            }
            if (!(value instanceof Double)) continue;
            doubleProperties.put(entry.getKey(), Optional.of((Double)value));
        }
        return ImmutableMap.copyOf(doubleProperties);
    }

    @JsonIgnore
    public String version() {
        return Versions.getVersion(this);
    }

    public String getStringProperty(String name) {
        String value = this.stringProperties().get(name);
        return value == null ? "" : value;
    }

    public boolean getBooleanProperty(String name) {
        Boolean value = this.booleanProperties().get(name);
        return value == null ? false : value;
    }

    @Nullable
    public Double getDoubleProperty(String name) {
        Optional<Double> value = this.doubleProperties().get(name);
        return value == null ? null : value.orNull();
    }

    @Nullable
    PropertyValue getValidatedPropertyValue(String propertyName, PropertyType type) {
        PropertyValue propertyValue = this.properties().get(propertyName);
        if (propertyValue == null) {
            return null;
        }
        Object value = propertyValue.value();
        if (value == null) {
            return PropertyValue.getDefaultValue(type);
        }
        if (PropertyDescriptor.isValidType(value, type)) {
            return propertyValue;
        }
        logger.warn("invalid value for plugin property: {}", (Object)propertyName);
        return PropertyValue.getDefaultValue(type);
    }
}

