/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.PluginDescriptorBase;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
public final class PluginDescriptor
extends PluginDescriptorBase {
    private final String name;
    private final String id;
    private final ImmutableList<String> transactionTypes;
    private final ImmutableList<String> transactionCustomAttributes;
    private final ImmutableList<PropertyDescriptor> properties;
    private final ImmutableList<InstrumentationConfig> instrumentationConfigs;
    private final ImmutableList<String> aspects;

    private PluginDescriptor(String name, String id, ImmutableList<String> transactionTypes, ImmutableList<String> transactionCustomAttributes, ImmutableList<PropertyDescriptor> properties, ImmutableList<InstrumentationConfig> instrumentationConfigs, ImmutableList<String> aspects) {
        this.name = name;
        this.id = id;
        this.transactionTypes = transactionTypes;
        this.transactionCustomAttributes = transactionCustomAttributes;
        this.properties = properties;
        this.instrumentationConfigs = instrumentationConfigs;
        this.aspects = aspects;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="transactionTypes")
    public ImmutableList<String> transactionTypes() {
        return this.transactionTypes;
    }

    @Override
    @JsonProperty(value="transactionCustomAttributes")
    public ImmutableList<String> transactionCustomAttributes() {
        return this.transactionCustomAttributes;
    }

    @Override
    @JsonProperty(value="properties")
    public ImmutableList<PropertyDescriptor> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="instrumentation")
    public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
        return this.instrumentationConfigs;
    }

    @Override
    @JsonProperty(value="aspects")
    public ImmutableList<String> aspects() {
        return this.aspects;
    }

    public final PluginDescriptor withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginDescriptor(newValue, this.id, this.transactionTypes, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginDescriptor(this.name, newValue, this.transactionTypes, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withTransactionTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, newValue, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withTransactionTypes(Iterable<String> elements) {
        if (this.transactionTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, newValue, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withTransactionCustomAttributes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, newValue, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withTransactionCustomAttributes(Iterable<String> elements) {
        if (this.transactionCustomAttributes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, newValue, this.properties, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withProperties(PropertyDescriptor ... elements) {
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, newValue, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withProperties(Iterable<? extends PropertyDescriptor> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, newValue, this.instrumentationConfigs, this.aspects);
    }

    public final PluginDescriptor withInstrumentationConfigs(InstrumentationConfig ... elements) {
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, this.properties, newValue, this.aspects);
    }

    public final PluginDescriptor withInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
        if (this.instrumentationConfigs == elements) {
            return this;
        }
        ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, this.properties, newValue, this.aspects);
    }

    public final PluginDescriptor withAspects(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, newValue);
    }

    public final PluginDescriptor withAspects(Iterable<String> elements) {
        if (this.aspects == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new PluginDescriptor(this.name, this.id, this.transactionTypes, this.transactionCustomAttributes, this.properties, this.instrumentationConfigs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginDescriptor && this.equalTo((PluginDescriptor)another);
    }

    private boolean equalTo(PluginDescriptor another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && this.transactionTypes.equals(another.transactionTypes) && this.transactionCustomAttributes.equals(another.transactionCustomAttributes) && this.properties.equals(another.properties) && this.instrumentationConfigs.equals(another.instrumentationConfigs) && this.aspects.equals(another.aspects);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.transactionTypes.hashCode();
        h = h * 17 + this.transactionCustomAttributes.hashCode();
        h = h * 17 + this.properties.hashCode();
        h = h * 17 + this.instrumentationConfigs.hashCode();
        h = h * 17 + this.aspects.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginDescriptor").add("name", this.name).add("id", this.id).add("transactionTypes", this.transactionTypes).add("transactionCustomAttributes", this.transactionCustomAttributes).add("properties", this.properties).add("instrumentationConfigs", this.instrumentationConfigs).add("aspects", this.aspects).toString();
    }

    @JsonCreator
    public static PluginDescriptor fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="id") @Nullable String id, @JsonProperty(value="transactionTypes") @Nullable ImmutableList<String> transactionTypes, @JsonProperty(value="transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes, @JsonProperty(value="properties") @Nullable ImmutableList<PropertyDescriptor> properties, @JsonProperty(value="instrumentation") @Nullable ImmutableList<InstrumentationConfig> instrumentationConfigs, @JsonProperty(value="aspects") @Nullable ImmutableList<String> aspects) {
        Builder builder = PluginDescriptor.builder();
        if (name != null) {
            builder.name(name);
        }
        if (id != null) {
            builder.id(id);
        }
        if (transactionTypes != null) {
            builder.addAllTransactionTypes(transactionTypes);
        }
        if (transactionCustomAttributes != null) {
            builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
        }
        if (properties != null) {
            builder.addAllProperties(properties);
        }
        if (instrumentationConfigs != null) {
            builder.addAllInstrumentationConfigs(instrumentationConfigs);
        }
        if (aspects != null) {
            builder.addAllAspects(aspects);
        }
        return builder.build();
    }

    public static PluginDescriptor copyOf(PluginDescriptorBase instance) {
        if (instance instanceof PluginDescriptor) {
            return (PluginDescriptor)instance;
        }
        return PluginDescriptor.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_ID = 2L;
        private long initializedBitset;
        @Nullable
        private String name;
        @Nullable
        private String id;
        private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<PropertyDescriptor> propertiesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<InstrumentationConfig> instrumentationConfigsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> aspectsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(PluginDescriptorBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.id(instance.id());
            this.addAllTransactionTypes(instance.transactionTypes());
            this.addAllTransactionCustomAttributes(instance.transactionCustomAttributes());
            this.addAllProperties(instance.properties());
            this.addAllInstrumentationConfigs(instance.instrumentationConfigs());
            this.addAllAspects(instance.aspects());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addTransactionTypes(String element) {
            this.transactionTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionTypes(String ... elements) {
            this.transactionTypesBuilder.add(elements);
            return this;
        }

        public final Builder transactionTypes(Iterable<String> elements) {
            this.transactionTypesBuilder = ImmutableList.builder();
            return this.addAllTransactionTypes(elements);
        }

        public final Builder addAllTransactionTypes(Iterable<String> elements) {
            this.transactionTypesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addTransactionCustomAttributes(String element) {
            this.transactionCustomAttributesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTransactionCustomAttributes(String ... elements) {
            this.transactionCustomAttributesBuilder.add(elements);
            return this;
        }

        public final Builder transactionCustomAttributes(Iterable<String> elements) {
            this.transactionCustomAttributesBuilder = ImmutableList.builder();
            return this.addAllTransactionCustomAttributes(elements);
        }

        public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
            this.transactionCustomAttributesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addProperties(PropertyDescriptor element) {
            this.propertiesBuilder.add((Object)element);
            return this;
        }

        public final Builder addProperties(PropertyDescriptor ... elements) {
            this.propertiesBuilder.add(elements);
            return this;
        }

        public final Builder properties(Iterable<? extends PropertyDescriptor> elements) {
            this.propertiesBuilder = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        public final Builder addAllProperties(Iterable<? extends PropertyDescriptor> elements) {
            this.propertiesBuilder.addAll(elements);
            return this;
        }

        public final Builder addInstrumentationConfigs(InstrumentationConfig element) {
            this.instrumentationConfigsBuilder.add((Object)element);
            return this;
        }

        public final Builder addInstrumentationConfigs(InstrumentationConfig ... elements) {
            this.instrumentationConfigsBuilder.add(elements);
            return this;
        }

        public final Builder instrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentationConfigsBuilder = ImmutableList.builder();
            return this.addAllInstrumentationConfigs(elements);
        }

        public final Builder addAllInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
            this.instrumentationConfigsBuilder.addAll(elements);
            return this;
        }

        public final Builder addAspects(String element) {
            this.aspectsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAspects(String ... elements) {
            this.aspectsBuilder.add(elements);
            return this;
        }

        public final Builder aspects(Iterable<String> elements) {
            this.aspectsBuilder = ImmutableList.builder();
            return this.addAllAspects(elements);
        }

        public final Builder addAllAspects(Iterable<String> elements) {
            this.aspectsBuilder.addAll((Iterable)elements);
            return this;
        }

        public PluginDescriptor build() {
            this.checkRequiredAttributes();
            return new PluginDescriptor(this.name, this.id, (ImmutableList)this.transactionTypesBuilder.build(), (ImmutableList)this.transactionCustomAttributesBuilder.build(), (ImmutableList)this.propertiesBuilder.build(), (ImmutableList)this.instrumentationConfigsBuilder.build(), (ImmutableList)this.aspectsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build PluginDescriptor, some of required attributes are not set " + attributes;
        }
    }
}

