/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.glowroot.container.common.ObjectMappers;

public class UserInterfaceConfig {
    private int port;
    private boolean adminPasswordEnabled;
    private boolean readOnlyPasswordEnabled;
    @Nullable
    private AnonymousAccess anonymousAccess;
    private int sessionTimeoutMinutes;
    private String currentAdminPassword = "";
    private String newAdminPassword = "";
    private String newReadOnlyPassword = "";
    private final String version;

    private UserInterfaceConfig(String version) {
        this.version = version;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAdminPasswordEnabled(boolean adminPasswordEnabled) {
        this.adminPasswordEnabled = adminPasswordEnabled;
    }

    public void setReadOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
        this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
    }

    @Nullable
    public AnonymousAccess getAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(AnonymousAccess anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    public int getSessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    public void setSessionTimeoutMinutes(int sessionTimeoutMinutes) {
        this.sessionTimeoutMinutes = sessionTimeoutMinutes;
    }

    public boolean isAdminPasswordEnabled() {
        return this.adminPasswordEnabled;
    }

    public boolean isReadOnlyPasswordEnabled() {
        return this.readOnlyPasswordEnabled;
    }

    @Nullable
    public String getCurrentAdminPassword() {
        return this.currentAdminPassword;
    }

    public void setCurrentAdminPassword(String currentAdminPassword) {
        this.currentAdminPassword = currentAdminPassword;
    }

    @Nullable
    public String getNewAdminPassword() {
        return this.newAdminPassword;
    }

    public void setNewAdminPassword(String newAdminPassword) {
        this.newAdminPassword = newAdminPassword;
    }

    @Nullable
    public String getNewReadOnlyPassword() {
        return this.newReadOnlyPassword;
    }

    public void setNewReadOnlyPassword(String newReadOnlyPassword) {
        this.newReadOnlyPassword = newReadOnlyPassword;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UserInterfaceConfig) {
            UserInterfaceConfig that = (UserInterfaceConfig)obj;
            return Objects.equal((Object)this.port, (Object)that.port) && Objects.equal((Object)this.adminPasswordEnabled, (Object)that.adminPasswordEnabled) && Objects.equal((Object)this.readOnlyPasswordEnabled, (Object)that.readOnlyPasswordEnabled) && Objects.equal((Object)((Object)this.anonymousAccess), (Object)((Object)that.anonymousAccess)) && Objects.equal((Object)this.sessionTimeoutMinutes, (Object)that.sessionTimeoutMinutes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.port, this.adminPasswordEnabled, this.readOnlyPasswordEnabled, this.anonymousAccess, this.sessionTimeoutMinutes});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("port", this.port).add("adminPasswordEnabled", this.adminPasswordEnabled).add("passwordEnabled", this.adminPasswordEnabled).add("anonymousAccess", (Object)this.anonymousAccess).add("sessionTimeoutMinutes", this.sessionTimeoutMinutes).add("version", (Object)this.version).toString();
    }

    @JsonCreator
    static UserInterfaceConfig readValue(@JsonProperty(value="port") @Nullable Integer port, @JsonProperty(value="adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled, @JsonProperty(value="readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled, @JsonProperty(value="anonymousAccess") @Nullable AnonymousAccess anonymousAccess, @JsonProperty(value="sessionTimeoutMinutes") @Nullable Integer sessionTimeoutMinutes, @JsonProperty(value="version") @Nullable String version) throws JsonMappingException {
        ObjectMappers.checkRequiredProperty(port, "port");
        ObjectMappers.checkRequiredProperty(adminPasswordEnabled, "adminPasswordEnabled");
        ObjectMappers.checkRequiredProperty(readOnlyPasswordEnabled, "readOnlyPasswordEnabled");
        ObjectMappers.checkRequiredProperty(anonymousAccess, "anonymousAccess");
        ObjectMappers.checkRequiredProperty(sessionTimeoutMinutes, "sessionTimeoutMinutes");
        ObjectMappers.checkRequiredProperty(version, "version");
        UserInterfaceConfig config = new UserInterfaceConfig(version);
        config.setPort(port);
        config.setAdminPasswordEnabled(adminPasswordEnabled);
        config.setReadOnlyPasswordEnabled(readOnlyPasswordEnabled);
        config.setAnonymousAccess(anonymousAccess);
        config.setSessionTimeoutMinutes(sessionTimeoutMinutes);
        return config;
    }

    public static enum AnonymousAccess {
        NONE,
        READ_ONLY,
        ADMIN;

    }
}

