/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.container.trace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.container.trace.TraceQueryBase;

@ParametersAreNonnullByDefault
@Immutable
public final class TraceQuery
extends TraceQueryBase {
    private final long from;
    private final long to;
    private final long durationLow;
    @Nullable
    private final Long durationHigh;
    @Nullable
    private final String transactionType;
    @Nullable
    private final TraceQueryBase.StringComparator transactionNameComparator;
    @Nullable
    private final String transactionName;
    @Nullable
    private final TraceQueryBase.StringComparator headlineComparator;
    @Nullable
    private final String headline;
    @Nullable
    private final TraceQueryBase.StringComparator errorComparator;
    @Nullable
    private final String error;
    @Nullable
    private final TraceQueryBase.StringComparator userComparator;
    @Nullable
    private final String user;
    @Nullable
    private final String customAttributeName;
    @Nullable
    private final TraceQueryBase.StringComparator customAttributeValueComparator;
    @Nullable
    private final String customAttributeValue;
    private final boolean errorOnly;
    private final int limit;

    private TraceQuery(Builder builder) {
        this.durationHigh = builder.durationHigh;
        this.transactionType = builder.transactionType;
        this.transactionNameComparator = builder.transactionNameComparator;
        this.transactionName = builder.transactionName;
        this.headlineComparator = builder.headlineComparator;
        this.headline = builder.headline;
        this.errorComparator = builder.errorComparator;
        this.error = builder.error;
        this.userComparator = builder.userComparator;
        this.user = builder.user;
        this.customAttributeName = builder.customAttributeName;
        this.customAttributeValueComparator = builder.customAttributeValueComparator;
        this.customAttributeValue = builder.customAttributeValue;
        this.from = builder.fromIsSet() ? builder.from : super.from();
        this.to = builder.toIsSet() ? builder.to : super.to();
        this.durationLow = builder.durationLowIsSet() ? builder.durationLow : super.durationLow();
        this.errorOnly = builder.errorOnlyIsSet() ? builder.errorOnly : super.errorOnly();
        this.limit = builder.limitIsSet() ? builder.limit : super.limit();
    }

    private TraceQuery(long from, long to, long durationLow, @Nullable Long durationHigh, @Nullable String transactionType, @Nullable TraceQueryBase.StringComparator transactionNameComparator, @Nullable String transactionName, @Nullable TraceQueryBase.StringComparator headlineComparator, @Nullable String headline, @Nullable TraceQueryBase.StringComparator errorComparator, @Nullable String error, @Nullable TraceQueryBase.StringComparator userComparator, @Nullable String user, @Nullable String customAttributeName, @Nullable TraceQueryBase.StringComparator customAttributeValueComparator, @Nullable String customAttributeValue, boolean errorOnly, int limit) {
        this.from = from;
        this.to = to;
        this.durationLow = durationLow;
        this.durationHigh = durationHigh;
        this.transactionType = transactionType;
        this.transactionNameComparator = transactionNameComparator;
        this.transactionName = transactionName;
        this.headlineComparator = headlineComparator;
        this.headline = headline;
        this.errorComparator = errorComparator;
        this.error = error;
        this.userComparator = userComparator;
        this.user = user;
        this.customAttributeName = customAttributeName;
        this.customAttributeValueComparator = customAttributeValueComparator;
        this.customAttributeValue = customAttributeValue;
        this.errorOnly = errorOnly;
        this.limit = limit;
    }

    @Override
    public long from() {
        return this.from;
    }

    @Override
    public long to() {
        return this.to;
    }

    @Override
    public long durationLow() {
        return this.durationLow;
    }

    @Override
    public Long durationHigh() {
        return this.durationHigh;
    }

    @Override
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    public TraceQueryBase.StringComparator transactionNameComparator() {
        return this.transactionNameComparator;
    }

    @Override
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    public TraceQueryBase.StringComparator headlineComparator() {
        return this.headlineComparator;
    }

    @Override
    public String headline() {
        return this.headline;
    }

    @Override
    public TraceQueryBase.StringComparator errorComparator() {
        return this.errorComparator;
    }

    @Override
    public String error() {
        return this.error;
    }

    @Override
    public TraceQueryBase.StringComparator userComparator() {
        return this.userComparator;
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public String customAttributeName() {
        return this.customAttributeName;
    }

    @Override
    public TraceQueryBase.StringComparator customAttributeValueComparator() {
        return this.customAttributeValueComparator;
    }

    @Override
    public String customAttributeValue() {
        return this.customAttributeValue;
    }

    @Override
    public boolean errorOnly() {
        return this.errorOnly;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final TraceQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TraceQuery(newValue, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TraceQuery(this.from, newValue, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withDurationLow(long value) {
        if (this.durationLow == value) {
            return this;
        }
        long newValue = value;
        return new TraceQuery(this.from, this.to, newValue, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withDurationHigh(@Nullable Long value) {
        if (this.durationHigh == value) {
            return this;
        }
        Long newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, newValue, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withTransactionType(@Nullable String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, newValue, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withTransactionNameComparator(@Nullable TraceQueryBase.StringComparator value) {
        if (this.transactionNameComparator == value) {
            return this;
        }
        TraceQueryBase.StringComparator newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, newValue, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, newValue, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withHeadlineComparator(@Nullable TraceQueryBase.StringComparator value) {
        if (this.headlineComparator == value) {
            return this;
        }
        TraceQueryBase.StringComparator newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, newValue, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withHeadline(@Nullable String value) {
        if (this.headline == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, newValue, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withErrorComparator(@Nullable TraceQueryBase.StringComparator value) {
        if (this.errorComparator == value) {
            return this;
        }
        TraceQueryBase.StringComparator newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, newValue, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withError(@Nullable String value) {
        if (this.error == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, newValue, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withUserComparator(@Nullable TraceQueryBase.StringComparator value) {
        if (this.userComparator == value) {
            return this;
        }
        TraceQueryBase.StringComparator newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, newValue, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withUser(@Nullable String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, newValue, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withCustomAttributeName(@Nullable String value) {
        if (this.customAttributeName == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, newValue, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withCustomAttributeValueComparator(@Nullable TraceQueryBase.StringComparator value) {
        if (this.customAttributeValueComparator == value) {
            return this;
        }
        TraceQueryBase.StringComparator newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, newValue, this.customAttributeValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withCustomAttributeValue(@Nullable String value) {
        if (this.customAttributeValue == value) {
            return this;
        }
        String newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, newValue, this.errorOnly, this.limit);
    }

    public final TraceQuery withErrorOnly(boolean value) {
        if (this.errorOnly == value) {
            return this;
        }
        boolean newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, newValue, this.limit);
    }

    public final TraceQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new TraceQuery(this.from, this.to, this.durationLow, this.durationHigh, this.transactionType, this.transactionNameComparator, this.transactionName, this.headlineComparator, this.headline, this.errorComparator, this.error, this.userComparator, this.user, this.customAttributeName, this.customAttributeValueComparator, this.customAttributeValue, this.errorOnly, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TraceQuery && this.equalTo((TraceQuery)another);
    }

    private boolean equalTo(TraceQuery another) {
        return this.from == another.from && this.to == another.to && this.durationLow == another.durationLow && Objects.equal((Object)this.durationHigh, (Object)another.durationHigh) && Objects.equal((Object)this.transactionType, (Object)another.transactionType) && Objects.equal((Object)((Object)this.transactionNameComparator), (Object)((Object)another.transactionNameComparator)) && Objects.equal((Object)this.transactionName, (Object)another.transactionName) && Objects.equal((Object)((Object)this.headlineComparator), (Object)((Object)another.headlineComparator)) && Objects.equal((Object)this.headline, (Object)another.headline) && Objects.equal((Object)((Object)this.errorComparator), (Object)((Object)another.errorComparator)) && Objects.equal((Object)this.error, (Object)another.error) && Objects.equal((Object)((Object)this.userComparator), (Object)((Object)another.userComparator)) && Objects.equal((Object)this.user, (Object)another.user) && Objects.equal((Object)this.customAttributeName, (Object)another.customAttributeName) && Objects.equal((Object)((Object)this.customAttributeValueComparator), (Object)((Object)another.customAttributeValueComparator)) && Objects.equal((Object)this.customAttributeValue, (Object)another.customAttributeValue) && this.errorOnly == another.errorOnly && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode((long)this.from);
        h = h * 17 + Longs.hashCode((long)this.to);
        h = h * 17 + Longs.hashCode((long)this.durationLow);
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.durationHigh});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.transactionType});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.transactionNameComparator});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.transactionName});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.headlineComparator});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.headline});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.errorComparator});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.error});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.userComparator});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.user});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.customAttributeName});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.customAttributeValueComparator});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.customAttributeValue});
        h = h * 17 + Booleans.hashCode((boolean)this.errorOnly);
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TraceQuery").add("from", this.from).add("to", this.to).add("durationLow", this.durationLow).add("durationHigh", (Object)this.durationHigh).add("transactionType", (Object)this.transactionType).add("transactionNameComparator", (Object)this.transactionNameComparator).add("transactionName", (Object)this.transactionName).add("headlineComparator", (Object)this.headlineComparator).add("headline", (Object)this.headline).add("errorComparator", (Object)this.errorComparator).add("error", (Object)this.error).add("userComparator", (Object)this.userComparator).add("user", (Object)this.user).add("customAttributeName", (Object)this.customAttributeName).add("customAttributeValueComparator", (Object)this.customAttributeValueComparator).add("customAttributeValue", (Object)this.customAttributeValue).add("errorOnly", this.errorOnly).add("limit", this.limit).toString();
    }

    public static TraceQuery copyOf(TraceQueryBase instance) {
        if (instance instanceof TraceQuery) {
            return (TraceQuery)instance;
        }
        return TraceQuery.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_FROM = 1L;
        private static final long NONDEFAULT_BIT_TO = 2L;
        private static final long NONDEFAULT_BIT_DURATION_LOW = 4L;
        private static final long NONDEFAULT_BIT_ERROR_ONLY = 8L;
        private static final long NONDEFAULT_BIT_LIMIT = 16L;
        private long nondefaultBitset;
        private long from;
        private long to;
        private long durationLow;
        @Nullable
        private Long durationHigh;
        @Nullable
        private String transactionType;
        @Nullable
        private TraceQueryBase.StringComparator transactionNameComparator;
        @Nullable
        private String transactionName;
        @Nullable
        private TraceQueryBase.StringComparator headlineComparator;
        @Nullable
        private String headline;
        @Nullable
        private TraceQueryBase.StringComparator errorComparator;
        @Nullable
        private String error;
        @Nullable
        private TraceQueryBase.StringComparator userComparator;
        @Nullable
        private String user;
        @Nullable
        private String customAttributeName;
        @Nullable
        private TraceQueryBase.StringComparator customAttributeValueComparator;
        @Nullable
        private String customAttributeValue;
        private boolean errorOnly;
        private int limit;

        private Builder() {
        }

        public final Builder all(TraceQueryBase instance) {
            String customAttributeValueValue;
            TraceQueryBase.StringComparator customAttributeValueComparatorValue;
            String customAttributeNameValue;
            String userValue;
            TraceQueryBase.StringComparator userComparatorValue;
            String errorValue;
            TraceQueryBase.StringComparator errorComparatorValue;
            String headlineValue;
            TraceQueryBase.StringComparator headlineComparatorValue;
            String transactionNameValue;
            TraceQueryBase.StringComparator transactionNameComparatorValue;
            String transactionTypeValue;
            Preconditions.checkNotNull((Object)instance);
            this.from(instance.from());
            this.to(instance.to());
            this.durationLow(instance.durationLow());
            Long durationHighValue = instance.durationHigh();
            if (durationHighValue != null) {
                this.durationHigh(durationHighValue);
            }
            if ((transactionTypeValue = instance.transactionType()) != null) {
                this.transactionType(transactionTypeValue);
            }
            if ((transactionNameComparatorValue = instance.transactionNameComparator()) != null) {
                this.transactionNameComparator(transactionNameComparatorValue);
            }
            if ((transactionNameValue = instance.transactionName()) != null) {
                this.transactionName(transactionNameValue);
            }
            if ((headlineComparatorValue = instance.headlineComparator()) != null) {
                this.headlineComparator(headlineComparatorValue);
            }
            if ((headlineValue = instance.headline()) != null) {
                this.headline(headlineValue);
            }
            if ((errorComparatorValue = instance.errorComparator()) != null) {
                this.errorComparator(errorComparatorValue);
            }
            if ((errorValue = instance.error()) != null) {
                this.error(errorValue);
            }
            if ((userComparatorValue = instance.userComparator()) != null) {
                this.userComparator(userComparatorValue);
            }
            if ((userValue = instance.user()) != null) {
                this.user(userValue);
            }
            if ((customAttributeNameValue = instance.customAttributeName()) != null) {
                this.customAttributeName(customAttributeNameValue);
            }
            if ((customAttributeValueComparatorValue = instance.customAttributeValueComparator()) != null) {
                this.customAttributeValueComparator(customAttributeValueComparatorValue);
            }
            if ((customAttributeValueValue = instance.customAttributeValue()) != null) {
                this.customAttributeValue(customAttributeValueValue);
            }
            this.errorOnly(instance.errorOnly());
            this.limit(instance.limit());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder durationLow(long durationLow) {
            this.durationLow = durationLow;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder durationHigh(@Nullable Long durationHigh) {
            this.durationHigh = durationHigh;
            return this;
        }

        public final Builder transactionType(@Nullable String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public final Builder transactionNameComparator(@Nullable TraceQueryBase.StringComparator transactionNameComparator) {
            this.transactionNameComparator = transactionNameComparator;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder headlineComparator(@Nullable TraceQueryBase.StringComparator headlineComparator) {
            this.headlineComparator = headlineComparator;
            return this;
        }

        public final Builder headline(@Nullable String headline) {
            this.headline = headline;
            return this;
        }

        public final Builder errorComparator(@Nullable TraceQueryBase.StringComparator errorComparator) {
            this.errorComparator = errorComparator;
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder userComparator(@Nullable TraceQueryBase.StringComparator userComparator) {
            this.userComparator = userComparator;
            return this;
        }

        public final Builder user(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder customAttributeName(@Nullable String customAttributeName) {
            this.customAttributeName = customAttributeName;
            return this;
        }

        public final Builder customAttributeValueComparator(@Nullable TraceQueryBase.StringComparator customAttributeValueComparator) {
            this.customAttributeValueComparator = customAttributeValueComparator;
            return this;
        }

        public final Builder customAttributeValue(@Nullable String customAttributeValue) {
            this.customAttributeValue = customAttributeValue;
            return this;
        }

        public final Builder errorOnly(boolean errorOnly) {
            this.errorOnly = errorOnly;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public TraceQuery build() {
            return new TraceQuery(this);
        }

        private boolean fromIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean durationLowIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean errorOnlyIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }
    }
}

