/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.Schemas;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class Column
extends Schemas.ColumnBase {
    private final String name;
    private final int type;
    private final boolean primaryKey;
    private final boolean identity;

    private Column(String name, int type) {
        this.name = Preconditions.checkNotNull(name);
        this.type = type;
        this.primaryKey = super.primaryKey();
        this.identity = super.identity();
    }

    private Column(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.primaryKey = builder.primaryKeyIsSet() ? builder.primaryKey : super.primaryKey();
        this.identity = builder.identityIsSet() ? builder.identity : super.identity();
    }

    private Column(String name, int type, boolean primaryKey, boolean identity) {
        this.name = name;
        this.type = type;
        this.primaryKey = primaryKey;
        this.identity = identity;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public boolean primaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean identity() {
        return this.identity;
    }

    public final Column withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Column(newValue, this.type, this.primaryKey, this.identity);
    }

    public final Column withType(int value) {
        if (this.type == value) {
            return this;
        }
        int newValue = value;
        return new Column(this.name, newValue, this.primaryKey, this.identity);
    }

    public final Column withPrimaryKey(boolean value) {
        if (this.primaryKey == value) {
            return this;
        }
        boolean newValue = value;
        return new Column(this.name, this.type, newValue, this.identity);
    }

    public final Column withIdentity(boolean value) {
        if (this.identity == value) {
            return this;
        }
        boolean newValue = value;
        return new Column(this.name, this.type, this.primaryKey, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Column && this.equalTo((Column)another);
    }

    private boolean equalTo(Column another) {
        return this.name.equals(another.name) && this.type == another.type && this.primaryKey == another.primaryKey && this.identity == another.identity;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.type;
        h = h * 17 + Booleans.hashCode(this.primaryKey);
        h = h * 17 + Booleans.hashCode(this.identity);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Column").add("name", this.name).add("type", this.type).add("primaryKey", this.primaryKey).add("identity", this.identity).toString();
    }

    public static Column of(String name, int type) {
        return new Column(name, type);
    }

    static Column copyOf(Schemas.ColumnBase instance) {
        if (instance instanceof Column) {
            return (Column)instance;
        }
        return Column.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_TYPE = 2L;
        private static final long NONDEFAULT_BIT_PRIMARY_KEY = 1L;
        private static final long NONDEFAULT_BIT_IDENTITY = 2L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String name;
        private int type;
        private boolean primaryKey;
        private boolean identity;

        private Builder() {
        }

        public final Builder all(Schemas.ColumnBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.type(instance.type());
            this.primaryKey(instance.primaryKey());
            this.identity(instance.identity());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder type(int type) {
            this.type = type;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder primaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder identity(boolean identity) {
            this.identity = identity;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public Column build() {
            this.checkRequiredAttributes();
            return new Column(this);
        }

        private boolean primaryKeyIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean identityIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build Column, some of required attributes are not set " + attributes;
        }
    }
}

