/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.ErrorMessageQueryBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class ErrorMessageQuery
extends ErrorMessageQueryBase {
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final long from;
    private final long to;
    private final ImmutableList<String> includes;
    private final ImmutableList<String> excludes;
    private final int limit;

    private ErrorMessageQuery(String transactionType, @Nullable String transactionName, long from, long to, ImmutableList<String> includes, ImmutableList<String> excludes, int limit) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.from = from;
        this.to = to;
        this.includes = includes;
        this.excludes = excludes;
        this.limit = limit;
    }

    @Override
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    public long from() {
        return this.from;
    }

    @Override
    public long to() {
        return this.to;
    }

    @Override
    public ImmutableList<String> includes() {
        return this.includes;
    }

    @Override
    public ImmutableList<String> excludes() {
        return this.excludes;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final ErrorMessageQuery withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ErrorMessageQuery(newValue, this.transactionName, this.from, this.to, this.includes, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new ErrorMessageQuery(this.transactionType, newValue, this.from, this.to, this.includes, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new ErrorMessageQuery(this.transactionType, this.transactionName, newValue, this.to, this.includes, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, newValue, this.includes, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withIncludes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, newValue, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withIncludes(Iterable<String> elements) {
        if (this.includes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, newValue, this.excludes, this.limit);
    }

    public final ErrorMessageQuery withExcludes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, this.includes, newValue, this.limit);
    }

    public final ErrorMessageQuery withExcludes(Iterable<String> elements) {
        if (this.excludes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, this.includes, newValue, this.limit);
    }

    public final ErrorMessageQuery withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, this.includes, this.excludes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorMessageQuery && this.equalTo((ErrorMessageQuery)another);
    }

    private boolean equalTo(ErrorMessageQuery another) {
        return this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && this.from == another.from && this.to == another.to && this.includes.equals(another.includes) && this.excludes.equals(another.excludes) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.includes.hashCode();
        h = h * 17 + this.excludes.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorMessageQuery").add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("from", this.from).add("to", this.to).add("includes", this.includes).add("excludes", this.excludes).add("limit", this.limit).toString();
    }

    public static ErrorMessageQuery copyOf(ErrorMessageQueryBase instance) {
        if (instance instanceof ErrorMessageQuery) {
            return (ErrorMessageQuery)instance;
        }
        return ErrorMessageQuery.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 1L;
        private static final long INITIALIZED_BIT_FROM = 2L;
        private static final long INITIALIZED_BIT_TO = 4L;
        private static final long INITIALIZED_BIT_LIMIT = 8L;
        private long initializedBitset;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private long from;
        private long to;
        private ImmutableList.Builder<String> includesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> excludesBuilder = ImmutableList.builder();
        private int limit;

        private Builder() {
        }

        public final Builder all(ErrorMessageQueryBase instance) {
            Preconditions.checkNotNull(instance);
            this.transactionType(instance.transactionType());
            String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.from(instance.from());
            this.to(instance.to());
            this.addAllIncludes(instance.includes());
            this.addAllExcludes(instance.excludes());
            this.limit(instance.limit());
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder addIncludes(String element) {
            this.includesBuilder.add((Object)element);
            return this;
        }

        public final Builder addIncludes(String ... elements) {
            this.includesBuilder.add(elements);
            return this;
        }

        public final Builder includes(Iterable<String> elements) {
            this.includesBuilder = ImmutableList.builder();
            return this.addAllIncludes(elements);
        }

        public final Builder addAllIncludes(Iterable<String> elements) {
            this.includesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder addExcludes(String element) {
            this.excludesBuilder.add((Object)element);
            return this;
        }

        public final Builder addExcludes(String ... elements) {
            this.excludesBuilder.add(elements);
            return this;
        }

        public final Builder excludes(Iterable<String> elements) {
            this.excludesBuilder = ImmutableList.builder();
            return this.addAllExcludes(elements);
        }

        public final Builder addAllExcludes(Iterable<String> elements) {
            this.excludesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 8L;
            return this;
        }

        public ErrorMessageQuery build() {
            this.checkRequiredAttributes();
            return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, (ImmutableList)this.includesBuilder.build(), (ImmutableList)this.excludesBuilder.build(), this.limit);
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build ErrorMessageQuery, some of required attributes are not set " + attributes;
        }
    }
}

