/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.collector.GaugePoint;
import org.glowroot.collector.GaugePointRepository;
import org.glowroot.common.Checkers;
import org.glowroot.common.Clock;
import org.glowroot.local.store.Column;
import org.glowroot.local.store.DataSource;
import org.glowroot.local.store.GaugeMetaDao;
import org.glowroot.local.store.Index;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

public class GaugePointDao
implements GaugePointRepository {
    public static final long ROLLUP_THRESHOLD_MILLIS = TimeUnit.HOURS.toMillis(1L);
    private static final ImmutableList<Column> gaugePointColumns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8));
    private static final ImmutableList<Index> gaugePointIndexes = ImmutableList.of(Index.of("gauge_point_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private static final ImmutableList<Column> gaugePointRollupColumns = ImmutableList.of(Column.of("gauge_meta_id", -5), Column.of("capture_time", -5), Column.of("value", 8), Column.of("count", 8));
    private static final ImmutableList<Index> gaugePointRollupIndexes = ImmutableList.of(Index.of("gauge_point_rollup_1_idx", ImmutableList.of("gauge_meta_id", "capture_time", "value")));
    private final GaugeMetaDao gaugeMetaDao;
    private final DataSource dataSource;
    private final Clock clock;
    private final long fixedRollupMillis;
    private volatile long lastRollupTime;

    GaugePointDao(DataSource dataSource, Clock clock, long fixedRollupSeconds) throws SQLException {
        this.gaugeMetaDao = new GaugeMetaDao(dataSource);
        this.dataSource = dataSource;
        this.clock = clock;
        this.fixedRollupMillis = fixedRollupSeconds * 1000L;
        dataSource.renameColumn("gauge_point", "gauge_id", "gauge_meta_id");
        dataSource.renameColumn("gauge_point_rollup_1", "gauge_id", "gauge_meta_id");
        dataSource.syncTable("gauge_point", gaugePointColumns);
        dataSource.syncIndexes("gauge_point", gaugePointIndexes);
        dataSource.syncTable("gauge_point_rollup_1", gaugePointRollupColumns);
        dataSource.syncIndexes("gauge_point_rollup_1", gaugePointRollupIndexes);
        this.lastRollupTime = dataSource.queryForLong("select ifnull(max(capture_time), 0) from gauge_point_rollup_1", new Object[0]);
    }

    @Override
    public void store(final List<GaugePoint> gaugePoints) throws Exception {
        if (gaugePoints.isEmpty()) {
            return;
        }
        this.dataSource.batchUpdate("insert into gauge_point (gauge_meta_id, capture_time, value) values (?, ?, ?)", new DataSource.BatchAdder(){

            @Override
            public void addBatches(PreparedStatement preparedStatement) throws SQLException {
                for (GaugePoint gaugePoint : gaugePoints) {
                    Boolean everIncreasing = gaugePoint.everIncreasing();
                    Preconditions.checkNotNull(everIncreasing);
                    long gaugeMetaId = GaugePointDao.this.gaugeMetaDao.getOrCreateGaugeMetaId(gaugePoint.gaugeName(), everIncreasing);
                    preparedStatement.setLong(1, gaugeMetaId);
                    preparedStatement.setLong(2, gaugePoint.captureTime());
                    preparedStatement.setDouble(3, gaugePoint.value());
                    preparedStatement.addBatch();
                }
            }
        });
        long safeRollupTime = this.clock.currentTimeMillis() - 1L;
        safeRollupTime = (long)Math.floor((double)safeRollupTime / (double)this.fixedRollupMillis) * this.fixedRollupMillis;
        if (safeRollupTime > this.lastRollupTime) {
            this.rollup(this.lastRollupTime, safeRollupTime);
            this.lastRollupTime = safeRollupTime;
        }
    }

    public ImmutableList<GaugePoint> readGaugePoints(String gaugeName, long captureTimeFrom, long captureTimeTo, int rollupLevel) throws SQLException {
        Long gaugeMetaId;
        String tableName = "gauge_point";
        if (rollupLevel > 0) {
            tableName = tableName + "_rollup_" + Checkers.castUntainted(rollupLevel);
        }
        if ((gaugeMetaId = this.gaugeMetaDao.getGaugeMetaId(gaugeName)) == null) {
            return ImmutableList.of();
        }
        return this.dataSource.query("select capture_time, value from " + tableName + " where gauge_meta_id = ? and capture_time >= ? and capture_time <= ?" + " order by capture_time", new GaugePointRowMapper(gaugeName), gaugeMetaId, captureTimeFrom, captureTimeTo);
    }

    public void deleteAll() throws SQLException {
        this.dataSource.execute("truncate table gauge_point");
        this.dataSource.execute("truncate table gauge_point_rollup_1");
    }

    void deleteBefore(long captureTime) throws SQLException {
        this.dataSource.deleteBefore("gauge_point", captureTime);
        this.dataSource.deleteBefore("gauge_point_rollup_1", captureTime);
    }

    private void rollup(long lastRollupTime, long safeRollupTime) throws SQLException {
        String captureTimeSql = Checkers.castUntainted("ceil(capture_time / " + this.fixedRollupMillis + ".0) * " + this.fixedRollupMillis);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, false);
        this.rollup(lastRollupTime, safeRollupTime, captureTimeSql, true);
    }

    private void rollup(long lastRollupTime, long safeRollupTime, @Untainted String captureTimeSql, boolean everIncreasing) throws SQLException {
        String aggregateFunction = everIncreasing ? "max" : "avg";
        this.dataSource.update("insert into gauge_point_rollup_1 (gauge_meta_id, capture_time, value, count) select gauge_meta_id, " + captureTimeSql + " ceil_capture_time, " + aggregateFunction + "(value), count(*) from gauge_point gp, gauge_meta gm" + " where gp.capture_time > ? and gp.capture_time <= ?" + " and gp.gauge_meta_id = gm.id and gm.ever_increasing = ?" + " group by gp.gauge_meta_id, ceil_capture_time", lastRollupTime, safeRollupTime, everIncreasing);
    }

    private static class GaugePointRowMapper
    implements DataSource.RowMapper<GaugePoint> {
        private final String gaugeName;

        public GaugePointRowMapper(String gaugeName) {
            this.gaugeName = gaugeName;
        }

        @Override
        public GaugePoint mapRow(ResultSet resultSet) throws SQLException {
            long captureTime = resultSet.getLong(1);
            double value = resultSet.getDouble(2);
            return GaugePoint.builder().gaugeName(this.gaugeName).captureTime(captureTime).value(value).build();
        }
    }
}

