/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.store;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.tainting.qual.Untainted;
import org.glowroot.local.store.ParameterizedSqlBase;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class ParameterizedSql
extends ParameterizedSqlBase {
    private final String sql;
    private final ImmutableList<Object> args;

    private ParameterizedSql(String sql, Iterable<? extends Object> args) {
        this.sql = Preconditions.checkNotNull(sql);
        this.args = ImmutableList.copyOf(args);
    }

    private ParameterizedSql(ParameterizedSql original, String sql, ImmutableList<Object> args) {
        this.sql = sql;
        this.args = args;
    }

    @Override
    @Untainted
    public String sql() {
        return this.sql;
    }

    @Override
    public ImmutableList<Object> args() {
        return this.args;
    }

    public final ParameterizedSql withSql(String value) {
        if (this.sql == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new ParameterizedSql(this, newValue, this.args);
    }

    public final ParameterizedSql withArgs(Object ... elements) {
        ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
        return new ParameterizedSql(this, this.sql, newValue);
    }

    public final ParameterizedSql withArgs(Iterable<? extends Object> elements) {
        if (this.args == elements) {
            return this;
        }
        ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
        return new ParameterizedSql(this, this.sql, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ParameterizedSql && this.equalTo((ParameterizedSql)another);
    }

    private boolean equalTo(ParameterizedSql another) {
        return this.sql.equals(another.sql) && this.args.equals(another.args);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.sql.hashCode();
        h = h * 17 + this.args.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ParameterizedSql").add("sql", this.sql).add("args", this.args).toString();
    }

    public static ParameterizedSql of(String sql, ImmutableList<Object> args) {
        return ParameterizedSql.of(sql, args);
    }

    public static ParameterizedSql of(String sql, Iterable<? extends Object> args) {
        return new ParameterizedSql(sql, args);
    }

    static ParameterizedSql copyOf(ParameterizedSqlBase instance) {
        if (instance instanceof ParameterizedSql) {
            return (ParameterizedSql)instance;
        }
        return ParameterizedSql.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_SQL = 1L;
        private long initializedBitset;
        @Nullable
        private String sql;
        private ImmutableList.Builder<Object> argsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(ParameterizedSqlBase instance) {
            Preconditions.checkNotNull(instance);
            this.sql(instance.sql());
            this.addAllArgs(instance.args());
            return this;
        }

        public final Builder sql(String sql) {
            this.sql = Preconditions.checkNotNull(sql);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addArgs(Object element) {
            this.argsBuilder.add(element);
            return this;
        }

        public final Builder addArgs(Object ... elements) {
            this.argsBuilder.add(elements);
            return this;
        }

        public final Builder args(Iterable<? extends Object> elements) {
            this.argsBuilder = ImmutableList.builder();
            return this.addAllArgs(elements);
        }

        public final Builder addAllArgs(Iterable<? extends Object> elements) {
            this.argsBuilder.addAll(elements);
            return this;
        }

        public ParameterizedSql build() {
            this.checkRequiredAttributes();
            return new ParameterizedSql(null, this.sql, (ImmutableList)this.argsBuilder.build());
        }

        private boolean sqlIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.sqlIsSet()) {
                attributes.add("sql");
            }
            return "Cannot build ParameterizedSql, some of required attributes are not set " + attributes;
        }
    }
}

