/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class AdvancedConfigDto
extends ConfigJsonService.AdvancedConfigDtoBase {
    private final boolean timerWrapperMethods;
    private final boolean weavingTimer;
    private final int immediatePartialStoreThresholdSeconds;
    private final int maxAggregateTransactionsPerTransactionType;
    private final int maxAggregateQueriesPerQueryType;
    private final int maxTraceEntriesPerTransaction;
    private final int maxStackTraceSamplesPerTransaction;
    private final boolean captureThreadInfo;
    private final boolean captureGcInfo;
    private final int mbeanGaugeNotFoundDelaySeconds;
    private final int internalQueryTimeoutSeconds;
    private final String version;

    private AdvancedConfigDto(boolean timerWrapperMethods, boolean weavingTimer, int immediatePartialStoreThresholdSeconds, int maxAggregateTransactionsPerTransactionType, int maxAggregateQueriesPerQueryType, int maxTraceEntriesPerTransaction, int maxStackTraceSamplesPerTransaction, boolean captureThreadInfo, boolean captureGcInfo, int mbeanGaugeNotFoundDelaySeconds, int internalQueryTimeoutSeconds, String version) {
        this.timerWrapperMethods = timerWrapperMethods;
        this.weavingTimer = weavingTimer;
        this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
        this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
        this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
        this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
        this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
        this.captureThreadInfo = captureThreadInfo;
        this.captureGcInfo = captureGcInfo;
        this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
        this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
        this.version = version;
    }

    @Override
    @JsonProperty(value="timerWrapperMethods")
    public boolean timerWrapperMethods() {
        return this.timerWrapperMethods;
    }

    @Override
    @JsonProperty(value="weavingTimer")
    public boolean weavingTimer() {
        return this.weavingTimer;
    }

    @Override
    @JsonProperty(value="immediatePartialStoreThresholdSeconds")
    public int immediatePartialStoreThresholdSeconds() {
        return this.immediatePartialStoreThresholdSeconds;
    }

    @Override
    @JsonProperty(value="maxAggregateTransactionsPerTransactionType")
    public int maxAggregateTransactionsPerTransactionType() {
        return this.maxAggregateTransactionsPerTransactionType;
    }

    @Override
    @JsonProperty(value="maxAggregateQueriesPerQueryType")
    public int maxAggregateQueriesPerQueryType() {
        return this.maxAggregateQueriesPerQueryType;
    }

    @Override
    @JsonProperty(value="maxTraceEntriesPerTransaction")
    public int maxTraceEntriesPerTransaction() {
        return this.maxTraceEntriesPerTransaction;
    }

    @Override
    @JsonProperty(value="maxStackTraceSamplesPerTransaction")
    public int maxStackTraceSamplesPerTransaction() {
        return this.maxStackTraceSamplesPerTransaction;
    }

    @Override
    @JsonProperty(value="captureThreadInfo")
    public boolean captureThreadInfo() {
        return this.captureThreadInfo;
    }

    @Override
    @JsonProperty(value="captureGcInfo")
    public boolean captureGcInfo() {
        return this.captureGcInfo;
    }

    @Override
    @JsonProperty(value="mbeanGaugeNotFoundDelaySeconds")
    public int mbeanGaugeNotFoundDelaySeconds() {
        return this.mbeanGaugeNotFoundDelaySeconds;
    }

    @Override
    @JsonProperty(value="internalQueryTimeoutSeconds")
    public int internalQueryTimeoutSeconds() {
        return this.internalQueryTimeoutSeconds;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final AdvancedConfigDto withTimerWrapperMethods(boolean value) {
        if (this.timerWrapperMethods == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfigDto(newValue, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withWeavingTimer(boolean value) {
        if (this.weavingTimer == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, newValue, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withImmediatePartialStoreThresholdSeconds(int value) {
        if (this.immediatePartialStoreThresholdSeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, newValue, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withMaxAggregateTransactionsPerTransactionType(int value) {
        if (this.maxAggregateTransactionsPerTransactionType == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, newValue, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withMaxAggregateQueriesPerQueryType(int value) {
        if (this.maxAggregateQueriesPerQueryType == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, newValue, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withMaxTraceEntriesPerTransaction(int value) {
        if (this.maxTraceEntriesPerTransaction == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, newValue, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withMaxStackTraceSamplesPerTransaction(int value) {
        if (this.maxStackTraceSamplesPerTransaction == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, newValue, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withCaptureThreadInfo(boolean value) {
        if (this.captureThreadInfo == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, newValue, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withCaptureGcInfo(boolean value) {
        if (this.captureGcInfo == value) {
            return this;
        }
        boolean newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, newValue, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withMbeanGaugeNotFoundDelaySeconds(int value) {
        if (this.mbeanGaugeNotFoundDelaySeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, newValue, this.internalQueryTimeoutSeconds, this.version);
    }

    public final AdvancedConfigDto withInternalQueryTimeoutSeconds(int value) {
        if (this.internalQueryTimeoutSeconds == value) {
            return this;
        }
        int newValue = value;
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, newValue, this.version);
    }

    public final AdvancedConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AdvancedConfigDto && this.equalTo((AdvancedConfigDto)another);
    }

    private boolean equalTo(AdvancedConfigDto another) {
        return this.timerWrapperMethods == another.timerWrapperMethods && this.weavingTimer == another.weavingTimer && this.immediatePartialStoreThresholdSeconds == another.immediatePartialStoreThresholdSeconds && this.maxAggregateTransactionsPerTransactionType == another.maxAggregateTransactionsPerTransactionType && this.maxAggregateQueriesPerQueryType == another.maxAggregateQueriesPerQueryType && this.maxTraceEntriesPerTransaction == another.maxTraceEntriesPerTransaction && this.maxStackTraceSamplesPerTransaction == another.maxStackTraceSamplesPerTransaction && this.captureThreadInfo == another.captureThreadInfo && this.captureGcInfo == another.captureGcInfo && this.mbeanGaugeNotFoundDelaySeconds == another.mbeanGaugeNotFoundDelaySeconds && this.internalQueryTimeoutSeconds == another.internalQueryTimeoutSeconds && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.timerWrapperMethods);
        h = h * 17 + Booleans.hashCode(this.weavingTimer);
        h = h * 17 + this.immediatePartialStoreThresholdSeconds;
        h = h * 17 + this.maxAggregateTransactionsPerTransactionType;
        h = h * 17 + this.maxAggregateQueriesPerQueryType;
        h = h * 17 + this.maxTraceEntriesPerTransaction;
        h = h * 17 + this.maxStackTraceSamplesPerTransaction;
        h = h * 17 + Booleans.hashCode(this.captureThreadInfo);
        h = h * 17 + Booleans.hashCode(this.captureGcInfo);
        h = h * 17 + this.mbeanGaugeNotFoundDelaySeconds;
        h = h * 17 + this.internalQueryTimeoutSeconds;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdvancedConfigDto").add("timerWrapperMethods", this.timerWrapperMethods).add("weavingTimer", this.weavingTimer).add("immediatePartialStoreThresholdSeconds", this.immediatePartialStoreThresholdSeconds).add("maxAggregateTransactionsPerTransactionType", this.maxAggregateTransactionsPerTransactionType).add("maxAggregateQueriesPerQueryType", this.maxAggregateQueriesPerQueryType).add("maxTraceEntriesPerTransaction", this.maxTraceEntriesPerTransaction).add("maxStackTraceSamplesPerTransaction", this.maxStackTraceSamplesPerTransaction).add("captureThreadInfo", this.captureThreadInfo).add("captureGcInfo", this.captureGcInfo).add("mbeanGaugeNotFoundDelaySeconds", this.mbeanGaugeNotFoundDelaySeconds).add("internalQueryTimeoutSeconds", this.internalQueryTimeoutSeconds).add("version", this.version).toString();
    }

    @JsonCreator
    public static AdvancedConfigDto fromAllAttributes(@JsonProperty(value="timerWrapperMethods") @Nullable Boolean timerWrapperMethods, @JsonProperty(value="weavingTimer") @Nullable Boolean weavingTimer, @JsonProperty(value="immediatePartialStoreThresholdSeconds") @Nullable Integer immediatePartialStoreThresholdSeconds, @JsonProperty(value="maxAggregateTransactionsPerTransactionType") @Nullable Integer maxAggregateTransactionsPerTransactionType, @JsonProperty(value="maxAggregateQueriesPerQueryType") @Nullable Integer maxAggregateQueriesPerQueryType, @JsonProperty(value="maxTraceEntriesPerTransaction") @Nullable Integer maxTraceEntriesPerTransaction, @JsonProperty(value="maxStackTraceSamplesPerTransaction") @Nullable Integer maxStackTraceSamplesPerTransaction, @JsonProperty(value="captureThreadInfo") @Nullable Boolean captureThreadInfo, @JsonProperty(value="captureGcInfo") @Nullable Boolean captureGcInfo, @JsonProperty(value="mbeanGaugeNotFoundDelaySeconds") @Nullable Integer mbeanGaugeNotFoundDelaySeconds, @JsonProperty(value="internalQueryTimeoutSeconds") @Nullable Integer internalQueryTimeoutSeconds, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = AdvancedConfigDto.builder();
        if (timerWrapperMethods != null) {
            builder.timerWrapperMethods(timerWrapperMethods);
        }
        if (weavingTimer != null) {
            builder.weavingTimer(weavingTimer);
        }
        if (immediatePartialStoreThresholdSeconds != null) {
            builder.immediatePartialStoreThresholdSeconds(immediatePartialStoreThresholdSeconds);
        }
        if (maxAggregateTransactionsPerTransactionType != null) {
            builder.maxAggregateTransactionsPerTransactionType(maxAggregateTransactionsPerTransactionType);
        }
        if (maxAggregateQueriesPerQueryType != null) {
            builder.maxAggregateQueriesPerQueryType(maxAggregateQueriesPerQueryType);
        }
        if (maxTraceEntriesPerTransaction != null) {
            builder.maxTraceEntriesPerTransaction(maxTraceEntriesPerTransaction);
        }
        if (maxStackTraceSamplesPerTransaction != null) {
            builder.maxStackTraceSamplesPerTransaction(maxStackTraceSamplesPerTransaction);
        }
        if (captureThreadInfo != null) {
            builder.captureThreadInfo(captureThreadInfo);
        }
        if (captureGcInfo != null) {
            builder.captureGcInfo(captureGcInfo);
        }
        if (mbeanGaugeNotFoundDelaySeconds != null) {
            builder.mbeanGaugeNotFoundDelaySeconds(mbeanGaugeNotFoundDelaySeconds);
        }
        if (internalQueryTimeoutSeconds != null) {
            builder.internalQueryTimeoutSeconds(internalQueryTimeoutSeconds);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static AdvancedConfigDto copyOf(ConfigJsonService.AdvancedConfigDtoBase instance) {
        if (instance instanceof AdvancedConfigDto) {
            return (AdvancedConfigDto)instance;
        }
        return AdvancedConfigDto.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 4095L;
        private static final long INITIALIZED_BIT_TIMER_WRAPPER_METHODS = 1L;
        private static final long INITIALIZED_BIT_WEAVING_TIMER = 2L;
        private static final long INITIALIZED_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS = 4L;
        private static final long INITIALIZED_BIT_MAX_AGGREGATE_TRANSACTIONS_PER_TRANSACTION_TYPE = 8L;
        private static final long INITIALIZED_BIT_MAX_AGGREGATE_QUERIES_PER_QUERY_TYPE = 16L;
        private static final long INITIALIZED_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION = 32L;
        private static final long INITIALIZED_BIT_MAX_STACK_TRACE_SAMPLES_PER_TRANSACTION = 64L;
        private static final long INITIALIZED_BIT_CAPTURE_THREAD_INFO = 128L;
        private static final long INITIALIZED_BIT_CAPTURE_GC_INFO = 256L;
        private static final long INITIALIZED_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS = 512L;
        private static final long INITIALIZED_BIT_INTERNAL_QUERY_TIMEOUT_SECONDS = 1024L;
        private static final long INITIALIZED_BIT_VERSION = 2048L;
        private long initializedBitset;
        private boolean timerWrapperMethods;
        private boolean weavingTimer;
        private int immediatePartialStoreThresholdSeconds;
        private int maxAggregateTransactionsPerTransactionType;
        private int maxAggregateQueriesPerQueryType;
        private int maxTraceEntriesPerTransaction;
        private int maxStackTraceSamplesPerTransaction;
        private boolean captureThreadInfo;
        private boolean captureGcInfo;
        private int mbeanGaugeNotFoundDelaySeconds;
        private int internalQueryTimeoutSeconds;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder all(ConfigJsonService.AdvancedConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.timerWrapperMethods(instance.timerWrapperMethods());
            this.weavingTimer(instance.weavingTimer());
            this.immediatePartialStoreThresholdSeconds(instance.immediatePartialStoreThresholdSeconds());
            this.maxAggregateTransactionsPerTransactionType(instance.maxAggregateTransactionsPerTransactionType());
            this.maxAggregateQueriesPerQueryType(instance.maxAggregateQueriesPerQueryType());
            this.maxTraceEntriesPerTransaction(instance.maxTraceEntriesPerTransaction());
            this.maxStackTraceSamplesPerTransaction(instance.maxStackTraceSamplesPerTransaction());
            this.captureThreadInfo(instance.captureThreadInfo());
            this.captureGcInfo(instance.captureGcInfo());
            this.mbeanGaugeNotFoundDelaySeconds(instance.mbeanGaugeNotFoundDelaySeconds());
            this.internalQueryTimeoutSeconds(instance.internalQueryTimeoutSeconds());
            this.version(instance.version());
            return this;
        }

        public final Builder timerWrapperMethods(boolean timerWrapperMethods) {
            this.timerWrapperMethods = timerWrapperMethods;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder weavingTimer(boolean weavingTimer) {
            this.weavingTimer = weavingTimer;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
            this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder maxAggregateTransactionsPerTransactionType(int maxAggregateTransactionsPerTransactionType) {
            this.maxAggregateTransactionsPerTransactionType = maxAggregateTransactionsPerTransactionType;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder maxAggregateQueriesPerQueryType(int maxAggregateQueriesPerQueryType) {
            this.maxAggregateQueriesPerQueryType = maxAggregateQueriesPerQueryType;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
            this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder maxStackTraceSamplesPerTransaction(int maxStackTraceSamplesPerTransaction) {
            this.maxStackTraceSamplesPerTransaction = maxStackTraceSamplesPerTransaction;
            this.initializedBitset |= 0x40L;
            return this;
        }

        public final Builder captureThreadInfo(boolean captureThreadInfo) {
            this.captureThreadInfo = captureThreadInfo;
            this.initializedBitset |= 0x80L;
            return this;
        }

        public final Builder captureGcInfo(boolean captureGcInfo) {
            this.captureGcInfo = captureGcInfo;
            this.initializedBitset |= 0x100L;
            return this;
        }

        public final Builder mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
            this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
            this.initializedBitset |= 0x200L;
            return this;
        }

        public final Builder internalQueryTimeoutSeconds(int internalQueryTimeoutSeconds) {
            this.internalQueryTimeoutSeconds = internalQueryTimeoutSeconds;
            this.initializedBitset |= 0x400L;
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x800L;
            return this;
        }

        public AdvancedConfigDto build() {
            this.checkRequiredAttributes();
            return new AdvancedConfigDto(this.timerWrapperMethods, this.weavingTimer, this.immediatePartialStoreThresholdSeconds, this.maxAggregateTransactionsPerTransactionType, this.maxAggregateQueriesPerQueryType, this.maxTraceEntriesPerTransaction, this.maxStackTraceSamplesPerTransaction, this.captureThreadInfo, this.captureGcInfo, this.mbeanGaugeNotFoundDelaySeconds, this.internalQueryTimeoutSeconds, this.version);
        }

        private boolean timerWrapperMethodsIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean weavingTimerIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean immediatePartialStoreThresholdSecondsIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean maxAggregateTransactionsPerTransactionTypeIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean maxAggregateQueriesPerQueryTypeIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean maxTraceEntriesPerTransactionIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean maxStackTraceSamplesPerTransactionIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private boolean captureThreadInfoIsSet() {
            return (this.initializedBitset & 0x80L) != 0L;
        }

        private boolean captureGcInfoIsSet() {
            return (this.initializedBitset & 0x100L) != 0L;
        }

        private boolean mbeanGaugeNotFoundDelaySecondsIsSet() {
            return (this.initializedBitset & 0x200L) != 0L;
        }

        private boolean internalQueryTimeoutSecondsIsSet() {
            return (this.initializedBitset & 0x400L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x800L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 4095L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.timerWrapperMethodsIsSet()) {
                attributes.add("timerWrapperMethods");
            }
            if (!this.weavingTimerIsSet()) {
                attributes.add("weavingTimer");
            }
            if (!this.immediatePartialStoreThresholdSecondsIsSet()) {
                attributes.add("immediatePartialStoreThresholdSeconds");
            }
            if (!this.maxAggregateTransactionsPerTransactionTypeIsSet()) {
                attributes.add("maxAggregateTransactionsPerTransactionType");
            }
            if (!this.maxAggregateQueriesPerQueryTypeIsSet()) {
                attributes.add("maxAggregateQueriesPerQueryType");
            }
            if (!this.maxTraceEntriesPerTransactionIsSet()) {
                attributes.add("maxTraceEntriesPerTransaction");
            }
            if (!this.maxStackTraceSamplesPerTransactionIsSet()) {
                attributes.add("maxStackTraceSamplesPerTransaction");
            }
            if (!this.captureThreadInfoIsSet()) {
                attributes.add("captureThreadInfo");
            }
            if (!this.captureGcInfoIsSet()) {
                attributes.add("captureGcInfo");
            }
            if (!this.mbeanGaugeNotFoundDelaySecondsIsSet()) {
                attributes.add("mbeanGaugeNotFoundDelaySeconds");
            }
            if (!this.internalQueryTimeoutSecondsIsSet()) {
                attributes.add("internalQueryTimeoutSeconds");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build AdvancedConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

