/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.JvmJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class Gauge
extends JvmJsonService.GaugeBase {
    private final String name;
    private final boolean everIncreasing;
    private final String display;

    private Gauge(String name, boolean everIncreasing, String display) {
        this.name = name;
        this.everIncreasing = everIncreasing;
        this.display = display;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="everIncreasing")
    public boolean everIncreasing() {
        return this.everIncreasing;
    }

    @Override
    @JsonProperty(value="display")
    public String display() {
        return this.display;
    }

    public final Gauge withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Gauge(newValue, this.everIncreasing, this.display);
    }

    public final Gauge withEverIncreasing(boolean value) {
        if (this.everIncreasing == value) {
            return this;
        }
        boolean newValue = value;
        return new Gauge(this.name, newValue, this.display);
    }

    public final Gauge withDisplay(String value) {
        if (this.display == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Gauge(this.name, this.everIncreasing, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Gauge && this.equalTo((Gauge)another);
    }

    private boolean equalTo(Gauge another) {
        return this.name.equals(another.name) && this.everIncreasing == another.everIncreasing && this.display.equals(another.display);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Booleans.hashCode(this.everIncreasing);
        h = h * 17 + this.display.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Gauge").add("name", this.name).add("everIncreasing", this.everIncreasing).add("display", this.display).toString();
    }

    @JsonCreator
    public static Gauge fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="everIncreasing") @Nullable Boolean everIncreasing, @JsonProperty(value="display") @Nullable String display) {
        Builder builder = Gauge.builder();
        if (name != null) {
            builder.name(name);
        }
        if (everIncreasing != null) {
            builder.everIncreasing(everIncreasing);
        }
        if (display != null) {
            builder.display(display);
        }
        return builder.build();
    }

    public static Gauge of(String name, boolean everIncreasing, String display) {
        return new Gauge(name, everIncreasing, display);
    }

    static Gauge copyOf(JvmJsonService.GaugeBase instance) {
        if (instance instanceof Gauge) {
            return (Gauge)instance;
        }
        return Gauge.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_EVER_INCREASING = 2L;
        private static final long INITIALIZED_BIT_DISPLAY = 4L;
        private long initializedBitset;
        @Nullable
        private String name;
        private boolean everIncreasing;
        @Nullable
        private String display;

        private Builder() {
        }

        public final Builder all(JvmJsonService.GaugeBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.everIncreasing(instance.everIncreasing());
            this.display(instance.display());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder everIncreasing(boolean everIncreasing) {
            this.everIncreasing = everIncreasing;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder display(String display) {
            this.display = Preconditions.checkNotNull(display);
            this.initializedBitset |= 4L;
            return this;
        }

        public Gauge build() {
            this.checkRequiredAttributes();
            return new Gauge(this.name, this.everIncreasing, this.display);
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean everIncreasingIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean displayIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.everIncreasingIsSet()) {
                attributes.add("everIncreasing");
            }
            if (!this.displayIsSet()) {
                attributes.add("display");
            }
            return "Cannot build Gauge, some of required attributes are not set " + attributes;
        }
    }
}

