/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import org.glowroot.collector.PatternObjectNameQueryExp;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.ConfigService;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.GaugeConfigBase;
import org.glowroot.config.MBeanAttribute;
import org.glowroot.jvm.LazyPlatformMBeanServer;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.GaugeConfigDto;
import org.glowroot.local.ui.GaugeConfigWithWarningMessages;
import org.glowroot.local.ui.GaugeResponse;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.JsonServiceException;
import org.glowroot.local.ui.MBeanAttributeNamesRequest;
import org.glowroot.local.ui.MBeanAttributeNamesResponse;
import org.glowroot.local.ui.MBeanObjectNameRequest;
import org.glowroot.local.ui.POST;
import org.glowroot.local.ui.QueryStrings;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class GaugeJsonService {
    private static final Logger logger = LoggerFactory.getLogger(GaugeJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final ConfigService configService;
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;

    GaugeJsonService(ConfigService configService, LazyPlatformMBeanServer lazyPlatformMBeanServer) {
        this.configService = configService;
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
    }

    @GET(value="/backend/config/gauges")
    String getGaugeConfigs() throws JsonProcessingException {
        ArrayList<GaugeConfigWithWarningMessages> responses = Lists.newArrayList();
        List<GaugeConfig> gaugeConfigs = this.configService.getGaugeConfigs();
        gaugeConfigs = GaugeConfig.orderingByName.immutableSortedCopy(gaugeConfigs);
        for (GaugeConfig gaugeConfig : gaugeConfigs) {
            responses.add(GaugeConfigWithWarningMessages.builder().config(GaugeConfigDtoBase.fromConfig(gaugeConfig)).build());
        }
        return mapper.writeValueAsString(responses);
    }

    @GET(value="/backend/config/gauges/([0-9a-f]{40})")
    String getGaugeConfig(String version) throws Exception {
        GaugeConfig gaugeConfig = this.configService.getGaugeConfig(version);
        if (gaugeConfig == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        return mapper.writeValueAsString(this.buildResponse(gaugeConfig));
    }

    @GET(value="/backend/config/matching-mbean-objects")
    String getMatchingMBeanObjects(String queryString) throws Exception {
        MBeanObjectNameRequest request = QueryStrings.decode(queryString, MBeanObjectNameRequest.class);
        Set<ObjectName> objectNames = this.lazyPlatformMBeanServer.queryNames(null, new ObjectNameQueryExp(request.partialMBeanObjectName()));
        ArrayList<String> names = Lists.newArrayList();
        for (ObjectName objectName : objectNames) {
            names.add(objectName.toString());
        }
        List sortedNames = Ordering.from(String.CASE_INSENSITIVE_ORDER).immutableSortedCopy(names);
        if (sortedNames.size() > request.limit()) {
            sortedNames = sortedNames.subList(0, request.limit());
        }
        return mapper.writeValueAsString(sortedNames);
    }

    @GET(value="/backend/config/mbean-attributes")
    String getMBeanAttributes(String queryString) throws Exception {
        MBeanAttributeNamesRequest request = QueryStrings.decode(queryString, MBeanAttributeNamesRequest.class);
        MBeanAttributeNamesResponse.Builder builder = MBeanAttributeNamesResponse.builder();
        for (GaugeConfig gaugeConfig : this.configService.getGaugeConfigs()) {
            if (!gaugeConfig.mbeanObjectName().equals(request.mbeanObjectName()) || gaugeConfig.version().equals(request.gaugeVersion())) continue;
            builder.duplicateMBean(true);
            break;
        }
        boolean pattern = request.mbeanObjectName().contains("*");
        Set<ObjectName> objectNames = this.getObjectNames(request.mbeanObjectName());
        if (objectNames.isEmpty() && pattern) {
            builder.mbeanUnmatched(true);
        } else if (objectNames.isEmpty()) {
            builder.mbeanUnavailable(true);
        } else {
            builder.addAllMbeanAttributes(this.getAttributeNames(objectNames));
        }
        return mapper.writeValueAsString(builder.build());
    }

    @POST(value="/backend/config/gauges/add")
    String addGauge(String content) throws Exception {
        GaugeConfigDto gaugeConfigDto = mapper.readValue(content, GaugeConfigDto.class);
        GaugeConfig gaugeConfig = gaugeConfigDto.toConfig();
        try {
            this.configService.insertGaugeConfig(gaugeConfig);
        }
        catch (ConfigService.DuplicateMBeanObjectNameException e) {
            logger.debug(e.getMessage(), e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "mbeanObjectName");
        }
        return mapper.writeValueAsString(this.buildResponse(gaugeConfig));
    }

    @POST(value="/backend/config/gauges/update")
    String updateGauge(String content) throws Exception {
        GaugeConfigDto gaugeConfigDto = mapper.readValue(content, GaugeConfigDto.class);
        GaugeConfig gaugeConfig = gaugeConfigDto.toConfig();
        String version = gaugeConfigDto.version();
        Preconditions.checkNotNull(version, "Missing required request property: version");
        try {
            this.configService.updateGaugeConfig(gaugeConfig, version);
        }
        catch (ConfigService.DuplicateMBeanObjectNameException e) {
            logger.debug(e.getMessage(), e);
            throw new JsonServiceException(HttpResponseStatus.CONFLICT, "mbeanObjectName");
        }
        return mapper.writeValueAsString(this.buildResponse(gaugeConfig));
    }

    @POST(value="/backend/config/gauges/remove")
    void removeGauge(String content) throws IOException {
        String version = mapper.readValue(content, String.class);
        Preconditions.checkNotNull(version);
        this.configService.deleteGaugeConfig(version);
    }

    private GaugeResponse buildResponse(GaugeConfig gaugeConfig) throws Exception {
        boolean pattern = gaugeConfig.mbeanObjectName().contains("*");
        Set<ObjectName> objectNames = this.getObjectNames(gaugeConfig.mbeanObjectName());
        GaugeResponse.Builder builder = GaugeResponse.builder().config(GaugeConfigDtoBase.fromConfig(gaugeConfig));
        if (objectNames.isEmpty() && pattern) {
            builder.mbeanUnmatched(true);
        } else if (objectNames.isEmpty()) {
            builder.mbeanUnavailable(true);
        } else {
            builder.addAllMbeanAvailableAttributeNames(this.getAttributeNames(objectNames));
        }
        return builder.build();
    }

    private Set<ObjectName> getObjectNames(String objectName) throws Exception {
        if (objectName.contains("*")) {
            return this.lazyPlatformMBeanServer.queryNames(null, new PatternObjectNameQueryExp(objectName));
        }
        return ImmutableSet.of(ObjectName.getInstance(objectName));
    }

    private Set<String> getAttributeNames(Set<ObjectName> objectNames) throws Exception {
        HashSet<String> attributeNames = Sets.newHashSet();
        for (ObjectName objectName : objectNames) {
            MBeanInfo mbeanInfo = this.lazyPlatformMBeanServer.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
                if (!attribute.isReadable()) continue;
                Object value = this.lazyPlatformMBeanServer.getAttribute(objectName, attribute.getName());
                GaugeJsonService.addNumericAttributes(attribute, value, attributeNames);
            }
        }
        return attributeNames;
    }

    private static void addNumericAttributes(MBeanAttributeInfo attribute, Object value, Set<String> attributeNames) {
        Descriptor descriptor;
        Object descriptorFieldValue;
        String attributeType = attribute.getType();
        if (attributeType.equals("long") || attributeType.equals("int") || attributeType.equals("double") || attributeType.equals("float")) {
            attributeNames.add(attribute.getName());
        } else if (attributeType.equals("java.lang.String") && value instanceof String) {
            try {
                Double.parseDouble((String)value);
                attributeNames.add(attribute.getName());
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
            }
        } else if (attributeType.equals(CompositeData.class.getName()) && (descriptorFieldValue = (descriptor = attribute.getDescriptor()).getFieldValue("openType")) instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)descriptorFieldValue;
            attributeNames.addAll(GaugeJsonService.getCompositeTypeAttributeNames(attribute, value, compositeType));
        }
    }

    private static List<String> getCompositeTypeAttributeNames(MBeanAttributeInfo attribute, Object compositeData, CompositeType compositeType) {
        ArrayList<String> attributeNames = Lists.newArrayList();
        for (String itemName : compositeType.keySet()) {
            Object val;
            Class<?> clazz;
            OpenType<?> itemType = compositeType.getType(itemName);
            if (itemType == null) continue;
            String className = itemType.getClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.warn(e.getMessage(), e);
                continue;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                attributeNames.add(attribute.getName() + '/' + itemName);
                continue;
            }
            if (clazz != String.class || !(compositeData instanceof CompositeData) || !((val = ((CompositeData)compositeData).get(itemName)) instanceof String)) continue;
            try {
                Double.parseDouble((String)val);
                attributeNames.add(attribute.getName() + '/' + itemName);
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return attributeNames;
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GaugeConfigDtoBase {
        GaugeConfigDtoBase() {
        }

        @Nullable
        abstract String display();

        abstract String mbeanObjectName();

        abstract ImmutableList<MBeanAttribute> mbeanAttributes();

        @Nullable
        abstract String version();

        private static GaugeConfigDto fromConfig(GaugeConfig gaugeConfig) {
            return GaugeConfigDto.builder().display(GaugeConfigBase.display(gaugeConfig.mbeanObjectName())).mbeanObjectName(gaugeConfig.mbeanObjectName()).addAllMbeanAttributes(gaugeConfig.mbeanAttributes()).version(gaugeConfig.version()).build();
        }

        GaugeConfig toConfig() {
            return GaugeConfig.builder().mbeanObjectName(this.mbeanObjectName()).addAllMbeanAttributes(this.mbeanAttributes()).build();
        }
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GaugeResponseBase {
        GaugeResponseBase() {
        }

        abstract GaugeConfigDto config();

        boolean mbeanUnavailable() {
            return false;
        }

        boolean mbeanUnmatched() {
            return false;
        }

        abstract ImmutableList<String> mbeanAvailableAttributeNames();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class MBeanAttributeNamesResponseBase {
        MBeanAttributeNamesResponseBase() {
        }

        boolean mbeanUnavailable() {
            return false;
        }

        boolean mbeanUnmatched() {
            return false;
        }

        boolean duplicateMBean() {
            return false;
        }

        abstract ImmutableList<String> mbeanAttributes();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class MBeanAttributeNamesRequestBase {
        MBeanAttributeNamesRequestBase() {
        }

        abstract String mbeanObjectName();

        @Nullable
        abstract String gaugeVersion();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class MBeanObjectNameRequestBase {
        MBeanObjectNameRequestBase() {
        }

        abstract String partialMBeanObjectName();

        abstract int limit();
    }

    @JsonSerialize
    @Value.Immutable
    static abstract class GaugeConfigWithWarningMessagesBase {
        GaugeConfigWithWarningMessagesBase() {
        }

        abstract GaugeConfigDto config();

        abstract ImmutableList<String> warningMessages();
    }

    private static class ObjectNameQueryExp
    implements QueryExp {
        private final String textUpper;

        private ObjectNameQueryExp(String text) {
            this.textUpper = text.toUpperCase(Locale.ENGLISH);
        }

        @Override
        public boolean apply(ObjectName name) {
            return name.toString().toUpperCase(Locale.ENGLISH).contains(this.textUpper);
        }

        @Override
        public void setMBeanServer(MBeanServer s) {
        }
    }
}

