/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.GaugeConfigDto;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class GaugeResponse
extends GaugeJsonService.GaugeResponseBase {
    private final GaugeConfigDto config;
    private final boolean mbeanUnavailable;
    private final boolean mbeanUnmatched;
    private final ImmutableList<String> mbeanAvailableAttributeNames;

    private GaugeResponse(Builder builder) {
        this.config = builder.config;
        this.mbeanAvailableAttributeNames = builder.mbeanAvailableAttributeNamesBuilder.build();
        this.mbeanUnavailable = builder.mbeanUnavailableIsSet() ? builder.mbeanUnavailable : super.mbeanUnavailable();
        this.mbeanUnmatched = builder.mbeanUnmatchedIsSet() ? builder.mbeanUnmatched : super.mbeanUnmatched();
    }

    private GaugeResponse(GaugeConfigDto config, boolean mbeanUnavailable, boolean mbeanUnmatched, ImmutableList<String> mbeanAvailableAttributeNames) {
        this.config = config;
        this.mbeanUnavailable = mbeanUnavailable;
        this.mbeanUnmatched = mbeanUnmatched;
        this.mbeanAvailableAttributeNames = mbeanAvailableAttributeNames;
    }

    @Override
    @JsonProperty(value="config")
    public GaugeConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="mbeanUnavailable")
    public boolean mbeanUnavailable() {
        return this.mbeanUnavailable;
    }

    @Override
    @JsonProperty(value="mbeanUnmatched")
    public boolean mbeanUnmatched() {
        return this.mbeanUnmatched;
    }

    @Override
    @JsonProperty(value="mbeanAvailableAttributeNames")
    public ImmutableList<String> mbeanAvailableAttributeNames() {
        return this.mbeanAvailableAttributeNames;
    }

    public final GaugeResponse withConfig(GaugeConfigDto value) {
        if (this.config == value) {
            return this;
        }
        GaugeConfigDto newValue = Preconditions.checkNotNull(value);
        return new GaugeResponse(newValue, this.mbeanUnavailable, this.mbeanUnmatched, this.mbeanAvailableAttributeNames);
    }

    public final GaugeResponse withMbeanUnavailable(boolean value) {
        if (this.mbeanUnavailable == value) {
            return this;
        }
        boolean newValue = value;
        return new GaugeResponse(this.config, newValue, this.mbeanUnmatched, this.mbeanAvailableAttributeNames);
    }

    public final GaugeResponse withMbeanUnmatched(boolean value) {
        if (this.mbeanUnmatched == value) {
            return this;
        }
        boolean newValue = value;
        return new GaugeResponse(this.config, this.mbeanUnavailable, newValue, this.mbeanAvailableAttributeNames);
    }

    public final GaugeResponse withMbeanAvailableAttributeNames(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugeResponse(this.config, this.mbeanUnavailable, this.mbeanUnmatched, newValue);
    }

    public final GaugeResponse withMbeanAvailableAttributeNames(Iterable<String> elements) {
        if (this.mbeanAvailableAttributeNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new GaugeResponse(this.config, this.mbeanUnavailable, this.mbeanUnmatched, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GaugeResponse && this.equalTo((GaugeResponse)another);
    }

    private boolean equalTo(GaugeResponse another) {
        return this.config.equals(another.config) && this.mbeanUnavailable == another.mbeanUnavailable && this.mbeanUnmatched == another.mbeanUnmatched && this.mbeanAvailableAttributeNames.equals(another.mbeanAvailableAttributeNames);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.config.hashCode();
        h = h * 17 + Booleans.hashCode(this.mbeanUnavailable);
        h = h * 17 + Booleans.hashCode(this.mbeanUnmatched);
        h = h * 17 + this.mbeanAvailableAttributeNames.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GaugeResponse").add("config", this.config).add("mbeanUnavailable", this.mbeanUnavailable).add("mbeanUnmatched", this.mbeanUnmatched).add("mbeanAvailableAttributeNames", this.mbeanAvailableAttributeNames).toString();
    }

    @JsonCreator
    public static GaugeResponse fromAllAttributes(@JsonProperty(value="config") @Nullable GaugeConfigDto config, @JsonProperty(value="mbeanUnavailable") @Nullable Boolean mbeanUnavailable, @JsonProperty(value="mbeanUnmatched") @Nullable Boolean mbeanUnmatched, @JsonProperty(value="mbeanAvailableAttributeNames") @Nullable ImmutableList<String> mbeanAvailableAttributeNames) {
        Builder builder = GaugeResponse.builder();
        if (config != null) {
            builder.config(config);
        }
        if (mbeanUnavailable != null) {
            builder.mbeanUnavailable(mbeanUnavailable);
        }
        if (mbeanUnmatched != null) {
            builder.mbeanUnmatched(mbeanUnmatched);
        }
        if (mbeanAvailableAttributeNames != null) {
            builder.addAllMbeanAvailableAttributeNames(mbeanAvailableAttributeNames);
        }
        return builder.build();
    }

    static GaugeResponse copyOf(GaugeJsonService.GaugeResponseBase instance) {
        if (instance instanceof GaugeResponse) {
            return (GaugeResponse)instance;
        }
        return GaugeResponse.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_CONFIG = 1L;
        private static final long NONDEFAULT_BIT_MBEAN_UNAVAILABLE = 1L;
        private static final long NONDEFAULT_BIT_MBEAN_UNMATCHED = 2L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private GaugeConfigDto config;
        private boolean mbeanUnavailable;
        private boolean mbeanUnmatched;
        private ImmutableList.Builder<String> mbeanAvailableAttributeNamesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(GaugeJsonService.GaugeResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.config(instance.config());
            this.mbeanUnavailable(instance.mbeanUnavailable());
            this.mbeanUnmatched(instance.mbeanUnmatched());
            this.addAllMbeanAvailableAttributeNames(instance.mbeanAvailableAttributeNames());
            return this;
        }

        public final Builder config(GaugeConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder mbeanUnavailable(boolean mbeanUnavailable) {
            this.mbeanUnavailable = mbeanUnavailable;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder mbeanUnmatched(boolean mbeanUnmatched) {
            this.mbeanUnmatched = mbeanUnmatched;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder addMbeanAvailableAttributeNames(String element) {
            this.mbeanAvailableAttributeNamesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMbeanAvailableAttributeNames(String ... elements) {
            this.mbeanAvailableAttributeNamesBuilder.add(elements);
            return this;
        }

        public final Builder mbeanAvailableAttributeNames(Iterable<String> elements) {
            this.mbeanAvailableAttributeNamesBuilder = ImmutableList.builder();
            return this.addAllMbeanAvailableAttributeNames(elements);
        }

        public final Builder addAllMbeanAvailableAttributeNames(Iterable<String> elements) {
            this.mbeanAvailableAttributeNamesBuilder.addAll((Iterable)elements);
            return this;
        }

        public GaugeResponse build() {
            this.checkRequiredAttributes();
            return new GaugeResponse(this);
        }

        private boolean mbeanUnavailableIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean mbeanUnmatchedIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            return "Cannot build GaugeResponse, some of required attributes are not set " + attributes;
        }
    }
}

