/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;

@ParametersAreNonnullByDefault
@Immutable
final class GeneralConfigDto
extends ConfigJsonService.GeneralConfigDtoBase {
    private final boolean enabled;
    private final int traceStoreThresholdMillis;
    private final int profilingIntervalMillis;
    private final String defaultDisplayedTransactionType;
    private final ImmutableList<Double> defaultDisplayedPercentiles;
    private final String version;

    private GeneralConfigDto(boolean enabled, int traceStoreThresholdMillis, int profilingIntervalMillis, String defaultDisplayedTransactionType, ImmutableList<Double> defaultDisplayedPercentiles, String version) {
        this.enabled = enabled;
        this.traceStoreThresholdMillis = traceStoreThresholdMillis;
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
        this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
        this.version = version;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="traceStoreThresholdMillis")
    public int traceStoreThresholdMillis() {
        return this.traceStoreThresholdMillis;
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="defaultDisplayedTransactionType")
    public String defaultDisplayedTransactionType() {
        return this.defaultDisplayedTransactionType;
    }

    @Override
    @JsonProperty(value="defaultDisplayedPercentiles")
    public ImmutableList<Double> defaultDisplayedPercentiles() {
        return this.defaultDisplayedPercentiles;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final GeneralConfigDto withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new GeneralConfigDto(newValue, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, this.version);
    }

    public final GeneralConfigDto withTraceStoreThresholdMillis(int value) {
        if (this.traceStoreThresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfigDto(this.enabled, newValue, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, this.version);
    }

    public final GeneralConfigDto withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, newValue, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, this.version);
    }

    public final GeneralConfigDto withDefaultDisplayedTransactionType(String value) {
        if (this.defaultDisplayedTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, newValue, this.defaultDisplayedPercentiles, this.version);
    }

    public final GeneralConfigDto withDefaultDisplayedPercentiles(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, newValue, this.version);
    }

    public final GeneralConfigDto withDefaultDisplayedPercentiles(Iterable<Double> elements) {
        if (this.defaultDisplayedPercentiles == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, newValue, this.version);
    }

    public final GeneralConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GeneralConfigDto && this.equalTo((GeneralConfigDto)another);
    }

    private boolean equalTo(GeneralConfigDto another) {
        return this.enabled == another.enabled && this.traceStoreThresholdMillis == another.traceStoreThresholdMillis && this.profilingIntervalMillis == another.profilingIntervalMillis && this.defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType) && this.defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.traceStoreThresholdMillis;
        h = h * 17 + this.profilingIntervalMillis;
        h = h * 17 + this.defaultDisplayedTransactionType.hashCode();
        h = h * 17 + this.defaultDisplayedPercentiles.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeneralConfigDto").add("enabled", this.enabled).add("traceStoreThresholdMillis", this.traceStoreThresholdMillis).add("profilingIntervalMillis", this.profilingIntervalMillis).add("defaultDisplayedTransactionType", this.defaultDisplayedTransactionType).add("defaultDisplayedPercentiles", this.defaultDisplayedPercentiles).add("version", this.version).toString();
    }

    @JsonCreator
    public static GeneralConfigDto fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="traceStoreThresholdMillis") @Nullable Integer traceStoreThresholdMillis, @JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType, @JsonProperty(value="defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = GeneralConfigDto.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (traceStoreThresholdMillis != null) {
            builder.traceStoreThresholdMillis(traceStoreThresholdMillis);
        }
        if (profilingIntervalMillis != null) {
            builder.profilingIntervalMillis(profilingIntervalMillis);
        }
        if (defaultDisplayedTransactionType != null) {
            builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
        }
        if (defaultDisplayedPercentiles != null) {
            builder.addAllDefaultDisplayedPercentiles(defaultDisplayedPercentiles);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static GeneralConfigDto copyOf(ConfigJsonService.GeneralConfigDtoBase instance) {
        if (instance instanceof GeneralConfigDto) {
            return (GeneralConfigDto)instance;
        }
        return GeneralConfigDto.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_ENABLED = 1L;
        private static final long INITIALIZED_BIT_TRACE_STORE_THRESHOLD_MILLIS = 2L;
        private static final long INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS = 4L;
        private static final long INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 8L;
        private static final long INITIALIZED_BIT_VERSION = 16L;
        private long initializedBitset;
        private boolean enabled;
        private int traceStoreThresholdMillis;
        private int profilingIntervalMillis;
        @Nullable
        private String defaultDisplayedTransactionType;
        private ImmutableList.Builder<Double> defaultDisplayedPercentilesBuilder = ImmutableList.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder all(ConfigJsonService.GeneralConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.enabled(instance.enabled());
            this.traceStoreThresholdMillis(instance.traceStoreThresholdMillis());
            this.profilingIntervalMillis(instance.profilingIntervalMillis());
            this.defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType());
            this.addAllDefaultDisplayedPercentiles(instance.defaultDisplayedPercentiles());
            this.version(instance.version());
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder traceStoreThresholdMillis(int traceStoreThresholdMillis) {
            this.traceStoreThresholdMillis = traceStoreThresholdMillis;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
            this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder addDefaultDisplayedPercentiles(double element) {
            this.defaultDisplayedPercentilesBuilder.add((Object)element);
            return this;
        }

        public final Builder addDefaultDisplayedPercentiles(double ... elements) {
            this.defaultDisplayedPercentilesBuilder.addAll(Doubles.asList(elements));
            return this;
        }

        public final Builder defaultDisplayedPercentiles(Iterable<Double> elements) {
            this.defaultDisplayedPercentilesBuilder = ImmutableList.builder();
            return this.addAllDefaultDisplayedPercentiles(elements);
        }

        public final Builder addAllDefaultDisplayedPercentiles(Iterable<Double> elements) {
            this.defaultDisplayedPercentilesBuilder.addAll((Iterable)elements);
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public GeneralConfigDto build() {
            this.checkRequiredAttributes();
            return new GeneralConfigDto(this.enabled, this.traceStoreThresholdMillis, this.profilingIntervalMillis, this.defaultDisplayedTransactionType, (ImmutableList)this.defaultDisplayedPercentilesBuilder.build(), this.version);
        }

        private boolean enabledIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean traceStoreThresholdMillisIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean defaultDisplayedTransactionTypeIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.enabledIsSet()) {
                attributes.add("enabled");
            }
            if (!this.traceStoreThresholdMillisIsSet()) {
                attributes.add("traceStoreThresholdMillis");
            }
            if (!this.profilingIntervalMillisIsSet()) {
                attributes.add("profilingIntervalMillis");
            }
            if (!this.defaultDisplayedTransactionTypeIsSet()) {
                attributes.add("defaultDisplayedTransactionType");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build GeneralConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

