/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationConfigDto;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class InstrumentationListResponse
extends InstrumentationJsonService.InstrumentationListResponseBase {
    private final ImmutableList<InstrumentationConfigDto> configs;
    private final boolean jvmOutOfSync;
    private final boolean jvmRetransformClassesSupported;

    private InstrumentationListResponse(ImmutableList<InstrumentationConfigDto> configs, boolean jvmOutOfSync, boolean jvmRetransformClassesSupported) {
        this.configs = configs;
        this.jvmOutOfSync = jvmOutOfSync;
        this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<InstrumentationConfigDto> configs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="jvmOutOfSync")
    public boolean jvmOutOfSync() {
        return this.jvmOutOfSync;
    }

    @Override
    @JsonProperty(value="jvmRetransformClassesSupported")
    public boolean jvmRetransformClassesSupported() {
        return this.jvmRetransformClassesSupported;
    }

    public final InstrumentationListResponse withConfigs(InstrumentationConfigDto ... elements) {
        ImmutableList<InstrumentationConfigDto> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationListResponse(newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
    }

    public final InstrumentationListResponse withConfigs(Iterable<? extends InstrumentationConfigDto> elements) {
        if (this.configs == elements) {
            return this;
        }
        ImmutableList<InstrumentationConfigDto> newValue = ImmutableList.copyOf(elements);
        return new InstrumentationListResponse(newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
    }

    public final InstrumentationListResponse withJvmOutOfSync(boolean value) {
        if (this.jvmOutOfSync == value) {
            return this;
        }
        boolean newValue = value;
        return new InstrumentationListResponse(this.configs, newValue, this.jvmRetransformClassesSupported);
    }

    public final InstrumentationListResponse withJvmRetransformClassesSupported(boolean value) {
        if (this.jvmRetransformClassesSupported == value) {
            return this;
        }
        boolean newValue = value;
        return new InstrumentationListResponse(this.configs, this.jvmOutOfSync, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof InstrumentationListResponse && this.equalTo((InstrumentationListResponse)another);
    }

    private boolean equalTo(InstrumentationListResponse another) {
        return this.configs.equals(another.configs) && this.jvmOutOfSync == another.jvmOutOfSync && this.jvmRetransformClassesSupported == another.jvmRetransformClassesSupported;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.configs.hashCode();
        h = h * 17 + Booleans.hashCode(this.jvmOutOfSync);
        h = h * 17 + Booleans.hashCode(this.jvmRetransformClassesSupported);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationListResponse").add("configs", this.configs).add("jvmOutOfSync", this.jvmOutOfSync).add("jvmRetransformClassesSupported", this.jvmRetransformClassesSupported).toString();
    }

    @JsonCreator
    public static InstrumentationListResponse fromAllAttributes(@JsonProperty(value="configs") @Nullable ImmutableList<InstrumentationConfigDto> configs, @JsonProperty(value="jvmOutOfSync") @Nullable Boolean jvmOutOfSync, @JsonProperty(value="jvmRetransformClassesSupported") @Nullable Boolean jvmRetransformClassesSupported) {
        Builder builder = InstrumentationListResponse.builder();
        if (configs != null) {
            builder.addAllConfigs(configs);
        }
        if (jvmOutOfSync != null) {
            builder.jvmOutOfSync(jvmOutOfSync);
        }
        if (jvmRetransformClassesSupported != null) {
            builder.jvmRetransformClassesSupported(jvmRetransformClassesSupported);
        }
        return builder.build();
    }

    static InstrumentationListResponse copyOf(InstrumentationJsonService.InstrumentationListResponseBase instance) {
        if (instance instanceof InstrumentationListResponse) {
            return (InstrumentationListResponse)instance;
        }
        return InstrumentationListResponse.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_JVM_OUT_OF_SYNC = 1L;
        private static final long INITIALIZED_BIT_JVM_RETRANSFORM_CLASSES_SUPPORTED = 2L;
        private long initializedBitset;
        private ImmutableList.Builder<InstrumentationConfigDto> configsBuilder = ImmutableList.builder();
        private boolean jvmOutOfSync;
        private boolean jvmRetransformClassesSupported;

        private Builder() {
        }

        public final Builder all(InstrumentationJsonService.InstrumentationListResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.addAllConfigs(instance.configs());
            this.jvmOutOfSync(instance.jvmOutOfSync());
            this.jvmRetransformClassesSupported(instance.jvmRetransformClassesSupported());
            return this;
        }

        public final Builder addConfigs(InstrumentationConfigDto element) {
            this.configsBuilder.add((Object)element);
            return this;
        }

        public final Builder addConfigs(InstrumentationConfigDto ... elements) {
            this.configsBuilder.add(elements);
            return this;
        }

        public final Builder configs(Iterable<? extends InstrumentationConfigDto> elements) {
            this.configsBuilder = ImmutableList.builder();
            return this.addAllConfigs(elements);
        }

        public final Builder addAllConfigs(Iterable<? extends InstrumentationConfigDto> elements) {
            this.configsBuilder.addAll(elements);
            return this;
        }

        public final Builder jvmOutOfSync(boolean jvmOutOfSync) {
            this.jvmOutOfSync = jvmOutOfSync;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder jvmRetransformClassesSupported(boolean jvmRetransformClassesSupported) {
            this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
            this.initializedBitset |= 2L;
            return this;
        }

        public InstrumentationListResponse build() {
            this.checkRequiredAttributes();
            return new InstrumentationListResponse((ImmutableList)this.configsBuilder.build(), this.jvmOutOfSync, this.jvmRetransformClassesSupported);
        }

        private boolean jvmOutOfSyncIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean jvmRetransformClassesSupportedIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.jvmOutOfSyncIsSet()) {
                attributes.add("jvmOutOfSync");
            }
            if (!this.jvmRetransformClassesSupportedIsSet()) {
                attributes.add("jvmRetransformClassesSupported");
            }
            return "Cannot build InstrumentationListResponse, some of required attributes are not set " + attributes;
        }
    }
}

