/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.HttpServerHandler;
import org.glowroot.local.ui.JsonServiceMapping;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class JsonServiceMatcher
extends HttpServerHandler.JsonServiceMatcherBase {
    private final JsonServiceMapping jsonServiceMapping;
    private final Matcher matcher;

    private JsonServiceMatcher(JsonServiceMapping jsonServiceMapping, Matcher matcher) {
        this.jsonServiceMapping = jsonServiceMapping;
        this.matcher = matcher;
    }

    @Override
    public JsonServiceMapping jsonServiceMapping() {
        return this.jsonServiceMapping;
    }

    @Override
    public Matcher matcher() {
        return this.matcher;
    }

    public final JsonServiceMatcher withJsonServiceMapping(JsonServiceMapping value) {
        if (this.jsonServiceMapping == value) {
            return this;
        }
        JsonServiceMapping newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMatcher(newValue, this.matcher);
    }

    public final JsonServiceMatcher withMatcher(Matcher value) {
        if (this.matcher == value) {
            return this;
        }
        Matcher newValue = Preconditions.checkNotNull(value);
        return new JsonServiceMatcher(this.jsonServiceMapping, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof JsonServiceMatcher && this.equalTo((JsonServiceMatcher)another);
    }

    private boolean equalTo(JsonServiceMatcher another) {
        return this.jsonServiceMapping.equals(another.jsonServiceMapping) && this.matcher.equals(another.matcher);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.jsonServiceMapping.hashCode();
        h = h * 17 + this.matcher.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JsonServiceMatcher").add("jsonServiceMapping", this.jsonServiceMapping).add("matcher", this.matcher).toString();
    }

    public static JsonServiceMatcher of(JsonServiceMapping jsonServiceMapping, Matcher matcher) {
        return new JsonServiceMatcher(jsonServiceMapping, matcher);
    }

    static JsonServiceMatcher copyOf(HttpServerHandler.JsonServiceMatcherBase instance) {
        if (instance instanceof JsonServiceMatcher) {
            return (JsonServiceMatcher)instance;
        }
        return JsonServiceMatcher.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_JSON_SERVICE_MAPPING = 1L;
        private static final long INITIALIZED_BIT_MATCHER = 2L;
        private long initializedBitset;
        @Nullable
        private JsonServiceMapping jsonServiceMapping;
        @Nullable
        private Matcher matcher;

        private Builder() {
        }

        public final Builder all(HttpServerHandler.JsonServiceMatcherBase instance) {
            Preconditions.checkNotNull(instance);
            this.jsonServiceMapping(instance.jsonServiceMapping());
            this.matcher(instance.matcher());
            return this;
        }

        public final Builder jsonServiceMapping(JsonServiceMapping jsonServiceMapping) {
            this.jsonServiceMapping = Preconditions.checkNotNull(jsonServiceMapping);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder matcher(Matcher matcher) {
            this.matcher = Preconditions.checkNotNull(matcher);
            this.initializedBitset |= 2L;
            return this;
        }

        public JsonServiceMatcher build() {
            this.checkRequiredAttributes();
            return new JsonServiceMatcher(this.jsonServiceMapping, this.matcher);
        }

        private boolean jsonServiceMappingIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean matcherIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.jsonServiceMappingIsSet()) {
                attributes.add("jsonServiceMapping");
            }
            if (!this.matcherIsSet()) {
                attributes.add("matcher");
            }
            return "Cannot build JsonServiceMatcher, some of required attributes are not set " + attributes;
        }
    }
}

