/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.GaugeJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MBeanAttributeNamesRequest
extends GaugeJsonService.MBeanAttributeNamesRequestBase {
    private final String mbeanObjectName;
    @Nullable
    private final String gaugeVersion;

    private MBeanAttributeNamesRequest(String mbeanObjectName, @Nullable String gaugeVersion) {
        this.mbeanObjectName = mbeanObjectName;
        this.gaugeVersion = gaugeVersion;
    }

    @Override
    @JsonProperty(value="mbeanObjectName")
    public String mbeanObjectName() {
        return this.mbeanObjectName;
    }

    @Override
    @JsonProperty(value="gaugeVersion")
    public String gaugeVersion() {
        return this.gaugeVersion;
    }

    public final MBeanAttributeNamesRequest withMbeanObjectName(String value) {
        if (this.mbeanObjectName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MBeanAttributeNamesRequest(newValue, this.gaugeVersion);
    }

    public final MBeanAttributeNamesRequest withGaugeVersion(@Nullable String value) {
        if (this.gaugeVersion == value) {
            return this;
        }
        String newValue = value;
        return new MBeanAttributeNamesRequest(this.mbeanObjectName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MBeanAttributeNamesRequest && this.equalTo((MBeanAttributeNamesRequest)another);
    }

    private boolean equalTo(MBeanAttributeNamesRequest another) {
        return this.mbeanObjectName.equals(another.mbeanObjectName) && Objects.equal(this.gaugeVersion, another.gaugeVersion);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.mbeanObjectName.hashCode();
        h = h * 17 + Objects.hashCode(this.gaugeVersion);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MBeanAttributeNamesRequest").add("mbeanObjectName", this.mbeanObjectName).add("gaugeVersion", this.gaugeVersion).toString();
    }

    @JsonCreator
    public static MBeanAttributeNamesRequest fromAllAttributes(@JsonProperty(value="mbeanObjectName") @Nullable String mbeanObjectName, @JsonProperty(value="gaugeVersion") @Nullable String gaugeVersion) {
        Builder builder = MBeanAttributeNamesRequest.builder();
        if (mbeanObjectName != null) {
            builder.mbeanObjectName(mbeanObjectName);
        }
        if (gaugeVersion != null) {
            builder.gaugeVersion(gaugeVersion);
        }
        return builder.build();
    }

    static MBeanAttributeNamesRequest copyOf(GaugeJsonService.MBeanAttributeNamesRequestBase instance) {
        if (instance instanceof MBeanAttributeNamesRequest) {
            return (MBeanAttributeNamesRequest)instance;
        }
        return MBeanAttributeNamesRequest.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 1L;
        private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 1L;
        private long initializedBitset;
        @Nullable
        private String mbeanObjectName;
        @Nullable
        private String gaugeVersion;

        private Builder() {
        }

        public final Builder all(GaugeJsonService.MBeanAttributeNamesRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.mbeanObjectName(instance.mbeanObjectName());
            String gaugeVersionValue = instance.gaugeVersion();
            if (gaugeVersionValue != null) {
                this.gaugeVersion(gaugeVersionValue);
            }
            return this;
        }

        public final Builder mbeanObjectName(String mbeanObjectName) {
            this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder gaugeVersion(@Nullable String gaugeVersion) {
            this.gaugeVersion = gaugeVersion;
            return this;
        }

        public MBeanAttributeNamesRequest build() {
            this.checkRequiredAttributes();
            return new MBeanAttributeNamesRequest(this.mbeanObjectName, this.gaugeVersion);
        }

        private boolean mbeanObjectNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 1L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.mbeanObjectNameIsSet()) {
                attributes.add("mbeanObjectName");
            }
            return "Cannot build MBeanAttributeNamesRequest, some of required attributes are not set " + attributes;
        }
    }
}

