/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MethodNamesRequest
extends InstrumentationJsonService.MethodNamesRequestBase {
    private final String className;
    private final String partialMethodName;
    private final int limit;

    private MethodNamesRequest(String className, String partialMethodName, int limit) {
        this.className = className;
        this.partialMethodName = partialMethodName;
        this.limit = limit;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public String partialMethodName() {
        return this.partialMethodName;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    public final MethodNamesRequest withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodNamesRequest(newValue, this.partialMethodName, this.limit);
    }

    public final MethodNamesRequest withPartialMethodName(String value) {
        if (this.partialMethodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodNamesRequest(this.className, newValue, this.limit);
    }

    public final MethodNamesRequest withLimit(int value) {
        if (this.limit == value) {
            return this;
        }
        int newValue = value;
        return new MethodNamesRequest(this.className, this.partialMethodName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MethodNamesRequest && this.equalTo((MethodNamesRequest)another);
    }

    private boolean equalTo(MethodNamesRequest another) {
        return this.className.equals(another.className) && this.partialMethodName.equals(another.partialMethodName) && this.limit == another.limit;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + this.partialMethodName.hashCode();
        h = h * 17 + this.limit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodNamesRequest").add("className", this.className).add("partialMethodName", this.partialMethodName).add("limit", this.limit).toString();
    }

    static MethodNamesRequest copyOf(InstrumentationJsonService.MethodNamesRequestBase instance) {
        if (instance instanceof MethodNamesRequest) {
            return (MethodNamesRequest)instance;
        }
        return MethodNamesRequest.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_PARTIAL_METHOD_NAME = 2L;
        private static final long INITIALIZED_BIT_LIMIT = 4L;
        private long initializedBitset;
        @Nullable
        private String className;
        @Nullable
        private String partialMethodName;
        private int limit;

        private Builder() {
        }

        public final Builder all(InstrumentationJsonService.MethodNamesRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.className(instance.className());
            this.partialMethodName(instance.partialMethodName());
            this.limit(instance.limit());
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder partialMethodName(String partialMethodName) {
            this.partialMethodName = Preconditions.checkNotNull(partialMethodName);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder limit(int limit) {
            this.limit = limit;
            this.initializedBitset |= 4L;
            return this;
        }

        public MethodNamesRequest build() {
            this.checkRequiredAttributes();
            return new MethodNamesRequest(this.className, this.partialMethodName, this.limit);
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean partialMethodNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean limitIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            if (!this.partialMethodNameIsSet()) {
                attributes.add("partialMethodName");
            }
            if (!this.limitIsSet()) {
                attributes.add("limit");
            }
            return "Cannot build MethodNamesRequest, some of required attributes are not set " + attributes;
        }
    }
}

