/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.InstrumentationJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class MethodSignaturesRequest
extends InstrumentationJsonService.MethodSignaturesRequestBase {
    private final String className;
    private final String methodName;

    private MethodSignaturesRequest(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    @JsonProperty(value="className")
    public String className() {
        return this.className;
    }

    @Override
    @JsonProperty(value="methodName")
    public String methodName() {
        return this.methodName;
    }

    public final MethodSignaturesRequest withClassName(String value) {
        if (this.className == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodSignaturesRequest(newValue, this.methodName);
    }

    public final MethodSignaturesRequest withMethodName(String value) {
        if (this.methodName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new MethodSignaturesRequest(this.className, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MethodSignaturesRequest && this.equalTo((MethodSignaturesRequest)another);
    }

    private boolean equalTo(MethodSignaturesRequest another) {
        return this.className.equals(another.className) && this.methodName.equals(another.methodName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.className.hashCode();
        h = h * 17 + this.methodName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodSignaturesRequest").add("className", this.className).add("methodName", this.methodName).toString();
    }

    @JsonCreator
    public static MethodSignaturesRequest fromAllAttributes(@JsonProperty(value="className") @Nullable String className, @JsonProperty(value="methodName") @Nullable String methodName) {
        Builder builder = MethodSignaturesRequest.builder();
        if (className != null) {
            builder.className(className);
        }
        if (methodName != null) {
            builder.methodName(methodName);
        }
        return builder.build();
    }

    static MethodSignaturesRequest copyOf(InstrumentationJsonService.MethodSignaturesRequestBase instance) {
        if (instance instanceof MethodSignaturesRequest) {
            return (MethodSignaturesRequest)instance;
        }
        return MethodSignaturesRequest.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_CLASS_NAME = 1L;
        private static final long INITIALIZED_BIT_METHOD_NAME = 2L;
        private long initializedBitset;
        @Nullable
        private String className;
        @Nullable
        private String methodName;

        private Builder() {
        }

        public final Builder all(InstrumentationJsonService.MethodSignaturesRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.className(instance.className());
            this.methodName(instance.methodName());
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Preconditions.checkNotNull(methodName);
            this.initializedBitset |= 2L;
            return this;
        }

        public MethodSignaturesRequest build() {
            this.checkRequiredAttributes();
            return new MethodSignaturesRequest(this.className, this.methodName);
        }

        private boolean classNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean methodNameIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            if (!this.methodNameIsSet()) {
                attributes.add("methodName");
            }
            return "Cannot build MethodSignaturesRequest, some of required attributes are not set " + attributes;
        }
    }
}

