/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class PercentileValue
extends AggregateMerging.PercentileValueBase {
    private final String dataSeriesName;
    private final long value;

    private PercentileValue(String dataSeriesName, long value) {
        this.dataSeriesName = dataSeriesName;
        this.value = value;
    }

    @Override
    @JsonProperty(value="dataSeriesName")
    public String dataSeriesName() {
        return this.dataSeriesName;
    }

    @Override
    @JsonProperty(value="value")
    public long value() {
        return this.value;
    }

    public final PercentileValue withDataSeriesName(String value) {
        if (this.dataSeriesName == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PercentileValue(newValue, this.value);
    }

    public final PercentileValue withValue(long value) {
        if (this.value == value) {
            return this;
        }
        long newValue = value;
        return new PercentileValue(this.dataSeriesName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PercentileValue && this.equalTo((PercentileValue)another);
    }

    private boolean equalTo(PercentileValue another) {
        return this.dataSeriesName.equals(another.dataSeriesName) && this.value == another.value;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.dataSeriesName.hashCode();
        h = h * 17 + Longs.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PercentileValue").add("dataSeriesName", this.dataSeriesName).add("value", this.value).toString();
    }

    @JsonCreator
    public static PercentileValue fromAllAttributes(@JsonProperty(value="dataSeriesName") @Nullable String dataSeriesName, @JsonProperty(value="value") @Nullable Long value) {
        Builder builder = PercentileValue.builder();
        if (dataSeriesName != null) {
            builder.dataSeriesName(dataSeriesName);
        }
        if (value != null) {
            builder.value(value);
        }
        return builder.build();
    }

    public static PercentileValue of(String dataSeriesName, long value) {
        return new PercentileValue(dataSeriesName, value);
    }

    public static PercentileValue copyOf(AggregateMerging.PercentileValueBase instance) {
        if (instance instanceof PercentileValue) {
            return (PercentileValue)instance;
        }
        return PercentileValue.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_DATA_SERIES_NAME = 1L;
        private static final long INITIALIZED_BIT_VALUE = 2L;
        private long initializedBitset;
        @Nullable
        private String dataSeriesName;
        private long value;

        private Builder() {
        }

        public final Builder all(AggregateMerging.PercentileValueBase instance) {
            Preconditions.checkNotNull(instance);
            this.dataSeriesName(instance.dataSeriesName());
            this.value(instance.value());
            return this;
        }

        public final Builder dataSeriesName(String dataSeriesName) {
            this.dataSeriesName = Preconditions.checkNotNull(dataSeriesName);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder value(long value) {
            this.value = value;
            this.initializedBitset |= 2L;
            return this;
        }

        public PercentileValue build() {
            this.checkRequiredAttributes();
            return new PercentileValue(this.dataSeriesName, this.value);
        }

        private boolean dataSeriesNameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean valueIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.dataSeriesNameIsSet()) {
                attributes.add("dataSeriesName");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build PercentileValue, some of required attributes are not set " + attributes;
        }
    }
}

