/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PropertyValue;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class PluginConfigDto
extends ConfigJsonService.PluginConfigDtoBase {
    private final boolean enabled;
    private final ImmutableMap<String, PropertyValue> properties;
    private final String version;

    private PluginConfigDto(boolean enabled, ImmutableMap<String, PropertyValue> properties, String version) {
        this.enabled = enabled;
        this.properties = properties;
        this.version = version;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @JsonProperty(value="properties")
    public ImmutableMap<String, PropertyValue> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final PluginConfigDto withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new PluginConfigDto(newValue, this.properties, this.version);
    }

    public final PluginConfigDto withProperties(Map<String, ? extends PropertyValue> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
        return new PluginConfigDto(this.enabled, newValue, this.version);
    }

    public final PluginConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginConfigDto(this.enabled, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginConfigDto && this.equalTo((PluginConfigDto)another);
    }

    private boolean equalTo(PluginConfigDto another) {
        return this.enabled == another.enabled && this.properties.equals(another.properties) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.properties.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginConfigDto").add("enabled", this.enabled).add("properties", this.properties).add("version", this.version).toString();
    }

    @JsonCreator
    public static PluginConfigDto fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="properties") @Nullable Map<String, PropertyValue> properties, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = PluginConfigDto.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (properties != null) {
            builder.putAllProperties(properties);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static PluginConfigDto copyOf(ConfigJsonService.PluginConfigDtoBase instance) {
        if (instance instanceof PluginConfigDto) {
            return (PluginConfigDto)instance;
        }
        return PluginConfigDto.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_ENABLED = 1L;
        private static final long INITIALIZED_BIT_VERSION = 2L;
        private long initializedBitset;
        private boolean enabled;
        private ImmutableMap.Builder<String, PropertyValue> propertiesBuilder = ImmutableMap.builder();
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder all(ConfigJsonService.PluginConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.enabled(instance.enabled());
            this.putAllProperties(instance.properties());
            this.version(instance.version());
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder putProperties(String key, PropertyValue value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
            this.propertiesBuilder.put(entry);
            return this;
        }

        public final Builder properties(Map<String, ? extends PropertyValue> entries) {
            this.propertiesBuilder = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
            this.propertiesBuilder.putAll(entries);
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 2L;
            return this;
        }

        public PluginConfigDto build() {
            this.checkRequiredAttributes();
            return new PluginConfigDto(this.enabled, this.propertiesBuilder.build(), this.version);
        }

        private boolean enabledIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.enabledIsSet()) {
                attributes.add("enabled");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build PluginConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

