/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.local.ui.PluginConfigDto;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class PluginConfigResponse
extends ConfigJsonService.PluginConfigResponseBase {
    private final String name;
    private final PluginConfigDto config;
    private final ImmutableList<PropertyDescriptor> propertyDescriptors;

    private PluginConfigResponse(String name, PluginConfigDto config, ImmutableList<PropertyDescriptor> propertyDescriptors) {
        this.name = name;
        this.config = config;
        this.propertyDescriptors = propertyDescriptors;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public PluginConfigDto config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="propertyDescriptors")
    public ImmutableList<PropertyDescriptor> propertyDescriptors() {
        return this.propertyDescriptors;
    }

    public final PluginConfigResponse withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new PluginConfigResponse(newValue, this.config, this.propertyDescriptors);
    }

    public final PluginConfigResponse withConfig(PluginConfigDto value) {
        if (this.config == value) {
            return this;
        }
        PluginConfigDto newValue = Preconditions.checkNotNull(value);
        return new PluginConfigResponse(this.name, newValue, this.propertyDescriptors);
    }

    public final PluginConfigResponse withPropertyDescriptors(PropertyDescriptor ... elements) {
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginConfigResponse(this.name, this.config, newValue);
    }

    public final PluginConfigResponse withPropertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
        if (this.propertyDescriptors == elements) {
            return this;
        }
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new PluginConfigResponse(this.name, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof PluginConfigResponse && this.equalTo((PluginConfigResponse)another);
    }

    private boolean equalTo(PluginConfigResponse another) {
        return this.name.equals(another.name) && this.config.equals(another.config) && this.propertyDescriptors.equals(another.propertyDescriptors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.propertyDescriptors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginConfigResponse").add("name", this.name).add("config", this.config).add("propertyDescriptors", this.propertyDescriptors).toString();
    }

    @JsonCreator
    public static PluginConfigResponse fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="config") @Nullable PluginConfigDto config, @JsonProperty(value="propertyDescriptors") @Nullable ImmutableList<PropertyDescriptor> propertyDescriptors) {
        Builder builder = PluginConfigResponse.builder();
        if (name != null) {
            builder.name(name);
        }
        if (config != null) {
            builder.config(config);
        }
        if (propertyDescriptors != null) {
            builder.addAllPropertyDescriptors(propertyDescriptors);
        }
        return builder.build();
    }

    static PluginConfigResponse copyOf(ConfigJsonService.PluginConfigResponseBase instance) {
        if (instance instanceof PluginConfigResponse) {
            return (PluginConfigResponse)instance;
        }
        return PluginConfigResponse.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_CONFIG = 2L;
        private long initializedBitset;
        @Nullable
        private String name;
        @Nullable
        private PluginConfigDto config;
        private ImmutableList.Builder<PropertyDescriptor> propertyDescriptorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder all(ConfigJsonService.PluginConfigResponseBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.config(instance.config());
            this.addAllPropertyDescriptors(instance.propertyDescriptors());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder config(PluginConfigDto config) {
            this.config = Preconditions.checkNotNull(config);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addPropertyDescriptors(PropertyDescriptor element) {
            this.propertyDescriptorsBuilder.add((Object)element);
            return this;
        }

        public final Builder addPropertyDescriptors(PropertyDescriptor ... elements) {
            this.propertyDescriptorsBuilder.add(elements);
            return this;
        }

        public final Builder propertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
            this.propertyDescriptorsBuilder = ImmutableList.builder();
            return this.addAllPropertyDescriptors(elements);
        }

        public final Builder addAllPropertyDescriptors(Iterable<? extends PropertyDescriptor> elements) {
            this.propertyDescriptorsBuilder.addAll(elements);
            return this;
        }

        public PluginConfigResponse build() {
            this.checkRequiredAttributes();
            return new PluginConfigResponse(this.name, this.config, (ImmutableList)this.propertyDescriptorsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean configIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            return "Cannot build PluginConfigResponse, some of required attributes are not set " + attributes;
        }
    }
}

