/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.common.Reflections;
import org.glowroot.shaded.google.common.base.CaseFormat;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.cache.CacheBuilder;
import org.glowroot.shaded.google.common.cache.CacheLoader;
import org.glowroot.shaded.google.common.cache.LoadingCache;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.netty.handler.codec.http.QueryStringDecoder;

class QueryStrings {
    private static LoadingCache<Class<?>, Map<String, Method>> settersCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Map<String, Method>>(){

        @Override
        public Map<String, Method> load(Class<?> key) throws Exception {
            return QueryStrings.loadSetters(key);
        }
    });

    private QueryStrings() {
    }

    static <T> T decode(String queryString, Class<T> clazz) throws Exception {
        Method builderMethod = Reflections.getDeclaredMethod(clazz, "builder", new Class[0]);
        Object builder = Reflections.invokeStatic(builderMethod, new Object[0]);
        Preconditions.checkNotNull(builder);
        Class<?> immutableBuilderClass = builder.getClass();
        Map<String, Method> setters = settersCache.getUnchecked(immutableBuilderClass);
        QueryStringDecoder decoder = new QueryStringDecoder('?' + queryString);
        for (Map.Entry<String, List<String>> entry : decoder.parameters().entrySet()) {
            ArrayList<Object> value;
            String key = entry.getKey();
            key = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, key);
            key = key.replace("Mbean", "MBean");
            Method setter = setters.get(key);
            Preconditions.checkNotNull(setter, "Unexpected attribute: %s", key);
            Type valueType = setter.getGenericParameterTypes()[0];
            if (valueType instanceof ParameterizedType) {
                valueType = ((ParameterizedType)valueType).getActualTypeArguments()[0];
                ArrayList<Object> parsedValues = Lists.newArrayList();
                for (String stringValue : entry.getValue()) {
                    Object parsedValue = QueryStrings.parseString(stringValue, (Class)valueType);
                    if (parsedValue == null) continue;
                    parsedValues.add(parsedValue);
                }
                value = parsedValues;
            } else {
                value = QueryStrings.parseString(entry.getValue().get(0), (Class)valueType);
            }
            Reflections.invoke(setter, builder, value);
        }
        Method build = Reflections.getDeclaredMethod(immutableBuilderClass, "build", new Class[0]);
        Object decoded = Reflections.invoke(build, builder, new Object[0]);
        return (T)decoded;
    }

    @Nullable
    private static Object parseString(String str, Class<?> targetClass) {
        if (str.equals("")) {
            return null;
        }
        if (targetClass == String.class) {
            return str;
        }
        if (QueryStrings.isInteger(targetClass)) {
            return (int)Double.parseDouble(str);
        }
        if (QueryStrings.isLong(targetClass)) {
            return (long)Double.parseDouble(str);
        }
        if (QueryStrings.isDouble(targetClass)) {
            return Double.parseDouble(str);
        }
        if (QueryStrings.isBoolean(targetClass)) {
            return Boolean.parseBoolean(str);
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            Object enumValue = Enum.valueOf(targetClass, str.replace('-', '_').toUpperCase(Locale.ENGLISH));
            return enumValue;
        }
        throw new IllegalStateException("Unexpected class: " + targetClass);
    }

    private static boolean isInteger(Class<?> targetClass) {
        return targetClass == Integer.TYPE || targetClass == Integer.class;
    }

    private static boolean isLong(Class<?> targetClass) {
        return targetClass == Long.TYPE || targetClass == Long.class;
    }

    private static boolean isDouble(Class<?> targetClass) {
        return targetClass == Double.TYPE || targetClass == Double.class;
    }

    private static boolean isBoolean(Class<?> targetClass) {
        return targetClass == Boolean.TYPE || targetClass == Boolean.class;
    }

    private static Map<String, Method> loadSetters(Class<?> immutableBuilderClass) {
        HashMap<String, Method> setters = Maps.newHashMap();
        for (Method method : immutableBuilderClass.getMethods()) {
            if (method.getName().startsWith("add") && !method.getName().startsWith("addAll") || method.getParameterTypes().length != 1 || !QueryStrings.isSimpleSetter(method.getParameterTypes()[0])) continue;
            method.setAccessible(true);
            if (method.getName().startsWith("addAll")) {
                String propertyName = method.getName().substring(6);
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                setters.put(propertyName, method);
                continue;
            }
            setters.put(method.getName(), method);
        }
        return setters;
    }

    private static boolean isSimpleSetter(Class<?> targetClass) {
        return targetClass == String.class || QueryStrings.isInteger(targetClass) || QueryStrings.isLong(targetClass) || QueryStrings.isDouble(targetClass) || QueryStrings.isBoolean(targetClass) || Enum.class.isAssignableFrom(targetClass) || targetClass == Iterable.class;
    }
}

