/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class StorageConfigDto
extends ConfigJsonService.StorageConfigDtoBase {
    private final int aggregateExpirationHours;
    private final int traceExpirationHours;
    private final int gaugeExpirationHours;
    private final int cappedDatabaseSizeMb;
    private final String version;

    private StorageConfigDto(int aggregateExpirationHours, int traceExpirationHours, int gaugeExpirationHours, int cappedDatabaseSizeMb, String version) {
        this.aggregateExpirationHours = aggregateExpirationHours;
        this.traceExpirationHours = traceExpirationHours;
        this.gaugeExpirationHours = gaugeExpirationHours;
        this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
        this.version = version;
    }

    @Override
    @JsonProperty(value="aggregateExpirationHours")
    public int aggregateExpirationHours() {
        return this.aggregateExpirationHours;
    }

    @Override
    @JsonProperty(value="traceExpirationHours")
    public int traceExpirationHours() {
        return this.traceExpirationHours;
    }

    @Override
    @JsonProperty(value="gaugeExpirationHours")
    public int gaugeExpirationHours() {
        return this.gaugeExpirationHours;
    }

    @Override
    @JsonProperty(value="cappedDatabaseSizeMb")
    public int cappedDatabaseSizeMb() {
        return this.cappedDatabaseSizeMb;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final StorageConfigDto withAggregateExpirationHours(int value) {
        if (this.aggregateExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(newValue, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withTraceExpirationHours(int value) {
        if (this.traceExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(this.aggregateExpirationHours, newValue, this.gaugeExpirationHours, this.cappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withGaugeExpirationHours(int value) {
        if (this.gaugeExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(this.aggregateExpirationHours, this.traceExpirationHours, newValue, this.cappedDatabaseSizeMb, this.version);
    }

    public final StorageConfigDto withCappedDatabaseSizeMb(int value) {
        if (this.cappedDatabaseSizeMb == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfigDto(this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, newValue, this.version);
    }

    public final StorageConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new StorageConfigDto(this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof StorageConfigDto && this.equalTo((StorageConfigDto)another);
    }

    private boolean equalTo(StorageConfigDto another) {
        return this.aggregateExpirationHours == another.aggregateExpirationHours && this.traceExpirationHours == another.traceExpirationHours && this.gaugeExpirationHours == another.gaugeExpirationHours && this.cappedDatabaseSizeMb == another.cappedDatabaseSizeMb && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.aggregateExpirationHours;
        h = h * 17 + this.traceExpirationHours;
        h = h * 17 + this.gaugeExpirationHours;
        h = h * 17 + this.cappedDatabaseSizeMb;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StorageConfigDto").add("aggregateExpirationHours", this.aggregateExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("gaugeExpirationHours", this.gaugeExpirationHours).add("cappedDatabaseSizeMb", this.cappedDatabaseSizeMb).add("version", this.version).toString();
    }

    @JsonCreator
    public static StorageConfigDto fromAllAttributes(@JsonProperty(value="aggregateExpirationHours") @Nullable Integer aggregateExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="gaugeExpirationHours") @Nullable Integer gaugeExpirationHours, @JsonProperty(value="cappedDatabaseSizeMb") @Nullable Integer cappedDatabaseSizeMb, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = StorageConfigDto.builder();
        if (aggregateExpirationHours != null) {
            builder.aggregateExpirationHours(aggregateExpirationHours);
        }
        if (traceExpirationHours != null) {
            builder.traceExpirationHours(traceExpirationHours);
        }
        if (gaugeExpirationHours != null) {
            builder.gaugeExpirationHours(gaugeExpirationHours);
        }
        if (cappedDatabaseSizeMb != null) {
            builder.cappedDatabaseSizeMb(cappedDatabaseSizeMb);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static StorageConfigDto copyOf(ConfigJsonService.StorageConfigDtoBase instance) {
        if (instance instanceof StorageConfigDto) {
            return (StorageConfigDto)instance;
        }
        return StorageConfigDto.builder().all(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_AGGREGATE_EXPIRATION_HOURS = 1L;
        private static final long INITIALIZED_BIT_TRACE_EXPIRATION_HOURS = 2L;
        private static final long INITIALIZED_BIT_GAUGE_EXPIRATION_HOURS = 4L;
        private static final long INITIALIZED_BIT_CAPPED_DATABASE_SIZE_MB = 8L;
        private static final long INITIALIZED_BIT_VERSION = 16L;
        private long initializedBitset;
        private int aggregateExpirationHours;
        private int traceExpirationHours;
        private int gaugeExpirationHours;
        private int cappedDatabaseSizeMb;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder all(ConfigJsonService.StorageConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.aggregateExpirationHours(instance.aggregateExpirationHours());
            this.traceExpirationHours(instance.traceExpirationHours());
            this.gaugeExpirationHours(instance.gaugeExpirationHours());
            this.cappedDatabaseSizeMb(instance.cappedDatabaseSizeMb());
            this.version(instance.version());
            return this;
        }

        public final Builder aggregateExpirationHours(int aggregateExpirationHours) {
            this.aggregateExpirationHours = aggregateExpirationHours;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder traceExpirationHours(int traceExpirationHours) {
            this.traceExpirationHours = traceExpirationHours;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder gaugeExpirationHours(int gaugeExpirationHours) {
            this.gaugeExpirationHours = gaugeExpirationHours;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder cappedDatabaseSizeMb(int cappedDatabaseSizeMb) {
            this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 0x10L;
            return this;
        }

        public StorageConfigDto build() {
            this.checkRequiredAttributes();
            return new StorageConfigDto(this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb, this.version);
        }

        private boolean aggregateExpirationHoursIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean traceExpirationHoursIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean gaugeExpirationHoursIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean cappedDatabaseSizeMbIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.aggregateExpirationHoursIsSet()) {
                attributes.add("aggregateExpirationHours");
            }
            if (!this.traceExpirationHoursIsSet()) {
                attributes.add("traceExpirationHours");
            }
            if (!this.gaugeExpirationHoursIsSet()) {
                attributes.add("gaugeExpirationHours");
            }
            if (!this.cappedDatabaseSizeMbIsSet()) {
                attributes.add("cappedDatabaseSizeMb");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build StorageConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

