/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.AggregateMerging;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;

@ParametersAreNonnullByDefault
@Immutable
public final class ThreadInfoAggregate
extends AggregateMerging.ThreadInfoAggregateBase {
    @Nullable
    private final Long totalCpuMicros;
    @Nullable
    private final Long totalBlockedMicros;
    @Nullable
    private final Long totalWaitedMicros;
    @Nullable
    private final Long totalAllocatedKBytes;

    private ThreadInfoAggregate(@Nullable Long totalCpuMicros, @Nullable Long totalBlockedMicros, @Nullable Long totalWaitedMicros, @Nullable Long totalAllocatedKBytes) {
        this.totalCpuMicros = totalCpuMicros;
        this.totalBlockedMicros = totalBlockedMicros;
        this.totalWaitedMicros = totalWaitedMicros;
        this.totalAllocatedKBytes = totalAllocatedKBytes;
    }

    @Override
    @JsonProperty(value="totalCpuMicros")
    public Long totalCpuMicros() {
        return this.totalCpuMicros;
    }

    @Override
    @JsonProperty(value="totalBlockedMicros")
    public Long totalBlockedMicros() {
        return this.totalBlockedMicros;
    }

    @Override
    @JsonProperty(value="totalWaitedMicros")
    public Long totalWaitedMicros() {
        return this.totalWaitedMicros;
    }

    @Override
    @JsonProperty(value="totalAllocatedKBytes")
    public Long totalAllocatedKBytes() {
        return this.totalAllocatedKBytes;
    }

    public final ThreadInfoAggregate withTotalCpuMicros(@Nullable Long value) {
        if (this.totalCpuMicros == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoAggregate(newValue, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes);
    }

    public final ThreadInfoAggregate withTotalBlockedMicros(@Nullable Long value) {
        if (this.totalBlockedMicros == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoAggregate(this.totalCpuMicros, newValue, this.totalWaitedMicros, this.totalAllocatedKBytes);
    }

    public final ThreadInfoAggregate withTotalWaitedMicros(@Nullable Long value) {
        if (this.totalWaitedMicros == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoAggregate(this.totalCpuMicros, this.totalBlockedMicros, newValue, this.totalAllocatedKBytes);
    }

    public final ThreadInfoAggregate withTotalAllocatedKBytes(@Nullable Long value) {
        if (this.totalAllocatedKBytes == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoAggregate(this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ThreadInfoAggregate && this.equalTo((ThreadInfoAggregate)another);
    }

    private boolean equalTo(ThreadInfoAggregate another) {
        return Objects.equal(this.totalCpuMicros, another.totalCpuMicros) && Objects.equal(this.totalBlockedMicros, another.totalBlockedMicros) && Objects.equal(this.totalWaitedMicros, another.totalWaitedMicros) && Objects.equal(this.totalAllocatedKBytes, another.totalAllocatedKBytes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.totalCpuMicros);
        h = h * 17 + Objects.hashCode(this.totalBlockedMicros);
        h = h * 17 + Objects.hashCode(this.totalWaitedMicros);
        h = h * 17 + Objects.hashCode(this.totalAllocatedKBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThreadInfoAggregate").add("totalCpuMicros", this.totalCpuMicros).add("totalBlockedMicros", this.totalBlockedMicros).add("totalWaitedMicros", this.totalWaitedMicros).add("totalAllocatedKBytes", this.totalAllocatedKBytes).toString();
    }

    @JsonCreator
    public static ThreadInfoAggregate fromAllAttributes(@JsonProperty(value="totalCpuMicros") @Nullable Long totalCpuMicros, @JsonProperty(value="totalBlockedMicros") @Nullable Long totalBlockedMicros, @JsonProperty(value="totalWaitedMicros") @Nullable Long totalWaitedMicros, @JsonProperty(value="totalAllocatedKBytes") @Nullable Long totalAllocatedKBytes) {
        Builder builder = ThreadInfoAggregate.builder();
        if (totalCpuMicros != null) {
            builder.totalCpuMicros(totalCpuMicros);
        }
        if (totalBlockedMicros != null) {
            builder.totalBlockedMicros(totalBlockedMicros);
        }
        if (totalWaitedMicros != null) {
            builder.totalWaitedMicros(totalWaitedMicros);
        }
        if (totalAllocatedKBytes != null) {
            builder.totalAllocatedKBytes(totalAllocatedKBytes);
        }
        return builder.build();
    }

    public static ThreadInfoAggregate copyOf(AggregateMerging.ThreadInfoAggregateBase instance) {
        if (instance instanceof ThreadInfoAggregate) {
            return (ThreadInfoAggregate)instance;
        }
        return ThreadInfoAggregate.builder().all(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long totalCpuMicros;
        @Nullable
        private Long totalBlockedMicros;
        @Nullable
        private Long totalWaitedMicros;
        @Nullable
        private Long totalAllocatedKBytes;

        private Builder() {
        }

        public final Builder all(AggregateMerging.ThreadInfoAggregateBase instance) {
            Long totalAllocatedKBytesValue;
            Long totalWaitedMicrosValue;
            Long totalBlockedMicrosValue;
            Preconditions.checkNotNull(instance);
            Long totalCpuMicrosValue = instance.totalCpuMicros();
            if (totalCpuMicrosValue != null) {
                this.totalCpuMicros(totalCpuMicrosValue);
            }
            if ((totalBlockedMicrosValue = instance.totalBlockedMicros()) != null) {
                this.totalBlockedMicros(totalBlockedMicrosValue);
            }
            if ((totalWaitedMicrosValue = instance.totalWaitedMicros()) != null) {
                this.totalWaitedMicros(totalWaitedMicrosValue);
            }
            if ((totalAllocatedKBytesValue = instance.totalAllocatedKBytes()) != null) {
                this.totalAllocatedKBytes(totalAllocatedKBytesValue);
            }
            return this;
        }

        public final Builder totalCpuMicros(@Nullable Long totalCpuMicros) {
            this.totalCpuMicros = totalCpuMicros;
            return this;
        }

        public final Builder totalBlockedMicros(@Nullable Long totalBlockedMicros) {
            this.totalBlockedMicros = totalBlockedMicros;
            return this;
        }

        public final Builder totalWaitedMicros(@Nullable Long totalWaitedMicros) {
            this.totalWaitedMicros = totalWaitedMicros;
            return this;
        }

        public final Builder totalAllocatedKBytes(@Nullable Long totalAllocatedKBytes) {
            this.totalAllocatedKBytes = totalAllocatedKBytes;
            return this;
        }

        public ThreadInfoAggregate build() {
            return new ThreadInfoAggregate(this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes);
        }
    }
}

